/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.team.HasTeamFileEventsValue;
import com.dropbox.core.v2.team.HasTeamSharedDropboxValue;
import com.dropbox.core.v2.team.UploadApiRateLimitValue;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class FeatureValue {
    public static final FeatureValue OTHER = new FeatureValue().withTag(Tag.OTHER);
    private Tag _tag;
    private UploadApiRateLimitValue uploadApiRateLimitValue;
    private HasTeamSharedDropboxValue hasTeamSharedDropboxValue;
    private HasTeamFileEventsValue hasTeamFileEventsValue;

    private FeatureValue() {
    }

    private FeatureValue withTag(Tag _tag) {
        FeatureValue result = new FeatureValue();
        result._tag = _tag;
        return result;
    }

    private FeatureValue withTagAndUploadApiRateLimit(Tag _tag, UploadApiRateLimitValue uploadApiRateLimitValue) {
        FeatureValue result = new FeatureValue();
        result._tag = _tag;
        result.uploadApiRateLimitValue = uploadApiRateLimitValue;
        return result;
    }

    private FeatureValue withTagAndHasTeamSharedDropbox(Tag _tag, HasTeamSharedDropboxValue hasTeamSharedDropboxValue) {
        FeatureValue result = new FeatureValue();
        result._tag = _tag;
        result.hasTeamSharedDropboxValue = hasTeamSharedDropboxValue;
        return result;
    }

    private FeatureValue withTagAndHasTeamFileEvents(Tag _tag, HasTeamFileEventsValue hasTeamFileEventsValue) {
        FeatureValue result = new FeatureValue();
        result._tag = _tag;
        result.hasTeamFileEventsValue = hasTeamFileEventsValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isUploadApiRateLimit() {
        return this._tag == Tag.UPLOAD_API_RATE_LIMIT;
    }

    public static FeatureValue uploadApiRateLimit(UploadApiRateLimitValue value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new FeatureValue().withTagAndUploadApiRateLimit(Tag.UPLOAD_API_RATE_LIMIT, value);
    }

    public UploadApiRateLimitValue getUploadApiRateLimitValue() {
        if (this._tag != Tag.UPLOAD_API_RATE_LIMIT) {
            throw new IllegalStateException("Invalid tag: required Tag.UPLOAD_API_RATE_LIMIT, but was Tag." + this._tag.name());
        }
        return this.uploadApiRateLimitValue;
    }

    public boolean isHasTeamSharedDropbox() {
        return this._tag == Tag.HAS_TEAM_SHARED_DROPBOX;
    }

    public static FeatureValue hasTeamSharedDropbox(HasTeamSharedDropboxValue value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new FeatureValue().withTagAndHasTeamSharedDropbox(Tag.HAS_TEAM_SHARED_DROPBOX, value);
    }

    public HasTeamSharedDropboxValue getHasTeamSharedDropboxValue() {
        if (this._tag != Tag.HAS_TEAM_SHARED_DROPBOX) {
            throw new IllegalStateException("Invalid tag: required Tag.HAS_TEAM_SHARED_DROPBOX, but was Tag." + this._tag.name());
        }
        return this.hasTeamSharedDropboxValue;
    }

    public boolean isHasTeamFileEvents() {
        return this._tag == Tag.HAS_TEAM_FILE_EVENTS;
    }

    public static FeatureValue hasTeamFileEvents(HasTeamFileEventsValue value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new FeatureValue().withTagAndHasTeamFileEvents(Tag.HAS_TEAM_FILE_EVENTS, value);
    }

    public HasTeamFileEventsValue getHasTeamFileEventsValue() {
        if (this._tag != Tag.HAS_TEAM_FILE_EVENTS) {
            throw new IllegalStateException("Invalid tag: required Tag.HAS_TEAM_FILE_EVENTS, but was Tag." + this._tag.name());
        }
        return this.hasTeamFileEventsValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.uploadApiRateLimitValue, this.hasTeamSharedDropboxValue, this.hasTeamFileEventsValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof FeatureValue) {
            FeatureValue other = (FeatureValue)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case UPLOAD_API_RATE_LIMIT: {
                    return this.uploadApiRateLimitValue == other.uploadApiRateLimitValue || this.uploadApiRateLimitValue.equals(other.uploadApiRateLimitValue);
                }
                case HAS_TEAM_SHARED_DROPBOX: {
                    return this.hasTeamSharedDropboxValue == other.hasTeamSharedDropboxValue || this.hasTeamSharedDropboxValue.equals(other.hasTeamSharedDropboxValue);
                }
                case HAS_TEAM_FILE_EVENTS: {
                    return this.hasTeamFileEventsValue == other.hasTeamFileEventsValue || this.hasTeamFileEventsValue.equals(other.hasTeamFileEventsValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<FeatureValue> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(FeatureValue value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case UPLOAD_API_RATE_LIMIT: {
                    g.writeStartObject();
                    this.writeTag("upload_api_rate_limit", g);
                    g.writeFieldName("upload_api_rate_limit");
                    UploadApiRateLimitValue.Serializer.INSTANCE.serialize(value.uploadApiRateLimitValue, g);
                    g.writeEndObject();
                    break;
                }
                case HAS_TEAM_SHARED_DROPBOX: {
                    g.writeStartObject();
                    this.writeTag("has_team_shared_dropbox", g);
                    g.writeFieldName("has_team_shared_dropbox");
                    HasTeamSharedDropboxValue.Serializer.INSTANCE.serialize(value.hasTeamSharedDropboxValue, g);
                    g.writeEndObject();
                    break;
                }
                case HAS_TEAM_FILE_EVENTS: {
                    g.writeStartObject();
                    this.writeTag("has_team_file_events", g);
                    g.writeFieldName("has_team_file_events");
                    HasTeamFileEventsValue.Serializer.INSTANCE.serialize(value.hasTeamFileEventsValue, g);
                    g.writeEndObject();
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public FeatureValue deserialize(JsonParser p) throws IOException, JsonParseException {
            FeatureValue value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("upload_api_rate_limit".equals(tag)) {
                UploadApiRateLimitValue fieldValue = null;
                Serializer.expectField("upload_api_rate_limit", p);
                fieldValue = UploadApiRateLimitValue.Serializer.INSTANCE.deserialize(p);
                value = FeatureValue.uploadApiRateLimit(fieldValue);
            } else if ("has_team_shared_dropbox".equals(tag)) {
                HasTeamSharedDropboxValue fieldValue = null;
                Serializer.expectField("has_team_shared_dropbox", p);
                fieldValue = HasTeamSharedDropboxValue.Serializer.INSTANCE.deserialize(p);
                value = FeatureValue.hasTeamSharedDropbox(fieldValue);
            } else if ("has_team_file_events".equals(tag)) {
                HasTeamFileEventsValue fieldValue = null;
                Serializer.expectField("has_team_file_events", p);
                fieldValue = HasTeamFileEventsValue.Serializer.INSTANCE.deserialize(p);
                value = FeatureValue.hasTeamFileEvents(fieldValue);
            } else {
                value = OTHER;
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        UPLOAD_API_RATE_LIMIT,
        HAS_TEAM_SHARED_DROPBOX,
        HAS_TEAM_FILE_EVENTS,
        OTHER;

    }
}

