/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public class UserInfo {
    protected final String accountId;
    protected final boolean sameTeam;
    protected final String teamMemberId;

    public UserInfo(String accountId, boolean sameTeam, String teamMemberId) {
        if (accountId == null) {
            throw new IllegalArgumentException("Required value for 'accountId' is null");
        }
        if (accountId.length() < 40) {
            throw new IllegalArgumentException("String 'accountId' is shorter than 40");
        }
        if (accountId.length() > 40) {
            throw new IllegalArgumentException("String 'accountId' is longer than 40");
        }
        this.accountId = accountId;
        this.sameTeam = sameTeam;
        this.teamMemberId = teamMemberId;
    }

    public UserInfo(String accountId, boolean sameTeam) {
        this(accountId, sameTeam, null);
    }

    public String getAccountId() {
        return this.accountId;
    }

    public boolean getSameTeam() {
        return this.sameTeam;
    }

    public String getTeamMemberId() {
        return this.teamMemberId;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.accountId, this.sameTeam, this.teamMemberId});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            UserInfo other = (UserInfo)obj;
            return (this.accountId == other.accountId || this.accountId.equals(other.accountId)) && this.sameTeam == other.sameTeam && (this.teamMemberId == other.teamMemberId || this.teamMemberId != null && this.teamMemberId.equals(other.teamMemberId));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    public static class Serializer
    extends StructSerializer<UserInfo> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public void serialize(UserInfo value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("account_id");
            StoneSerializers.string().serialize(value.accountId, g);
            g.writeFieldName("same_team");
            StoneSerializers.boolean_().serialize((Boolean)value.sameTeam, g);
            if (value.teamMemberId != null) {
                g.writeFieldName("team_member_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.teamMemberId, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public UserInfo deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_teamMemberId;
            Boolean f_sameTeam;
            String f_accountId;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_accountId = null;
                f_sameTeam = null;
                f_teamMemberId = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("account_id".equals(field)) {
                        f_accountId = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("same_team".equals(field)) {
                        f_sameTeam = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("team_member_id".equals(field)) {
                        f_teamMemberId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_accountId == null) {
                    throw new JsonParseException(p, "Required field \"account_id\" missing.");
                }
                if (f_sameTeam == null) {
                    throw new JsonParseException(p, "Required field \"same_team\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            UserInfo value = new UserInfo(f_accountId, f_sameTeam, f_teamMemberId);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }
}

