/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.subtle;

import com.google.crypto.tink.AccessesPartialKey;
import com.google.crypto.tink.InsecureSecretKeyAccess;
import com.google.crypto.tink.PublicKeySign;
import com.google.crypto.tink.PublicKeyVerify;
import com.google.crypto.tink.config.internal.TinkFipsUtil;
import com.google.crypto.tink.signature.EcdsaParameters;
import com.google.crypto.tink.signature.EcdsaPrivateKey;
import com.google.crypto.tink.subtle.Bytes;
import com.google.crypto.tink.subtle.EcdsaVerifyJce;
import com.google.crypto.tink.subtle.EllipticCurves;
import com.google.crypto.tink.subtle.EngineFactory;
import com.google.crypto.tink.subtle.Enums;
import com.google.crypto.tink.subtle.SubtleUtil;
import com.google.errorprone.annotations.Immutable;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.Signature;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.EllipticCurve;
import java.util.List;

@Immutable
public final class EcdsaSignJce
implements PublicKeySign {
    public static final TinkFipsUtil.AlgorithmFipsCompatibility FIPS = TinkFipsUtil.AlgorithmFipsCompatibility.ALGORITHM_REQUIRES_BORINGCRYPTO;
    private static final byte[] EMPTY = new byte[0];
    private static final byte[] LEGACY_MESSAGE_SUFFIX = new byte[]{0};
    private static final byte[] TEST_DATA = new byte[]{1, 2, 3};
    private final ECPrivateKey privateKey;
    private final String signatureAlgorithm;
    private final EllipticCurves.EcdsaEncoding encoding;
    private final byte[] outputPrefix;
    private final byte[] messageSuffix;

    private EcdsaSignJce(ECPrivateKey priv, Enums.HashType hash, EllipticCurves.EcdsaEncoding encoding, byte[] outputPrefix, byte[] messageSuffix) throws GeneralSecurityException {
        if (!FIPS.isCompatible()) {
            throw new GeneralSecurityException("Can not use ECDSA in FIPS-mode, as BoringCrypto is not available.");
        }
        this.privateKey = priv;
        this.signatureAlgorithm = SubtleUtil.toEcdsaAlgo(hash);
        this.encoding = encoding;
        this.outputPrefix = outputPrefix;
        this.messageSuffix = messageSuffix;
    }

    public EcdsaSignJce(ECPrivateKey priv, Enums.HashType hash, EllipticCurves.EcdsaEncoding encoding) throws GeneralSecurityException {
        this(priv, hash, encoding, EMPTY, EMPTY);
    }

    @AccessesPartialKey
    public static PublicKeySign create(EcdsaPrivateKey key) throws GeneralSecurityException {
        Enums.HashType hashType = EcdsaVerifyJce.HASH_TYPE_CONVERTER.toProtoEnum(key.getParameters().getHashType());
        EllipticCurves.EcdsaEncoding ecdsaEncoding = EcdsaVerifyJce.ENCODING_CONVERTER.toProtoEnum(key.getParameters().getSignatureEncoding());
        EllipticCurves.CurveType curveType = EcdsaVerifyJce.CURVE_TYPE_CONVERTER.toProtoEnum(key.getParameters().getCurveType());
        ECPrivateKey privateKey = EllipticCurves.getEcPrivateKey(curveType, key.getPrivateValue().getBigInteger(InsecureSecretKeyAccess.get()).toByteArray());
        EcdsaSignJce signer = new EcdsaSignJce(privateKey, hashType, ecdsaEncoding, key.getOutputPrefix().toByteArray(), key.getParameters().getVariant().equals(EcdsaParameters.Variant.LEGACY) ? LEGACY_MESSAGE_SUFFIX : EMPTY);
        PublicKeyVerify verify = EcdsaVerifyJce.create(key.getPublicKey());
        try {
            verify.verify(signer.sign(TEST_DATA), TEST_DATA);
        }
        catch (GeneralSecurityException e) {
            throw new GeneralSecurityException("ECDSA signing with private key followed by verifying with public key failed. The key may be corrupted.", e);
        }
        return signer;
    }

    @Override
    public byte[] sign(byte[] data) throws GeneralSecurityException {
        List<Provider> preferredProviders = EngineFactory.toProviderList("GmsCore_OpenSSL", "AndroidOpenSSL", "Conscrypt");
        Signature signer = EngineFactory.SIGNATURE.getInstance(this.signatureAlgorithm, preferredProviders);
        signer.initSign(this.privateKey);
        signer.update(data);
        if (this.messageSuffix.length > 0) {
            signer.update(this.messageSuffix);
        }
        byte[] signature = signer.sign();
        if (this.encoding == EllipticCurves.EcdsaEncoding.IEEE_P1363) {
            EllipticCurve curve = this.privateKey.getParams().getCurve();
            signature = EllipticCurves.ecdsaDer2Ieee(signature, 2 * EllipticCurves.fieldSizeInBytes(curve));
        }
        if (this.outputPrefix.length == 0) {
            return signature;
        }
        return Bytes.concat(this.outputPrefix, signature);
    }
}

