/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.handle;

import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.GuildChannel;
import net.dv8tion.jda.api.events.interaction.GenericInteractionCreateEvent;
import net.dv8tion.jda.api.events.interaction.command.CommandAutoCompleteInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.MessageContextInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.UserContextInteractionEvent;
import net.dv8tion.jda.api.events.interaction.component.ButtonInteractionEvent;
import net.dv8tion.jda.api.events.interaction.component.SelectMenuInteractionEvent;
import net.dv8tion.jda.api.interactions.InteractionType;
import net.dv8tion.jda.api.interactions.commands.Command;
import net.dv8tion.jda.api.interactions.components.Component;
import net.dv8tion.jda.api.utils.data.DataObject;
import net.dv8tion.jda.internal.JDAImpl;
import net.dv8tion.jda.internal.handle.SocketHandler;
import net.dv8tion.jda.internal.interactions.InteractionImpl;
import net.dv8tion.jda.internal.interactions.command.CommandAutoCompleteInteractionImpl;
import net.dv8tion.jda.internal.interactions.command.MessageContextInteractionImpl;
import net.dv8tion.jda.internal.interactions.command.SlashCommandInteractionImpl;
import net.dv8tion.jda.internal.interactions.command.UserContextInteractionImpl;
import net.dv8tion.jda.internal.interactions.component.ButtonInteractionImpl;
import net.dv8tion.jda.internal.interactions.component.SelectMenuInteractionImpl;
import net.dv8tion.jda.internal.requests.WebSocketClient;

public class InteractionCreateHandler
extends SocketHandler {
    public InteractionCreateHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(DataObject content) {
        GuildChannel channel;
        int type = content.getInt("type");
        if (content.getInt("version", 1) != 1) {
            WebSocketClient.LOG.debug("Received interaction with version {}. This version is currently unsupported by this version of JDA. Consider updating!", (Object)content.getInt("version", 1));
            return null;
        }
        long guildId = content.getUnsignedLong("guild_id", 0L);
        Guild guild = this.api.getGuildById(guildId);
        if (this.api.getGuildSetupController().isLocked(guildId)) {
            return guildId;
        }
        if (guildId != 0L && guild == null) {
            return null;
        }
        if (!(guild == null || (channel = guild.getGuildChannelById(content.getUnsignedLong("channel_id", 0L))) != null && channel.getType().isMessage())) {
            WebSocketClient.LOG.debug("Discarding INTERACTION_CREATE event from unexpected channel type. Channel: {}", (Object)channel);
            return null;
        }
        switch (InteractionType.fromKey(type)) {
            case COMMAND: {
                this.handleCommand(content);
                break;
            }
            case COMPONENT: {
                this.handleAction(content);
                break;
            }
            case COMMAND_AUTOCOMPLETE: {
                this.api.handleEvent(new CommandAutoCompleteInteractionEvent((JDA)this.api, this.responseNumber, new CommandAutoCompleteInteractionImpl(this.api, content)));
                break;
            }
            default: {
                this.api.handleEvent(new GenericInteractionCreateEvent(this.api, this.responseNumber, new InteractionImpl(this.api, content)));
            }
        }
        return null;
    }

    private void handleCommand(DataObject content) {
        switch (Command.Type.fromId(content.getObject("data").getInt("type"))) {
            case SLASH: {
                this.api.handleEvent(new SlashCommandInteractionEvent((JDA)this.api, this.responseNumber, new SlashCommandInteractionImpl(this.api, content)));
                break;
            }
            case MESSAGE: {
                this.api.handleEvent(new MessageContextInteractionEvent((JDA)this.api, this.responseNumber, new MessageContextInteractionImpl(this.api, content)));
                break;
            }
            case USER: {
                this.api.handleEvent(new UserContextInteractionEvent((JDA)this.api, this.responseNumber, new UserContextInteractionImpl(this.api, content)));
            }
        }
    }

    private void handleAction(DataObject content) {
        switch (Component.Type.fromKey(content.getObject("data").getInt("component_type"))) {
            case BUTTON: {
                this.api.handleEvent(new ButtonInteractionEvent((JDA)this.api, this.responseNumber, new ButtonInteractionImpl(this.api, content)));
                break;
            }
            case SELECT_MENU: {
                this.api.handleEvent(new SelectMenuInteractionEvent((JDA)this.api, this.responseNumber, new SelectMenuInteractionImpl(this.api, content)));
            }
        }
    }
}

