/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.handle;

import net.dv8tion.jda.api.entities.ChannelType;
import net.dv8tion.jda.api.entities.MessageChannel;
import net.dv8tion.jda.api.entities.MessageType;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.utils.data.DataObject;
import net.dv8tion.jda.internal.JDAImpl;
import net.dv8tion.jda.internal.entities.ReceivedMessage;
import net.dv8tion.jda.internal.entities.ThreadChannelImpl;
import net.dv8tion.jda.internal.entities.mixin.channel.middleman.MessageChannelMixin;
import net.dv8tion.jda.internal.handle.EventCache;
import net.dv8tion.jda.internal.handle.SocketHandler;
import net.dv8tion.jda.internal.requests.WebSocketClient;

public class MessageCreateHandler
extends SocketHandler {
    public MessageCreateHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(DataObject content) {
        ReceivedMessage message;
        boolean isGuild;
        MessageType type = MessageType.fromId(content.getInt("type"));
        if (type == MessageType.UNKNOWN) {
            WebSocketClient.LOG.debug("JDA received a message of unknown type. Type: {}  JSON: {}", (Object)type, (Object)content);
            return null;
        }
        JDAImpl jda = this.getJDA();
        boolean bl = isGuild = !content.isNull("guild_id");
        if (isGuild) {
            long guildId = content.getLong("guild_id");
            if (jda.getGuildSetupController().isLocked(guildId)) {
                return guildId;
            }
        }
        try {
            message = isGuild ? jda.getEntityBuilder().createMessageGuildChannel(content, true) : jda.getEntityBuilder().createMessagePrivateChannel(content, true);
        }
        catch (IllegalArgumentException e) {
            switch (e.getMessage()) {
                case "MISSING_CHANNEL": {
                    long channelId = content.getLong("channel_id");
                    jda.getEventCache().cache(EventCache.Type.CHANNEL, channelId, this.responseNumber, this.allContent, this::handle);
                    EventCache.LOG.debug("Received a message for a channel that JDA does not currently have cached");
                    return null;
                }
                case "MISSING_USER": {
                    long authorId = content.getObject("author").getLong("id");
                    jda.getEventCache().cache(EventCache.Type.USER, authorId, this.responseNumber, this.allContent, this::handle);
                    EventCache.LOG.debug("Received a message for a user that JDA does not currently have cached");
                    return null;
                }
                case "UNKNOWN_MESSAGE_TYPE": {
                    WebSocketClient.LOG.debug("Ignoring message with unknown type: {}", (Object)content);
                    return null;
                }
            }
            throw e;
        }
        MessageChannel channel = message.getChannel();
        ChannelType channelType = channel.getType();
        ((MessageChannelMixin)channel).setLatestMessageIdLong(message.getIdLong());
        if (channelType.isGuild()) {
            if (channelType.isThread()) {
                ThreadChannelImpl gThread = (ThreadChannelImpl)channel;
                int newMessageCount = Math.min(gThread.getMessageCount() + 1, 50);
                gThread.setMessageCount(newMessageCount);
            }
        } else {
            this.api.usedPrivateChannel(channel.getIdLong());
        }
        jda.handleEvent(new MessageReceivedEvent(jda, this.responseNumber, message));
        return null;
    }
}

