/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.interactions.commands;

import gnu.trove.map.TLongObjectMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.entities.AudioChannel;
import net.dv8tion.jda.api.entities.Channel;
import net.dv8tion.jda.api.entities.ChannelType;
import net.dv8tion.jda.api.entities.GuildChannel;
import net.dv8tion.jda.api.entities.GuildMessageChannel;
import net.dv8tion.jda.api.entities.IMentionable;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.NewsChannel;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.StageChannel;
import net.dv8tion.jda.api.entities.TextChannel;
import net.dv8tion.jda.api.entities.ThreadChannel;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.VoiceChannel;
import net.dv8tion.jda.api.interactions.commands.OptionType;
import net.dv8tion.jda.api.utils.data.DataObject;

public class OptionMapping {
    private final DataObject data;
    private final OptionType type;
    private final String name;
    private final TLongObjectMap<Object> resolved;

    public OptionMapping(DataObject data, TLongObjectMap<Object> resolved) {
        this.data = data;
        this.type = OptionType.fromKey(data.getInt("type", -1));
        this.name = data.getString("name");
        this.resolved = resolved;
    }

    private <T, C extends Collection<T>> C parseMentions(C coll, Pattern pattern, boolean duplicates, Function<Matcher, T> resolver) {
        Matcher matcher = pattern.matcher(this.getAsString());
        while (matcher.find()) {
            try {
                T obj = resolver.apply(matcher);
                if (obj == null || !duplicates && coll.contains(obj)) continue;
                coll.add(obj);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return coll;
    }

    @Nonnull
    public List<Member> getMentionedMembers() {
        if (this.type != OptionType.STRING) {
            return Collections.emptyList();
        }
        return this.parseMentions(new ArrayList(), Message.MentionType.USER.getPattern(), false, matcher -> {
            long id = Long.parseUnsignedLong(matcher.group(1));
            Object obj = this.resolved.get(id);
            return obj instanceof Member ? (Member)obj : null;
        });
    }

    @Nonnull
    public List<User> getMentionedUsers() {
        if (this.type != OptionType.STRING) {
            return Collections.emptyList();
        }
        return this.parseMentions(new ArrayList(), Message.MentionType.USER.getPattern(), false, matcher -> {
            long id = Long.parseUnsignedLong(matcher.group(1));
            Object obj = this.resolved.get(id);
            if (obj instanceof User) {
                return (User)obj;
            }
            if (obj instanceof Member) {
                return ((Member)obj).getUser();
            }
            return null;
        });
    }

    @Nonnull
    public List<Role> getMentionedRoles() {
        if (this.type != OptionType.STRING) {
            return Collections.emptyList();
        }
        return this.parseMentions(new ArrayList(), Message.MentionType.ROLE.getPattern(), false, matcher -> {
            long id = Long.parseUnsignedLong(matcher.group(1));
            Object obj = this.resolved.get(id);
            return obj instanceof Role ? (Role)obj : null;
        });
    }

    @Nonnull
    public List<GuildChannel> getMentionedChannels() {
        if (this.type != OptionType.STRING) {
            return Collections.emptyList();
        }
        return this.parseMentions(new ArrayList(), Message.MentionType.CHANNEL.getPattern(), false, matcher -> {
            long id = Long.parseUnsignedLong(matcher.group(1));
            Object obj = this.resolved.get(id);
            return obj instanceof GuildChannel ? (GuildChannel)obj : null;
        });
    }

    @Nonnull
    public List<IMentionable> getMentions() {
        if (this.type != OptionType.STRING) {
            return Collections.emptyList();
        }
        List<User> users = this.getMentionedUsers();
        List<Member> members = this.getMentionedMembers();
        List<Role> roles = this.getMentionedRoles();
        List<GuildChannel> channels = this.getMentionedChannels();
        users.removeIf(user -> members.stream().anyMatch(m -> m.getIdLong() == user.getIdLong()));
        ArrayList<IMentionable> mentions = new ArrayList<IMentionable>(users.size() + members.size() + roles.size() + channels.size());
        mentions.addAll(users);
        mentions.addAll(members);
        mentions.addAll(roles);
        mentions.addAll(channels);
        mentions.sort(Comparator.comparingInt(mention -> this.getAsString().indexOf(mention.getId())));
        return mentions;
    }

    @Nonnull
    public OptionType getType() {
        return this.type;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public Message.Attachment getAsAttachment() {
        Object obj = this.resolved.get(this.getAsLong());
        if (obj instanceof Message.Attachment) {
            return (Message.Attachment)obj;
        }
        throw new IllegalStateException("Cannot resolve option of type " + (Object)((Object)this.type) + " to Attachment!");
    }

    @Nonnull
    public String getAsString() {
        return this.data.getString("value");
    }

    public boolean getAsBoolean() {
        if (this.type != OptionType.BOOLEAN) {
            throw new IllegalStateException("Cannot convert option of type " + (Object)((Object)this.type) + " to boolean");
        }
        return this.data.getBoolean("value");
    }

    public long getAsLong() {
        switch (this.type) {
            default: {
                throw new IllegalStateException("Cannot convert option of type " + (Object)((Object)this.type) + " to long");
            }
            case STRING: 
            case MENTIONABLE: 
            case CHANNEL: 
            case ROLE: 
            case USER: 
            case INTEGER: 
            case ATTACHMENT: 
        }
        return this.data.getLong("value");
    }

    public double getAsDouble() {
        switch (this.type) {
            default: {
                throw new IllegalStateException("Cannot convert option of type " + (Object)((Object)this.type) + " to double");
            }
            case STRING: 
            case INTEGER: 
            case NUMBER: 
        }
        return this.data.getDouble("value");
    }

    @Nonnull
    public IMentionable getAsMentionable() {
        Object entity = this.resolved.get(this.getAsLong());
        if (entity instanceof IMentionable) {
            return (IMentionable)entity;
        }
        throw new IllegalStateException("Cannot resolve option of type " + (Object)((Object)this.type) + " to IMentionable");
    }

    @Nullable
    public Member getAsMember() {
        if (this.type != OptionType.USER && this.type != OptionType.MENTIONABLE) {
            throw new IllegalStateException("Cannot resolve Member for option " + this.getName() + " of type " + (Object)((Object)this.type));
        }
        Object object = this.resolved.get(this.getAsLong());
        if (object instanceof Member) {
            return (Member)object;
        }
        return null;
    }

    @Nonnull
    public User getAsUser() {
        if (this.type != OptionType.USER && this.type != OptionType.MENTIONABLE) {
            throw new IllegalStateException("Cannot resolve User for option " + this.getName() + " of type " + (Object)((Object)this.type));
        }
        Object object = this.resolved.get(this.getAsLong());
        if (object instanceof Member) {
            return ((Member)object).getUser();
        }
        if (object instanceof User) {
            return (User)object;
        }
        throw new IllegalStateException("Could not resolve User from option type " + (Object)((Object)this.type));
    }

    @Nonnull
    public Role getAsRole() {
        if (this.type != OptionType.ROLE && this.type != OptionType.MENTIONABLE) {
            throw new IllegalStateException("Cannot resolve Role for option " + this.getName() + " of type " + (Object)((Object)this.type));
        }
        Object role = this.resolved.get(this.getAsLong());
        if (role instanceof Role) {
            return (Role)role;
        }
        throw new IllegalStateException("Could not resolve Role from option type " + (Object)((Object)this.type));
    }

    @Nonnull
    public ChannelType getChannelType() {
        Channel channel = this.getAsChannel();
        return channel == null ? ChannelType.UNKNOWN : channel.getType();
    }

    @Nonnull
    public GuildChannel getAsGuildChannel() {
        Channel value = this.getAsChannel();
        if (value instanceof GuildChannel) {
            return (GuildChannel)value;
        }
        throw new IllegalStateException("Could not resolve GuildChannel!");
    }

    @Nullable
    public GuildMessageChannel getAsMessageChannel() {
        Channel value = this.getAsChannel();
        return value instanceof GuildMessageChannel ? (GuildMessageChannel)value : null;
    }

    @Nullable
    public TextChannel getAsTextChannel() {
        Channel channel = this.getAsChannel();
        return channel instanceof TextChannel ? (TextChannel)channel : null;
    }

    @Nullable
    public NewsChannel getAsNewsChannel() {
        Channel channel = this.getAsChannel();
        return channel instanceof NewsChannel ? (NewsChannel)channel : null;
    }

    @Nullable
    public ThreadChannel getAsThreadChannel() {
        Channel channel = this.getAsChannel();
        return channel instanceof ThreadChannel ? (ThreadChannel)channel : null;
    }

    @Nullable
    public AudioChannel getAsAudioChannel() {
        Channel channel = this.getAsChannel();
        return channel instanceof AudioChannel ? (AudioChannel)channel : null;
    }

    @Nullable
    public VoiceChannel getAsVoiceChannel() {
        Channel channel = this.getAsChannel();
        return channel instanceof VoiceChannel ? (VoiceChannel)channel : null;
    }

    @Nullable
    public StageChannel getAsStageChannel() {
        Channel channel = this.getAsChannel();
        return channel instanceof StageChannel ? (StageChannel)channel : null;
    }

    public String toString() {
        return "Option[" + (Object)((Object)this.getType()) + "](" + this.getName() + "=" + this.getAsString() + ")";
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getType(), this.getName()});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OptionMapping)) {
            return false;
        }
        OptionMapping data = (OptionMapping)obj;
        return this.getType() == data.getType() && this.getName().equals(data.getName());
    }

    @Nullable
    private Channel getAsChannel() {
        if (this.type != OptionType.CHANNEL) {
            throw new IllegalStateException("Cannot resolve Channel for option " + this.getName() + " of type " + (Object)((Object)this.type));
        }
        return (Channel)this.resolved.get(this.getAsLong());
    }
}

