/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.requests.restaction.pagination;

import gnu.trove.map.hash.TLongObjectHashMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.IThreadContainer;
import net.dv8tion.jda.api.entities.ThreadChannel;
import net.dv8tion.jda.api.exceptions.ParsingException;
import net.dv8tion.jda.api.requests.Request;
import net.dv8tion.jda.api.requests.Response;
import net.dv8tion.jda.api.requests.restaction.pagination.ThreadChannelPaginationAction;
import net.dv8tion.jda.api.utils.TimeUtil;
import net.dv8tion.jda.api.utils.data.DataArray;
import net.dv8tion.jda.api.utils.data.DataObject;
import net.dv8tion.jda.internal.entities.EntityBuilder;
import net.dv8tion.jda.internal.requests.Route;
import net.dv8tion.jda.internal.requests.restaction.pagination.PaginationActionImpl;

public class ThreadChannelPaginationActionImpl
extends PaginationActionImpl<ThreadChannel, ThreadChannelPaginationAction>
implements ThreadChannelPaginationAction {
    protected final IThreadContainer channel;
    protected final boolean useID;

    public ThreadChannelPaginationActionImpl(JDA api, Route.CompiledRoute route, IThreadContainer channel, boolean useID) {
        super(api, route, 2, 100, 100);
        this.channel = channel;
        this.useID = useID;
    }

    @Override
    @Nonnull
    public IThreadContainer getChannel() {
        return this.channel;
    }

    @Override
    protected Route.CompiledRoute finalizeRoute() {
        Route.CompiledRoute route = super.finalizeRoute();
        String limit = String.valueOf(this.limit.get());
        long last = this.lastKey;
        route = route.withQueryParams("limit", limit);
        if (last == 0L) {
            return route;
        }
        if (this.useID) {
            return route.withQueryParams("before", Long.toUnsignedString(last));
        }
        return route.withQueryParams("before", TimeUtil.getTimeCreated(last).toString());
    }

    @Override
    protected void handleSuccess(Response response, Request<List<ThreadChannel>> request) {
        int i;
        DataObject obj = response.getObject();
        DataArray selfThreadMembers = obj.getArray("members");
        DataArray threads = obj.getArray("threads");
        ArrayList<ThreadChannel> list = new ArrayList<ThreadChannel>(threads.length());
        EntityBuilder builder = this.api.getEntityBuilder();
        TLongObjectHashMap<DataObject> selfThreadMemberMap = new TLongObjectHashMap<DataObject>();
        for (i = 0; i < selfThreadMembers.length(); ++i) {
            DataObject selfThreadMember = selfThreadMembers.getObject(i);
            selfThreadMemberMap.put(selfThreadMember.getLong("id"), selfThreadMember);
        }
        for (i = 0; i < threads.length(); ++i) {
            try {
                DataObject threadObj = threads.getObject(i);
                DataObject selfThreadMemberObj = (DataObject)selfThreadMemberMap.get(threadObj.getLong("id", 0L));
                if (selfThreadMemberObj != null) {
                    threadObj.put("member", selfThreadMemberObj);
                }
                ThreadChannel thread = builder.createThreadChannel(threadObj, this.getGuild().getIdLong());
                list.add(thread);
                if (this.useCache) {
                    this.cached.add(thread);
                }
                this.last = thread;
                this.lastKey = ((ThreadChannel)this.last).getIdLong();
                continue;
            }
            catch (NullPointerException | ParsingException e) {
                LOG.warn("Encountered exception in ThreadChannelPagination", e);
            }
        }
        request.onSuccess(list);
    }

    @Override
    protected long getKey(ThreadChannel it) {
        return it.getIdLong();
    }
}

