/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.entities.channel;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.entities.Category;
import net.dv8tion.jda.api.entities.Channel;
import net.dv8tion.jda.api.entities.ChannelType;
import net.dv8tion.jda.api.entities.GuildChannel;
import net.dv8tion.jda.api.entities.IMemberContainer;
import net.dv8tion.jda.api.entities.NewsChannel;
import net.dv8tion.jda.api.entities.StageChannel;
import net.dv8tion.jda.api.entities.StoreChannel;
import net.dv8tion.jda.api.entities.TextChannel;
import net.dv8tion.jda.api.entities.ThreadChannel;
import net.dv8tion.jda.api.entities.VoiceChannel;
import net.dv8tion.jda.api.utils.MiscUtil;
import net.dv8tion.jda.api.utils.cache.SnowflakeCacheView;
import net.dv8tion.jda.internal.utils.Checks;

public interface IGuildChannelContainer {
    @Nullable
    default public <T extends Channel> T getChannelById(@Nonnull Class<T> type, @Nonnull String id) {
        return this.getChannelById(type, MiscUtil.parseSnowflake(id));
    }

    @Nullable
    default public <T extends Channel> T getChannelById(@Nonnull Class<T> type, long id) {
        Checks.notNull(type, "Class");
        GuildChannel channel = this.getGuildChannelById(id);
        return (T)(type.isInstance(channel) ? (Channel)type.cast(channel) : null);
    }

    @Nullable
    default public GuildChannel getGuildChannelById(@Nonnull String id) {
        return this.getGuildChannelById(MiscUtil.parseSnowflake(id));
    }

    @Nullable
    default public GuildChannel getGuildChannelById(long id) {
        IMemberContainer channel = this.getTextChannelById(id);
        if (channel == null) {
            channel = this.getNewsChannelById(id);
        }
        if (channel == null) {
            channel = this.getVoiceChannelById(id);
        }
        if (channel == null) {
            channel = this.getStageChannelById(id);
        }
        if (channel == null) {
            channel = this.getStoreChannelById(id);
        }
        if (channel == null) {
            channel = this.getCategoryById(id);
        }
        if (channel == null) {
            channel = this.getThreadChannelById(id);
        }
        return channel;
    }

    @Nullable
    default public GuildChannel getGuildChannelById(@Nonnull ChannelType type, @Nonnull String id) {
        return this.getGuildChannelById(type, MiscUtil.parseSnowflake(id));
    }

    @Nullable
    default public GuildChannel getGuildChannelById(@Nonnull ChannelType type, long id) {
        Checks.notNull((Object)type, "ChannelType");
        switch (type) {
            case NEWS: {
                return this.getNewsChannelById(id);
            }
            case TEXT: {
                return this.getTextChannelById(id);
            }
            case VOICE: {
                return this.getVoiceChannelById(id);
            }
            case STAGE: {
                return this.getStageChannelById(id);
            }
            case STORE: {
                return this.getStoreChannelById(id);
            }
            case CATEGORY: {
                return this.getCategoryById(id);
            }
        }
        if (type.isThread()) {
            return this.getThreadChannelById(id);
        }
        return null;
    }

    @Nonnull
    public SnowflakeCacheView<StageChannel> getStageChannelCache();

    @Nonnull
    default public List<StageChannel> getStageChannelsByName(@Nonnull String name, boolean ignoreCase) {
        return this.getStageChannelCache().getElementsByName(name, ignoreCase);
    }

    @Nullable
    default public StageChannel getStageChannelById(@Nonnull String id) {
        return this.getStageChannelCache().getElementById(id);
    }

    @Nullable
    default public StageChannel getStageChannelById(long id) {
        return this.getStageChannelCache().getElementById(id);
    }

    @Nonnull
    default public List<StageChannel> getStageChannels() {
        return this.getStageChannelCache().asList();
    }

    @Nonnull
    public SnowflakeCacheView<ThreadChannel> getThreadChannelCache();

    @Nonnull
    default public List<ThreadChannel> getThreadChannelsByName(@Nonnull String name, boolean ignoreCase) {
        return this.getThreadChannelCache().getElementsByName(name, ignoreCase);
    }

    @Nullable
    default public ThreadChannel getThreadChannelById(@Nonnull String id) {
        return this.getThreadChannelCache().getElementById(id);
    }

    @Nullable
    default public ThreadChannel getThreadChannelById(long id) {
        return this.getThreadChannelCache().getElementById(id);
    }

    @Nonnull
    default public List<ThreadChannel> getThreadChannels() {
        return this.getThreadChannelCache().asList();
    }

    @Nonnull
    public SnowflakeCacheView<Category> getCategoryCache();

    @Nonnull
    default public List<Category> getCategoriesByName(@Nonnull String name, boolean ignoreCase) {
        return this.getCategoryCache().getElementsByName(name, ignoreCase);
    }

    @Nullable
    default public Category getCategoryById(@Nonnull String id) {
        return this.getCategoryCache().getElementById(id);
    }

    @Nullable
    default public Category getCategoryById(long id) {
        return this.getCategoryCache().getElementById(id);
    }

    @Nonnull
    default public List<Category> getCategories() {
        return this.getCategoryCache().asList();
    }

    @Nonnull
    public SnowflakeCacheView<StoreChannel> getStoreChannelCache();

    @Nonnull
    default public List<StoreChannel> getStoreChannelsByName(@Nonnull String name, boolean ignoreCase) {
        return this.getStoreChannelCache().getElementsByName(name, ignoreCase);
    }

    @Nullable
    default public StoreChannel getStoreChannelById(@Nonnull String id) {
        return this.getStoreChannelCache().getElementById(id);
    }

    @Nullable
    default public StoreChannel getStoreChannelById(long id) {
        return this.getStoreChannelCache().getElementById(id);
    }

    @Nonnull
    default public List<StoreChannel> getStoreChannels() {
        return this.getStoreChannelCache().asList();
    }

    @Nonnull
    public SnowflakeCacheView<TextChannel> getTextChannelCache();

    @Nonnull
    default public List<TextChannel> getTextChannelsByName(@Nonnull String name, boolean ignoreCase) {
        return this.getTextChannelCache().getElementsByName(name, ignoreCase);
    }

    @Nullable
    default public TextChannel getTextChannelById(@Nonnull String id) {
        return this.getTextChannelCache().getElementById(id);
    }

    @Nullable
    default public TextChannel getTextChannelById(long id) {
        return this.getTextChannelCache().getElementById(id);
    }

    @Nonnull
    default public List<TextChannel> getTextChannels() {
        return this.getTextChannelCache().asList();
    }

    @Nonnull
    public SnowflakeCacheView<NewsChannel> getNewsChannelCache();

    @Nonnull
    default public List<NewsChannel> getNewsChannelsByName(@Nonnull String name, boolean ignoreCase) {
        return this.getNewsChannelCache().getElementsByName(name, ignoreCase);
    }

    @Nullable
    default public NewsChannel getNewsChannelById(@Nonnull String id) {
        return this.getNewsChannelCache().getElementById(id);
    }

    @Nullable
    default public NewsChannel getNewsChannelById(long id) {
        return this.getNewsChannelCache().getElementById(id);
    }

    @Nonnull
    default public List<NewsChannel> getNewsChannels() {
        return this.getNewsChannelCache().asList();
    }

    @Nonnull
    public SnowflakeCacheView<VoiceChannel> getVoiceChannelCache();

    @Nonnull
    default public List<VoiceChannel> getVoiceChannelsByName(@Nonnull String name, boolean ignoreCase) {
        return this.getVoiceChannelCache().getElementsByName(name, ignoreCase);
    }

    @Nullable
    default public VoiceChannel getVoiceChannelById(@Nonnull String id) {
        return this.getVoiceChannelCache().getElementById(id);
    }

    @Nullable
    default public VoiceChannel getVoiceChannelById(long id) {
        return this.getVoiceChannelCache().getElementById(id);
    }

    @Nonnull
    default public List<VoiceChannel> getVoiceChannels() {
        return this.getVoiceChannelCache().asList();
    }
}

