/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.subtle;

import com.google.crypto.tink.AccessesPartialKey;
import com.google.crypto.tink.PublicKeyVerify;
import com.google.crypto.tink.config.internal.TinkFipsUtil;
import com.google.crypto.tink.internal.EnumTypeProtoConverter;
import com.google.crypto.tink.internal.Util;
import com.google.crypto.tink.signature.EcdsaParameters;
import com.google.crypto.tink.signature.EcdsaPublicKey;
import com.google.crypto.tink.subtle.EllipticCurves;
import com.google.crypto.tink.subtle.EngineFactory;
import com.google.crypto.tink.subtle.Enums;
import com.google.crypto.tink.subtle.SubtleUtil;
import com.google.errorprone.annotations.Immutable;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.Signature;
import java.security.interfaces.ECPublicKey;
import java.security.spec.EllipticCurve;
import java.util.Arrays;
import java.util.List;

@Immutable
public final class EcdsaVerifyJce
implements PublicKeyVerify {
    public static final TinkFipsUtil.AlgorithmFipsCompatibility FIPS = TinkFipsUtil.AlgorithmFipsCompatibility.ALGORITHM_REQUIRES_BORINGCRYPTO;
    private static final byte[] EMPTY = new byte[0];
    private static final byte[] LEGACY_MESSAGE_SUFFIX = new byte[]{0};
    private final ECPublicKey publicKey;
    private final String signatureAlgorithm;
    private final EllipticCurves.EcdsaEncoding encoding;
    private final byte[] outputPrefix;
    private final byte[] messageSuffix;
    static final EnumTypeProtoConverter<Enums.HashType, EcdsaParameters.HashType> HASH_TYPE_CONVERTER = EnumTypeProtoConverter.builder().add(Enums.HashType.SHA256, EcdsaParameters.HashType.SHA256).add(Enums.HashType.SHA384, EcdsaParameters.HashType.SHA384).add(Enums.HashType.SHA512, EcdsaParameters.HashType.SHA512).build();
    static final EnumTypeProtoConverter<EllipticCurves.EcdsaEncoding, EcdsaParameters.SignatureEncoding> ENCODING_CONVERTER = EnumTypeProtoConverter.builder().add(EllipticCurves.EcdsaEncoding.IEEE_P1363, EcdsaParameters.SignatureEncoding.IEEE_P1363).add(EllipticCurves.EcdsaEncoding.DER, EcdsaParameters.SignatureEncoding.DER).build();
    static final EnumTypeProtoConverter<EllipticCurves.CurveType, EcdsaParameters.CurveType> CURVE_TYPE_CONVERTER = EnumTypeProtoConverter.builder().add(EllipticCurves.CurveType.NIST_P256, EcdsaParameters.CurveType.NIST_P256).add(EllipticCurves.CurveType.NIST_P384, EcdsaParameters.CurveType.NIST_P384).add(EllipticCurves.CurveType.NIST_P521, EcdsaParameters.CurveType.NIST_P521).build();

    @AccessesPartialKey
    public static PublicKeyVerify create(EcdsaPublicKey key) throws GeneralSecurityException {
        ECPublicKey publicKey = EllipticCurves.getEcPublicKey(CURVE_TYPE_CONVERTER.toProtoEnum(key.getParameters().getCurveType()), key.getPublicPoint().getAffineX().toByteArray(), key.getPublicPoint().getAffineY().toByteArray());
        return new EcdsaVerifyJce(publicKey, HASH_TYPE_CONVERTER.toProtoEnum(key.getParameters().getHashType()), ENCODING_CONVERTER.toProtoEnum(key.getParameters().getSignatureEncoding()), key.getOutputPrefix().toByteArray(), key.getParameters().getVariant().equals(EcdsaParameters.Variant.LEGACY) ? LEGACY_MESSAGE_SUFFIX : EMPTY);
    }

    private EcdsaVerifyJce(ECPublicKey pubKey, Enums.HashType hash, EllipticCurves.EcdsaEncoding encoding, byte[] outputPrefix, byte[] messageSuffix) throws GeneralSecurityException {
        if (!FIPS.isCompatible()) {
            throw new GeneralSecurityException("Can not use ECDSA in FIPS-mode, as BoringCrypto is not available.");
        }
        EllipticCurves.checkPublicKey(pubKey);
        this.signatureAlgorithm = SubtleUtil.toEcdsaAlgo(hash);
        this.publicKey = pubKey;
        this.encoding = encoding;
        this.outputPrefix = outputPrefix;
        this.messageSuffix = messageSuffix;
    }

    public EcdsaVerifyJce(ECPublicKey pubKey, Enums.HashType hash, EllipticCurves.EcdsaEncoding encoding) throws GeneralSecurityException {
        this(pubKey, hash, encoding, EMPTY, EMPTY);
    }

    private void noPrefixVerify(byte[] signature, byte[] data) throws GeneralSecurityException {
        byte[] derSignature = signature;
        if (this.encoding == EllipticCurves.EcdsaEncoding.IEEE_P1363) {
            EllipticCurve curve = this.publicKey.getParams().getCurve();
            if (signature.length != 2 * EllipticCurves.fieldSizeInBytes(curve)) {
                throw new GeneralSecurityException("Invalid signature");
            }
            derSignature = EllipticCurves.ecdsaIeee2Der(signature);
        }
        if (!EllipticCurves.isValidDerEncoding(derSignature)) {
            throw new GeneralSecurityException("Invalid signature");
        }
        List<Provider> preferredProviders = EngineFactory.toProviderList("GmsCore_OpenSSL", "AndroidOpenSSL", "Conscrypt");
        Signature verifier = EngineFactory.SIGNATURE.getInstance(this.signatureAlgorithm, preferredProviders);
        verifier.initVerify(this.publicKey);
        verifier.update(data);
        if (this.messageSuffix.length > 0) {
            verifier.update(this.messageSuffix);
        }
        boolean verified = false;
        try {
            verified = verifier.verify(derSignature);
        }
        catch (RuntimeException ex) {
            verified = false;
        }
        if (!verified) {
            throw new GeneralSecurityException("Invalid signature");
        }
    }

    @Override
    public void verify(byte[] signature, byte[] data) throws GeneralSecurityException {
        if (this.outputPrefix.length == 0) {
            this.noPrefixVerify(signature, data);
            return;
        }
        if (!Util.isPrefix(this.outputPrefix, signature)) {
            throw new GeneralSecurityException("Invalid signature (output prefix mismatch)");
        }
        byte[] signatureNoPrefix = Arrays.copyOfRange(signature, this.outputPrefix.length, signature.length);
        this.noPrefixVerify(signatureNoPrefix, data);
    }
}

