/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.jwt;

import com.google.crypto.tink.internal.MonitoringClient;
import com.google.crypto.tink.internal.MonitoringKeysetInfo;
import com.google.crypto.tink.internal.MonitoringUtil;
import com.google.crypto.tink.internal.MutableMonitoringRegistry;
import com.google.crypto.tink.internal.MutablePrimitiveRegistry;
import com.google.crypto.tink.internal.PrimitiveSet;
import com.google.crypto.tink.internal.PrimitiveWrapper;
import com.google.crypto.tink.jwt.JwtInvalidException;
import com.google.crypto.tink.jwt.JwtMac;
import com.google.crypto.tink.jwt.JwtValidator;
import com.google.crypto.tink.jwt.RawJwt;
import com.google.crypto.tink.jwt.VerifiedJwt;
import com.google.errorprone.annotations.Immutable;
import java.security.GeneralSecurityException;
import java.util.List;

class JwtMacWrapper
implements PrimitiveWrapper<JwtMac, JwtMac> {
    private static final JwtMacWrapper WRAPPER = new JwtMacWrapper();

    private static void validate(PrimitiveSet<JwtMac> primitiveSet) throws GeneralSecurityException {
        if (primitiveSet.getPrimary() == null) {
            throw new GeneralSecurityException("Primitive set has no primary.");
        }
    }

    JwtMacWrapper() {
    }

    @Override
    public JwtMac wrap(PrimitiveSet<JwtMac> primitives) throws GeneralSecurityException {
        JwtMacWrapper.validate(primitives);
        return new WrappedJwtMac(primitives);
    }

    @Override
    public Class<JwtMac> getPrimitiveClass() {
        return JwtMac.class;
    }

    @Override
    public Class<JwtMac> getInputPrimitiveClass() {
        return JwtMac.class;
    }

    public static void register() throws GeneralSecurityException {
        MutablePrimitiveRegistry.globalInstance().registerPrimitiveWrapper(WRAPPER);
    }

    @Immutable
    private static class WrappedJwtMac
    implements JwtMac {
        private final PrimitiveSet<JwtMac> primitives;
        private final MonitoringClient.Logger computeLogger;
        private final MonitoringClient.Logger verifyLogger;

        private WrappedJwtMac(PrimitiveSet<JwtMac> primitives) {
            this.primitives = primitives;
            if (primitives.hasAnnotations()) {
                MonitoringClient client = MutableMonitoringRegistry.globalInstance().getMonitoringClient();
                MonitoringKeysetInfo keysetInfo = MonitoringUtil.getMonitoringKeysetInfo(primitives);
                this.computeLogger = client.createLogger(keysetInfo, "jwtmac", "compute");
                this.verifyLogger = client.createLogger(keysetInfo, "jwtmac", "verify");
            } else {
                this.computeLogger = MonitoringUtil.DO_NOTHING_LOGGER;
                this.verifyLogger = MonitoringUtil.DO_NOTHING_LOGGER;
            }
        }

        @Override
        public String computeMacAndEncode(RawJwt token) throws GeneralSecurityException {
            try {
                String result = this.primitives.getPrimary().getFullPrimitive().computeMacAndEncode(token);
                this.computeLogger.log(this.primitives.getPrimary().getKeyId(), 1L);
                return result;
            }
            catch (GeneralSecurityException e) {
                this.computeLogger.logFailure();
                throw e;
            }
        }

        @Override
        public VerifiedJwt verifyMacAndDecode(String compact, JwtValidator validator) throws GeneralSecurityException {
            GeneralSecurityException interestingException = null;
            for (List<PrimitiveSet.Entry<JwtMac>> entries : this.primitives.getAll()) {
                for (PrimitiveSet.Entry<JwtMac> entry : entries) {
                    try {
                        VerifiedJwt result = entry.getFullPrimitive().verifyMacAndDecode(compact, validator);
                        this.verifyLogger.log(entry.getKeyId(), 1L);
                        return result;
                    }
                    catch (GeneralSecurityException e) {
                        if (!(e instanceof JwtInvalidException)) continue;
                        interestingException = e;
                    }
                }
            }
            this.verifyLogger.logFailure();
            if (interestingException != null) {
                throw interestingException;
            }
            throw new GeneralSecurityException("invalid MAC");
        }
    }
}

