/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.internal;

import com.google.crypto.tink.CryptoFormat;
import com.google.crypto.tink.Key;
import com.google.crypto.tink.Parameters;
import com.google.crypto.tink.internal.MonitoringAnnotations;
import com.google.crypto.tink.proto.KeyStatusType;
import com.google.crypto.tink.proto.Keyset;
import com.google.crypto.tink.proto.OutputPrefixType;
import com.google.crypto.tink.util.Bytes;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public final class PrimitiveSet<P> {
    private final Map<Bytes, List<Entry<P>>> entries;
    private final List<Entry<P>> entriesInKeysetOrder;
    private final Entry<P> primary;
    private final Class<P> primitiveClass;
    private final MonitoringAnnotations annotations;

    private static <P> void storeEntryInPrimitiveSet(Entry<P> entry, Map<Bytes, List<Entry<P>>> entries, List<Entry<P>> entriesInKeysetOrder) {
        ArrayList<Entry<P>> list = new ArrayList<Entry<P>>();
        list.add(entry);
        List existing = entries.put(((Entry)entry).getOutputPrefix(), Collections.unmodifiableList(list));
        if (existing != null) {
            ArrayList newList = new ArrayList();
            newList.addAll(existing);
            newList.add(entry);
            entries.put(((Entry)entry).getOutputPrefix(), Collections.unmodifiableList(newList));
        }
        entriesInKeysetOrder.add(entry);
    }

    @Nullable
    public Entry<P> getPrimary() {
        return this.primary;
    }

    public boolean hasAnnotations() {
        return !this.annotations.toMap().isEmpty();
    }

    public MonitoringAnnotations getAnnotations() {
        return this.annotations;
    }

    public List<Entry<P>> getRawPrimitives() {
        return this.getPrimitive(CryptoFormat.RAW_PREFIX);
    }

    public List<Entry<P>> getPrimitive(byte[] identifier) {
        List<Entry<P>> found = this.entries.get(Bytes.copyFrom(identifier));
        return found != null ? found : Collections.emptyList();
    }

    public Collection<List<Entry<P>>> getAll() {
        return this.entries.values();
    }

    public List<Entry<P>> getAllInKeysetOrder() {
        return Collections.unmodifiableList(this.entriesInKeysetOrder);
    }

    private PrimitiveSet(Map<Bytes, List<Entry<P>>> entries, List<Entry<P>> entriesInKeysetOrder, Entry<P> primary, MonitoringAnnotations annotations, Class<P> primitiveClass) {
        this.entries = entries;
        this.entriesInKeysetOrder = entriesInKeysetOrder;
        this.primary = primary;
        this.primitiveClass = primitiveClass;
        this.annotations = annotations;
    }

    public Class<P> getPrimitiveClass() {
        return this.primitiveClass;
    }

    public static <P> Builder<P> newBuilder(Class<P> primitiveClass) {
        return new Builder(primitiveClass);
    }

    public static class Builder<P> {
        private final Class<P> primitiveClass;
        private Map<Bytes, List<Entry<P>>> entries = new HashMap<Bytes, List<Entry<P>>>();
        private final List<Entry<P>> entriesInKeysetOrder = new ArrayList<Entry<P>>();
        private Entry<P> primary;
        private MonitoringAnnotations annotations;

        @CanIgnoreReturnValue
        private Builder<P> addEntry(P fullPrimitive, Key key, Keyset.Key protoKey, boolean asPrimary) throws GeneralSecurityException {
            if (this.entries == null) {
                throw new IllegalStateException("addEntry cannot be called after build");
            }
            if (fullPrimitive == null) {
                throw new NullPointerException("`fullPrimitive` must not be null");
            }
            if (protoKey.getStatus() != KeyStatusType.ENABLED) {
                throw new GeneralSecurityException("only ENABLED key is allowed");
            }
            Entry entry = new Entry(fullPrimitive, Bytes.copyFrom(CryptoFormat.getOutputPrefix(protoKey)), protoKey.getStatus(), protoKey.getOutputPrefixType(), protoKey.getKeyId(), protoKey.getKeyData().getTypeUrl(), key);
            PrimitiveSet.storeEntryInPrimitiveSet(entry, this.entries, this.entriesInKeysetOrder);
            if (asPrimary) {
                if (this.primary != null) {
                    throw new IllegalStateException("you cannot set two primary primitives");
                }
                this.primary = entry;
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<P> addFullPrimitive(P fullPrimitive, Key key, Keyset.Key protoKey) throws GeneralSecurityException {
            return this.addEntry(fullPrimitive, key, protoKey, false);
        }

        @CanIgnoreReturnValue
        public Builder<P> addPrimaryFullPrimitive(P fullPrimitive, Key key, Keyset.Key protoKey) throws GeneralSecurityException {
            return this.addEntry(fullPrimitive, key, protoKey, true);
        }

        @CanIgnoreReturnValue
        public Builder<P> setAnnotations(MonitoringAnnotations annotations) {
            if (this.entries == null) {
                throw new IllegalStateException("setAnnotations cannot be called after build");
            }
            this.annotations = annotations;
            return this;
        }

        public PrimitiveSet<P> build() throws GeneralSecurityException {
            if (this.entries == null) {
                throw new IllegalStateException("build cannot be called twice");
            }
            PrimitiveSet output = new PrimitiveSet(this.entries, this.entriesInKeysetOrder, this.primary, this.annotations, this.primitiveClass);
            this.entries = null;
            return output;
        }

        private Builder(Class<P> primitiveClass) {
            this.primitiveClass = primitiveClass;
            this.annotations = MonitoringAnnotations.EMPTY;
        }
    }

    public static final class Entry<P> {
        private final P fullPrimitive;
        private final Bytes outputPrefix;
        private final KeyStatusType status;
        private final OutputPrefixType outputPrefixType;
        private final int keyId;
        private final String keyTypeUrl;
        private final Key key;

        private Entry(P fullPrimitive, Bytes outputPrefix, KeyStatusType status, OutputPrefixType outputPrefixType, int keyId, String keyTypeUrl, Key key) {
            this.fullPrimitive = fullPrimitive;
            this.outputPrefix = outputPrefix;
            this.status = status;
            this.outputPrefixType = outputPrefixType;
            this.keyId = keyId;
            this.keyTypeUrl = keyTypeUrl;
            this.key = key;
        }

        public P getFullPrimitive() {
            return this.fullPrimitive;
        }

        public KeyStatusType getStatus() {
            return this.status;
        }

        public OutputPrefixType getOutputPrefixType() {
            return this.outputPrefixType;
        }

        private final Bytes getOutputPrefix() {
            return this.outputPrefix;
        }

        public int getKeyId() {
            return this.keyId;
        }

        public String getKeyTypeUrl() {
            return this.keyTypeUrl;
        }

        public Key getKey() {
            return this.key;
        }

        @Nullable
        public Parameters getParameters() {
            if (this.key == null) {
                return null;
            }
            return this.key.getParameters();
        }
    }
}

