/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.interactions.commands;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.interactions.Interaction;
import net.dv8tion.jda.api.interactions.commands.Command;
import net.dv8tion.jda.api.interactions.commands.OptionMapping;
import net.dv8tion.jda.api.interactions.commands.OptionType;
import net.dv8tion.jda.internal.utils.Checks;

public interface CommandInteractionPayload
extends Interaction {
    @Nonnull
    public Command.Type getCommandType();

    @Nonnull
    public String getName();

    @Nullable
    public String getSubcommandName();

    @Nullable
    public String getSubcommandGroup();

    @Nonnull
    default public String getCommandPath() {
        StringBuilder builder = new StringBuilder(this.getName());
        if (this.getSubcommandGroup() != null) {
            builder.append('/').append(this.getSubcommandGroup());
        }
        if (this.getSubcommandName() != null) {
            builder.append('/').append(this.getSubcommandName());
        }
        return builder.toString();
    }

    @Nonnull
    default public String getCommandString() {
        if (this.getCommandType() != Command.Type.SLASH) {
            return this.getName();
        }
        StringBuilder builder = new StringBuilder();
        builder.append("/").append(this.getName());
        if (this.getSubcommandGroup() != null) {
            builder.append(" ").append(this.getSubcommandGroup());
        }
        if (this.getSubcommandName() != null) {
            builder.append(" ").append(this.getSubcommandName());
        }
        block6: for (OptionMapping o : this.getOptions()) {
            builder.append(" ").append(o.getName()).append(": ");
            switch (o.getType()) {
                case CHANNEL: {
                    builder.append("#").append(o.getAsGuildChannel().getName());
                    continue block6;
                }
                case USER: {
                    builder.append("@").append(o.getAsUser().getName());
                    continue block6;
                }
                case ROLE: {
                    builder.append("@").append(o.getAsRole().getName());
                    continue block6;
                }
                case MENTIONABLE: {
                    if (o.getAsMentionable() instanceof Role) {
                        builder.append("@").append(o.getAsRole().getName());
                        continue block6;
                    }
                    if (o.getAsMentionable() instanceof Member) {
                        builder.append("@").append(o.getAsUser().getName());
                        continue block6;
                    }
                    if (o.getAsMentionable() instanceof User) {
                        builder.append("@").append(o.getAsUser().getName());
                        continue block6;
                    }
                    builder.append("@").append(o.getAsMentionable().getIdLong());
                    continue block6;
                }
            }
            builder.append(o.getAsString());
        }
        return builder.toString();
    }

    public long getCommandIdLong();

    @Nonnull
    default public String getCommandId() {
        return Long.toUnsignedString(this.getCommandIdLong());
    }

    @Nonnull
    public List<OptionMapping> getOptions();

    @Nonnull
    default public List<OptionMapping> getOptionsByName(@Nonnull String name) {
        Checks.notNull(name, "Name");
        return this.getOptions().stream().filter(opt -> opt.getName().equals(name)).collect(Collectors.toList());
    }

    @Nonnull
    default public List<OptionMapping> getOptionsByType(@Nonnull OptionType type) {
        Checks.notNull((Object)type, "Type");
        return this.getOptions().stream().filter(it -> it.getType() == type).collect(Collectors.toList());
    }

    @Nullable
    default public OptionMapping getOption(@Nonnull String name) {
        List<OptionMapping> options = this.getOptionsByName(name);
        return options.isEmpty() ? null : options.get(0);
    }
}

