/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.entities;

import java.time.OffsetDateTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.entities.ISnowflake;

public interface Entitlement
extends ISnowflake {
    public long getSkuIdLong();

    @Nonnull
    default public String getSkuId() {
        return Long.toUnsignedString(this.getSkuIdLong());
    }

    public long getApplicationIdLong();

    @Nonnull
    default public String getApplicationId() {
        return Long.toUnsignedString(this.getApplicationIdLong());
    }

    public long getUserIdLong();

    default public String getUserId() {
        return Long.toUnsignedString(this.getUserIdLong());
    }

    public long getGuildIdLong();

    @Nullable
    default public String getGuildId() {
        if (this.getGuildIdLong() == 0L) {
            return null;
        }
        return Long.toUnsignedString(this.getGuildIdLong());
    }

    @Nonnull
    public EntitlementType getType();

    public boolean isDeleted();

    @Nullable
    public OffsetDateTime getTimeStarting();

    @Nullable
    public OffsetDateTime getTimeEnding();

    public static enum EntitlementType {
        APPLICATION_SUBSCRIPTION(8),
        UNKNOWN(-1);

        private final int key;

        private EntitlementType(int key) {
            this.key = key;
        }

        public int getKey() {
            return this.key;
        }

        @Nonnull
        public static EntitlementType fromKey(int key) {
            for (EntitlementType type : EntitlementType.values()) {
                if (type.getKey() != key) continue;
                return type;
            }
            return UNKNOWN;
        }
    }
}

