/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.entities;

import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.channel.ChannelType;
import net.dv8tion.jda.api.entities.channel.middleman.GuildChannel;
import net.dv8tion.jda.api.entities.channel.middleman.GuildMessageChannel;
import net.dv8tion.jda.api.entities.channel.middleman.MessageChannel;
import net.dv8tion.jda.api.entities.channel.unions.GuildMessageChannelUnion;
import net.dv8tion.jda.api.entities.channel.unions.MessageChannelUnion;
import net.dv8tion.jda.api.entities.emoji.Emoji;
import net.dv8tion.jda.api.entities.emoji.EmojiUnion;
import net.dv8tion.jda.api.exceptions.InsufficientPermissionException;
import net.dv8tion.jda.api.exceptions.PermissionException;
import net.dv8tion.jda.api.requests.RestAction;
import net.dv8tion.jda.api.requests.Route;
import net.dv8tion.jda.api.requests.restaction.pagination.ReactionPaginationAction;
import net.dv8tion.jda.internal.requests.RestActionImpl;
import net.dv8tion.jda.internal.requests.restaction.pagination.ReactionPaginationActionImpl;
import net.dv8tion.jda.internal.utils.Checks;
import net.dv8tion.jda.internal.utils.EntityString;

public class MessageReaction {
    private final MessageChannel channel;
    private final EmojiUnion emoji;
    private final long messageId;
    private final boolean self;
    private final int count;

    public MessageReaction(@Nonnull MessageChannel channel, @Nonnull EmojiUnion emoji, long messageId, boolean self, int count) {
        this.channel = channel;
        this.emoji = emoji;
        this.messageId = messageId;
        this.self = self;
        this.count = count;
    }

    @Nonnull
    public JDA getJDA() {
        return this.channel.getJDA();
    }

    public boolean isSelf() {
        return this.self;
    }

    public boolean hasCount() {
        return this.count >= 0;
    }

    public int getCount() {
        if (!this.hasCount()) {
            throw new IllegalStateException("Cannot retrieve count for this MessageReaction!");
        }
        return this.count;
    }

    @Nonnull
    public ChannelType getChannelType() {
        return this.channel.getType();
    }

    public boolean isFromType(@Nonnull ChannelType type) {
        return this.getChannelType() == type;
    }

    @Nonnull
    public Guild getGuild() {
        return this.getGuildChannel().getGuild();
    }

    @Nonnull
    public MessageChannelUnion getChannel() {
        return (MessageChannelUnion)this.channel;
    }

    @Nonnull
    public GuildMessageChannelUnion getGuildChannel() {
        return (GuildMessageChannelUnion)this.getChannel().asGuildMessageChannel();
    }

    @Nonnull
    public EmojiUnion getEmoji() {
        return this.emoji;
    }

    @Nonnull
    public String getMessageId() {
        return Long.toUnsignedString(this.messageId);
    }

    public long getMessageIdLong() {
        return this.messageId;
    }

    @Nonnull
    @CheckReturnValue
    public ReactionPaginationAction retrieveUsers() {
        return new ReactionPaginationActionImpl(this);
    }

    @Nonnull
    @CheckReturnValue
    public RestAction<Void> removeReaction() {
        return this.removeReaction(this.getJDA().getSelfUser());
    }

    @Nonnull
    @CheckReturnValue
    public RestAction<Void> removeReaction(@Nonnull User user) {
        Checks.notNull(user, "User");
        boolean self = user.equals(this.getJDA().getSelfUser());
        if (!self) {
            if (!this.channel.getType().isGuild()) {
                throw new PermissionException("Unable to remove Reaction of other user in non-guild channels!");
            }
            GuildChannel guildChannel = (GuildChannel)((Object)this.channel);
            if (!guildChannel.getGuild().getSelfMember().hasPermission(guildChannel, Permission.MESSAGE_MANAGE)) {
                throw new InsufficientPermissionException(guildChannel, Permission.MESSAGE_MANAGE);
            }
        }
        String code = this.emoji.getAsReactionCode();
        String target = self ? "@me" : user.getId();
        Route.CompiledRoute route = Route.Messages.REMOVE_REACTION.compile(this.channel.getId(), this.getMessageId(), code, target);
        return new RestActionImpl<Void>(this.getJDA(), route);
    }

    @Nonnull
    @CheckReturnValue
    public RestAction<Void> clearReactions() {
        if (!this.getChannelType().isGuild()) {
            throw new UnsupportedOperationException("Cannot clear reactions on a message sent from a private channel");
        }
        GuildMessageChannel guildChannel = Objects.requireNonNull(this.getGuildChannel());
        return guildChannel.clearReactionsById(this.getMessageId(), (Emoji)this.emoji);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MessageReaction)) {
            return false;
        }
        MessageReaction r = (MessageReaction)obj;
        return r.emoji.equals(this.emoji) && r.self == this.self && r.messageId == this.messageId;
    }

    public String toString() {
        return new EntityString(this).addMetadata("messageId", this.messageId).addMetadata("emoji", this.emoji).toString();
    }
}

