/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.entities.mentions;

import gnu.trove.map.hash.TLongObjectHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.IMentionable;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Mentions;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.UserSnowflake;
import net.dv8tion.jda.api.entities.channel.middleman.GuildChannel;
import net.dv8tion.jda.api.entities.emoji.CustomEmoji;
import net.dv8tion.jda.api.entities.emoji.Emoji;
import net.dv8tion.jda.api.interactions.commands.ICommandReference;
import net.dv8tion.jda.api.interactions.commands.SlashCommandReference;
import net.dv8tion.jda.api.utils.MiscUtil;
import net.dv8tion.jda.internal.JDAImpl;
import net.dv8tion.jda.internal.entities.GuildImpl;
import net.dv8tion.jda.internal.utils.Checks;
import org.apache.commons.collections4.Bag;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.bag.HashBag;

public abstract class AbstractMentions
implements Mentions {
    protected final String content;
    protected final JDAImpl jda;
    protected final GuildImpl guild;
    protected final boolean mentionsEveryone;
    protected List<User> mentionedUsers;
    protected List<Member> mentionedMembers;
    protected List<Role> mentionedRoles;
    protected List<GuildChannel> mentionedChannels;
    protected List<CustomEmoji> mentionedEmojis;
    protected List<SlashCommandReference> mentionedSlashCommands;

    public AbstractMentions(String content, JDAImpl jda, GuildImpl guild, boolean mentionsEveryone) {
        this.content = content;
        this.jda = jda;
        this.guild = guild;
        this.mentionsEveryone = mentionsEveryone;
    }

    @Override
    @Nonnull
    public JDA getJDA() {
        return this.jda;
    }

    @Override
    public boolean mentionsEveryone() {
        return this.mentionsEveryone;
    }

    @Override
    @Nonnull
    public synchronized List<User> getUsers() {
        if (this.mentionedUsers != null) {
            return this.mentionedUsers;
        }
        this.mentionedUsers = Collections.unmodifiableList(this.processMentions(Message.MentionType.USER, new ArrayList(), true, this::matchUser));
        return this.mentionedUsers;
    }

    @Override
    @Nonnull
    public Bag<User> getUsersBag() {
        return (Bag)this.processMentions(Message.MentionType.USER, new HashBag(), false, this::matchUser);
    }

    @Override
    @Nonnull
    public synchronized List<GuildChannel> getChannels() {
        if (this.mentionedChannels != null) {
            return this.mentionedChannels;
        }
        this.mentionedChannels = Collections.unmodifiableList(this.processMentions(Message.MentionType.CHANNEL, new ArrayList(), true, this::matchChannel));
        return this.mentionedChannels;
    }

    @Override
    @Nonnull
    public Bag<GuildChannel> getChannelsBag() {
        return (Bag)this.processMentions(Message.MentionType.CHANNEL, new HashBag(), false, this::matchChannel);
    }

    @Override
    @Nonnull
    public <T extends GuildChannel> List<T> getChannels(@Nonnull Class<T> clazz) {
        Checks.notNull(clazz, "clazz");
        return this.getChannels().stream().filter(clazz::isInstance).map(clazz::cast).collect(Collectors.toList());
    }

    @Override
    @Nonnull
    public <T extends GuildChannel> Bag<T> getChannelsBag(@Nonnull Class<T> clazz) {
        Checks.notNull(clazz, "clazz");
        Function<Matcher, GuildChannel> matchTypedChannel = matcher -> {
            GuildChannel channel = this.matchChannel((Matcher)matcher);
            return clazz.isInstance(channel) ? (GuildChannel)clazz.cast(channel) : null;
        };
        return (Bag)this.processMentions(Message.MentionType.CHANNEL, new HashBag(), false, matchTypedChannel);
    }

    @Override
    @Nonnull
    public synchronized List<Role> getRoles() {
        if (this.guild == null) {
            return Collections.emptyList();
        }
        if (this.mentionedRoles != null) {
            return this.mentionedRoles;
        }
        this.mentionedRoles = Collections.unmodifiableList(this.processMentions(Message.MentionType.ROLE, new ArrayList(), true, this::matchRole));
        return this.mentionedRoles;
    }

    @Override
    @Nonnull
    public Bag<Role> getRolesBag() {
        if (this.guild == null) {
            return new HashBag();
        }
        return (Bag)this.processMentions(Message.MentionType.ROLE, new HashBag(), false, this::matchRole);
    }

    @Override
    @Nonnull
    public synchronized List<CustomEmoji> getCustomEmojis() {
        if (this.mentionedEmojis != null) {
            return this.mentionedEmojis;
        }
        this.mentionedEmojis = Collections.unmodifiableList(this.processMentions(Message.MentionType.EMOJI, new ArrayList(), true, this::matchEmoji));
        return this.mentionedEmojis;
    }

    @Override
    @Nonnull
    public Bag<CustomEmoji> getCustomEmojisBag() {
        return (Bag)this.processMentions(Message.MentionType.EMOJI, new HashBag(), false, this::matchEmoji);
    }

    @Override
    @Nonnull
    public synchronized List<Member> getMembers() {
        if (this.guild == null) {
            return Collections.emptyList();
        }
        if (this.mentionedMembers != null) {
            return this.mentionedMembers;
        }
        this.mentionedMembers = Collections.unmodifiableList(this.processMentions(Message.MentionType.USER, new ArrayList(), true, this::matchMember));
        return this.mentionedMembers;
    }

    @Override
    @Nonnull
    public Bag<Member> getMembersBag() {
        if (this.guild == null) {
            return new HashBag();
        }
        return (Bag)this.processMentions(Message.MentionType.USER, new HashBag(), false, this::matchMember);
    }

    @Override
    @Nonnull
    public synchronized List<SlashCommandReference> getSlashCommands() {
        if (this.mentionedSlashCommands != null) {
            return this.mentionedSlashCommands;
        }
        this.mentionedSlashCommands = Collections.unmodifiableList(this.processMentions(Message.MentionType.SLASH_COMMAND, new ArrayList(), true, this::matchSlashCommand));
        return this.mentionedSlashCommands;
    }

    @Override
    @Nonnull
    public Bag<SlashCommandReference> getSlashCommandsBag() {
        return (Bag)this.processMentions(Message.MentionType.SLASH_COMMAND, new HashBag(), false, this::matchSlashCommand);
    }

    @Override
    @Nonnull
    public List<IMentionable> getMentions(Message.MentionType ... types) {
        if (types == null || types.length == 0) {
            return this.getMentions(Message.MentionType.values());
        }
        ArrayList<IMentionable> mentions = new ArrayList<IMentionable>();
        for (Message.MentionType mentionType : EnumSet.of(types[0], types)) {
            switch (mentionType) {
                case CHANNEL: {
                    mentions.addAll(this.getChannels());
                    break;
                }
                case USER: {
                    TLongObjectHashMap set = new TLongObjectHashMap();
                    for (User u : this.getUsers()) {
                        set.put(u.getIdLong(), (Object)u);
                    }
                    for (Member m : this.getMembers()) {
                        set.put(m.getIdLong(), (Object)m);
                    }
                    mentions.addAll(set.valueCollection());
                    break;
                }
                case ROLE: {
                    mentions.addAll(this.getRoles());
                    break;
                }
                case EMOJI: {
                    mentions.addAll(this.getCustomEmojis());
                    break;
                }
                case SLASH_COMMAND: {
                    mentions.addAll(this.getSlashCommands());
                }
            }
        }
        mentions.sort(Comparator.comparingInt(it -> this.content.indexOf(it.getId())));
        return Collections.unmodifiableList(mentions);
    }

    @Override
    public boolean isMentioned(@Nonnull IMentionable mentionable, Message.MentionType ... types) {
        Checks.notNull(types, "Mention Types");
        if (types.length == 0) {
            return this.isMentioned(mentionable, Message.MentionType.values());
        }
        block9: for (Message.MentionType type : types) {
            switch (type) {
                case HERE: {
                    if (!this.isMass("@here") || !(mentionable instanceof UserSnowflake)) continue block9;
                    return true;
                }
                case EVERYONE: {
                    if (!this.isMass("@everyone") || !(mentionable instanceof UserSnowflake)) continue block9;
                    return true;
                }
                case USER: {
                    if (!this.isUserMentioned(mentionable)) continue block9;
                    return true;
                }
                case ROLE: {
                    if (!this.isRoleMentioned(mentionable)) continue block9;
                    return true;
                }
                case CHANNEL: {
                    if (!(mentionable instanceof GuildChannel) || !this.getChannels().contains(mentionable)) continue block9;
                    return true;
                }
                case EMOJI: {
                    if (!(mentionable instanceof CustomEmoji) || !this.getCustomEmojis().contains(mentionable)) continue block9;
                    return true;
                }
                case SLASH_COMMAND: {
                    if (!this.isSlashCommandMentioned(mentionable)) continue block9;
                    return true;
                }
            }
        }
        return false;
    }

    protected <T, C extends Collection<T>> C processMentions(Message.MentionType type, C collection, boolean distinct, Function<Matcher, T> map) {
        Matcher matcher = type.getPattern().matcher(this.content);
        while (matcher.find()) {
            try {
                T elem = map.apply(matcher);
                if (elem == null || distinct && collection.contains(elem)) continue;
                collection.add(elem);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return collection;
    }

    protected abstract User matchUser(Matcher var1);

    protected abstract Member matchMember(Matcher var1);

    protected abstract GuildChannel matchChannel(Matcher var1);

    protected abstract Role matchRole(Matcher var1);

    protected CustomEmoji matchEmoji(Matcher m) {
        long emojiId = MiscUtil.parseSnowflake(m.group(2));
        String name = m.group(1);
        boolean animated = m.group(0).startsWith("<a:");
        CustomEmoji emoji = this.getJDA().getEmojiById(emojiId);
        if (emoji == null) {
            emoji = Emoji.fromCustom(name, emojiId, animated);
        }
        return emoji;
    }

    protected SlashCommandReference matchSlashCommand(Matcher matcher) {
        return new SlashCommandReference(matcher.group(1), matcher.group(2), matcher.group(3), Long.parseLong(matcher.group(4)));
    }

    protected abstract boolean isUserMentioned(IMentionable var1);

    protected boolean isRoleMentioned(IMentionable mentionable) {
        if (mentionable instanceof Role) {
            return this.getRoles().contains(mentionable);
        }
        Member member = null;
        if (mentionable instanceof Member) {
            member = (Member)mentionable;
        } else if (this.guild != null && mentionable instanceof User) {
            member = this.guild.getMember((User)mentionable);
        }
        return member != null && CollectionUtils.containsAny(this.getRoles(), member.getRoles());
    }

    protected boolean isSlashCommandMentioned(IMentionable mentionable) {
        if (mentionable instanceof ICommandReference) {
            ICommandReference reference = (ICommandReference)mentionable;
            for (SlashCommandReference r : this.getSlashCommands()) {
                if (!r.getFullCommandName().equals(reference.getFullCommandName()) || r.getIdLong() != reference.getIdLong()) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isMass(String s) {
        return this.mentionsEveryone && this.content.contains(s);
    }
}

