/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.interactions.component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.interactions.components.Component;
import net.dv8tion.jda.api.interactions.components.selections.SelectMenu;
import net.dv8tion.jda.api.interactions.components.selections.SelectOption;
import net.dv8tion.jda.api.utils.data.DataArray;
import net.dv8tion.jda.api.utils.data.DataObject;
import net.dv8tion.jda.internal.utils.EntityString;

public class SelectMenuImpl
implements SelectMenu {
    private final String id;
    private final String placeholder;
    private final int minValues;
    private final int maxValues;
    private final boolean disabled;
    private final List<SelectOption> options;

    public SelectMenuImpl(DataObject data) {
        this(data.getString("custom_id"), data.getString("placeholder", null), data.getInt("min_values", 1), data.getInt("max_values", 1), data.getBoolean("disabled"), SelectMenuImpl.parseOptions(data.getArray("options")));
    }

    public SelectMenuImpl(String id, String placeholder, int minValues, int maxValues, boolean disabled, List<SelectOption> options) {
        this.id = id;
        this.placeholder = placeholder;
        this.minValues = minValues;
        this.maxValues = maxValues;
        this.disabled = disabled;
        this.options = Collections.unmodifiableList(options);
    }

    private static List<SelectOption> parseOptions(DataArray array) {
        ArrayList<SelectOption> options = new ArrayList<SelectOption>(array.length());
        array.stream(DataArray::getObject).map(SelectOption::fromData).forEach(options::add);
        return options;
    }

    @Override
    @Nonnull
    public Component.Type getType() {
        return Component.Type.SELECT_MENU;
    }

    @Override
    @Nullable
    public String getId() {
        return this.id;
    }

    @Override
    @Nullable
    public String getPlaceholder() {
        return this.placeholder;
    }

    @Override
    public int getMinValues() {
        return this.minValues;
    }

    @Override
    public int getMaxValues() {
        return this.maxValues;
    }

    @Override
    @Nonnull
    public List<SelectOption> getOptions() {
        return this.options;
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    @Nonnull
    public DataObject toData() {
        DataObject data = DataObject.empty();
        data.put("type", 3);
        data.put("custom_id", this.id);
        data.put("min_values", this.minValues);
        data.put("max_values", this.maxValues);
        data.put("disabled", this.disabled);
        data.put("options", DataArray.fromCollection(this.options));
        if (this.placeholder != null) {
            data.put("placeholder", this.placeholder);
        }
        return data;
    }

    public String toString() {
        return new EntityString(this).addMetadata("id", this.id).addMetadata("placeholder", this.placeholder).toString();
    }

    public int hashCode() {
        return Objects.hash(this.id, this.placeholder, this.minValues, this.maxValues, this.disabled, this.options);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SelectMenu)) {
            return false;
        }
        SelectMenu other = (SelectMenu)obj;
        return Objects.equals(this.id, other.getId()) && Objects.equals(this.placeholder, other.getPlaceholder()) && this.minValues == other.getMinValues() && this.maxValues == other.getMaxValues() && this.disabled == other.isDisabled() && Objects.equals(this.options, other.getOptions());
    }
}

