/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.requests.restaction;

import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.requests.Request;
import net.dv8tion.jda.api.requests.Response;
import net.dv8tion.jda.api.requests.restaction.WebhookMessageCreateAction;
import net.dv8tion.jda.api.utils.FileUpload;
import net.dv8tion.jda.api.utils.data.DataObject;
import net.dv8tion.jda.api.utils.messages.MessageCreateBuilder;
import net.dv8tion.jda.api.utils.messages.MessageCreateData;
import net.dv8tion.jda.internal.requests.Route;
import net.dv8tion.jda.internal.requests.restaction.TriggerRestAction;
import net.dv8tion.jda.internal.utils.message.MessageCreateBuilderMixin;
import okhttp3.RequestBody;

public class WebhookMessageCreateActionImpl<T>
extends TriggerRestAction<T>
implements WebhookMessageCreateAction<T>,
MessageCreateBuilderMixin<WebhookMessageCreateAction<T>> {
    private final MessageCreateBuilder builder = new MessageCreateBuilder();
    private final Function<DataObject, T> transformer;
    private boolean ephemeral;

    public WebhookMessageCreateActionImpl(JDA api, Route.CompiledRoute route, Function<DataObject, T> transformer) {
        super(api, route);
        this.transformer = transformer;
    }

    @Override
    public MessageCreateBuilder getBuilder() {
        return this.builder;
    }

    @Override
    @Nonnull
    public WebhookMessageCreateActionImpl<T> setEphemeral(boolean ephemeral) {
        this.ephemeral = ephemeral;
        return this;
    }

    @Override
    protected RequestBody finalizeData() {
        try (MessageCreateData data = this.builder.build();){
            List<FileUpload> files = data.getFiles();
            DataObject json = data.toData();
            if (this.ephemeral) {
                json.put("flags", json.getInt("flags", 0) | Message.MessageFlag.EPHEMERAL.getValue());
            }
            RequestBody requestBody = this.getMultipartBody(files, json);
            return requestBody;
        }
    }

    @Override
    protected void handleSuccess(Response response, Request<T> request) {
        T message = this.transformer.apply(response.getObject());
        request.onSuccess(message);
    }

    @Override
    @Nonnull
    public WebhookMessageCreateAction<T> setCheck(@Nullable BooleanSupplier checks) {
        return (WebhookMessageCreateAction)super.setCheck(checks);
    }

    @Override
    @Nonnull
    public WebhookMessageCreateAction<T> deadline(long timestamp) {
        return (WebhookMessageCreateAction)super.deadline(timestamp);
    }
}

