/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.handle;

import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.set.hash.TLongHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.Region;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.IPermissionHolder;
import net.dv8tion.jda.api.entities.PermissionOverride;
import net.dv8tion.jda.api.entities.channel.ChannelFlag;
import net.dv8tion.jda.api.entities.channel.ChannelType;
import net.dv8tion.jda.api.entities.channel.attribute.IThreadContainer;
import net.dv8tion.jda.api.entities.channel.concrete.Category;
import net.dv8tion.jda.api.entities.channel.concrete.NewsChannel;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import net.dv8tion.jda.api.entities.channel.concrete.ThreadChannel;
import net.dv8tion.jda.api.entities.channel.forums.ForumTag;
import net.dv8tion.jda.api.entities.channel.middleman.GuildChannel;
import net.dv8tion.jda.api.entities.emoji.EmojiUnion;
import net.dv8tion.jda.api.events.channel.forum.ForumTagAddEvent;
import net.dv8tion.jda.api.events.channel.forum.ForumTagRemoveEvent;
import net.dv8tion.jda.api.events.channel.forum.update.ForumTagUpdateEmojiEvent;
import net.dv8tion.jda.api.events.channel.forum.update.ForumTagUpdateModeratedEvent;
import net.dv8tion.jda.api.events.channel.forum.update.ForumTagUpdateNameEvent;
import net.dv8tion.jda.api.events.channel.update.ChannelUpdateBitrateEvent;
import net.dv8tion.jda.api.events.channel.update.ChannelUpdateDefaultReactionEvent;
import net.dv8tion.jda.api.events.channel.update.ChannelUpdateDefaultThreadSlowmodeEvent;
import net.dv8tion.jda.api.events.channel.update.ChannelUpdateFlagsEvent;
import net.dv8tion.jda.api.events.channel.update.ChannelUpdateNSFWEvent;
import net.dv8tion.jda.api.events.channel.update.ChannelUpdateNameEvent;
import net.dv8tion.jda.api.events.channel.update.ChannelUpdateParentEvent;
import net.dv8tion.jda.api.events.channel.update.ChannelUpdatePositionEvent;
import net.dv8tion.jda.api.events.channel.update.ChannelUpdateRegionEvent;
import net.dv8tion.jda.api.events.channel.update.ChannelUpdateSlowmodeEvent;
import net.dv8tion.jda.api.events.channel.update.ChannelUpdateTopicEvent;
import net.dv8tion.jda.api.events.channel.update.ChannelUpdateTypeEvent;
import net.dv8tion.jda.api.events.channel.update.ChannelUpdateUserLimitEvent;
import net.dv8tion.jda.api.events.guild.override.PermissionOverrideCreateEvent;
import net.dv8tion.jda.api.events.guild.override.PermissionOverrideDeleteEvent;
import net.dv8tion.jda.api.events.guild.override.PermissionOverrideUpdateEvent;
import net.dv8tion.jda.api.events.thread.ThreadHiddenEvent;
import net.dv8tion.jda.api.utils.cache.CacheFlag;
import net.dv8tion.jda.api.utils.cache.SortedSnowflakeCacheView;
import net.dv8tion.jda.api.utils.data.DataArray;
import net.dv8tion.jda.api.utils.data.DataObject;
import net.dv8tion.jda.internal.JDAImpl;
import net.dv8tion.jda.internal.entities.EntityBuilder;
import net.dv8tion.jda.internal.entities.ForumChannelImpl;
import net.dv8tion.jda.internal.entities.ForumTagImpl;
import net.dv8tion.jda.internal.entities.GuildImpl;
import net.dv8tion.jda.internal.entities.PermissionOverrideImpl;
import net.dv8tion.jda.internal.entities.channel.concrete.CategoryImpl;
import net.dv8tion.jda.internal.entities.channel.concrete.NewsChannelImpl;
import net.dv8tion.jda.internal.entities.channel.concrete.StageChannelImpl;
import net.dv8tion.jda.internal.entities.channel.concrete.TextChannelImpl;
import net.dv8tion.jda.internal.entities.channel.concrete.VoiceChannelImpl;
import net.dv8tion.jda.internal.entities.channel.mixin.attribute.IPermissionContainerMixin;
import net.dv8tion.jda.internal.handle.EventCache;
import net.dv8tion.jda.internal.handle.SocketHandler;
import net.dv8tion.jda.internal.requests.WebSocketClient;
import net.dv8tion.jda.internal.utils.UnlockHook;
import net.dv8tion.jda.internal.utils.cache.AbstractCacheView;
import net.dv8tion.jda.internal.utils.cache.ReadWriteLockCache;
import net.dv8tion.jda.internal.utils.cache.SnowflakeCacheViewImpl;
import net.dv8tion.jda.internal.utils.cache.SortedSnowflakeCacheViewImpl;

public class ChannelUpdateHandler
extends SocketHandler {
    public ChannelUpdateHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(DataObject content) {
        ChannelType type = ChannelType.fromId(content.getInt("type"));
        if (type == ChannelType.GROUP) {
            WebSocketClient.LOG.warn("Ignoring CHANNEL_UPDATE for a group which we don't support");
            return null;
        }
        if (!content.isNull("guild_id")) {
            long guildId = content.getUnsignedLong("guild_id");
            if (this.getJDA().getGuildSetupController().isLocked(guildId)) {
                return guildId;
            }
        }
        long channelId = content.getLong("id");
        long parentId = content.isNull("parent_id") ? 0L : content.getLong("parent_id");
        int position = content.getInt("position");
        int flags = content.getInt("flags", 0);
        String name = content.getString("name");
        boolean nsfw = content.getBoolean("nsfw");
        int defaultThreadSlowmode = content.getInt("default_thread_rate_limit_per_user", 0);
        int slowmode = content.getInt("rate_limit_per_user", 0);
        DataArray permOverwrites = content.getArray("permission_overwrites");
        GuildChannel channel = this.getJDA().getGuildChannelById(channelId);
        if (channel == null) {
            this.getJDA().getEventCache().cache(EventCache.Type.CHANNEL, channelId, this.responseNumber, this.allContent, this::handle);
            EventCache.LOG.debug("CHANNEL_UPDATE attempted to update a channel that does not exist. JSON: {}", (Object)content);
            return null;
        }
        channel = this.handleChannelTypeChange(channel, content, type);
        switch (type) {
            case TEXT: {
                String topic = content.getString("topic", null);
                TextChannelImpl textChannel = (TextChannelImpl)channel;
                long oldParentId = textChannel.getParentCategoryIdLong();
                String oldName = textChannel.getName();
                String oldTopic = textChannel.getTopic();
                int oldPosition = textChannel.getPositionRaw();
                boolean oldNsfw = textChannel.isNSFW();
                int oldSlowmode = textChannel.getSlowmode();
                int oldDefaultThreadSlowmode = textChannel.getDefaultThreadSlowmode();
                if (!Objects.equals(oldName, name)) {
                    textChannel.setName(name);
                    this.getJDA().handleEvent(new ChannelUpdateNameEvent(this.getJDA(), this.responseNumber, textChannel, oldName, name));
                }
                if (oldParentId != parentId) {
                    Category oldParent = textChannel.getParentCategory();
                    textChannel.setParentCategory(parentId);
                    this.getJDA().handleEvent(new ChannelUpdateParentEvent(this.getJDA(), this.responseNumber, textChannel, oldParent, textChannel.getParentCategory()));
                }
                if (!Objects.equals(oldTopic, topic)) {
                    textChannel.setTopic(topic);
                    this.getJDA().handleEvent(new ChannelUpdateTopicEvent(this.getJDA(), this.responseNumber, textChannel, oldTopic, topic));
                }
                if (oldPosition != position) {
                    textChannel.setPosition(position);
                    this.getJDA().handleEvent(new ChannelUpdatePositionEvent(this.getJDA(), this.responseNumber, textChannel, oldPosition, position));
                }
                if (oldNsfw != nsfw) {
                    textChannel.setNSFW(nsfw);
                    this.getJDA().handleEvent(new ChannelUpdateNSFWEvent(this.getJDA(), this.responseNumber, textChannel, oldNsfw, nsfw));
                }
                if (oldSlowmode != slowmode) {
                    textChannel.setSlowmode(slowmode);
                    this.getJDA().handleEvent(new ChannelUpdateSlowmodeEvent(this.getJDA(), this.responseNumber, textChannel, oldSlowmode, slowmode));
                }
                if (oldDefaultThreadSlowmode == defaultThreadSlowmode) break;
                textChannel.setDefaultThreadSlowmode(defaultThreadSlowmode);
                this.getJDA().handleEvent(new ChannelUpdateDefaultThreadSlowmodeEvent(this.getJDA(), this.responseNumber, textChannel, oldDefaultThreadSlowmode, defaultThreadSlowmode));
                break;
            }
            case FORUM: {
                String topic = content.getString("topic", null);
                EmojiUnion defaultReaction = content.optObject("default_reaction_emoji").map(json -> {
                    json.opt("emoji_id").ifPresent(id -> json.put("id", id));
                    json.opt("emoji_name").ifPresent(n -> json.put("name", n));
                    return EntityBuilder.createEmoji(json);
                }).orElse(null);
                ForumChannelImpl forumChannel = (ForumChannelImpl)channel;
                content.optArray("available_tags").ifPresent(array -> this.handleTagsUpdate(forumChannel, (DataArray)array));
                long oldParentId = forumChannel.getParentCategoryIdLong();
                String oldName = forumChannel.getName();
                String oldTopic = forumChannel.getTopic();
                int oldPosition = forumChannel.getPositionRaw();
                boolean oldNsfw = forumChannel.isNSFW();
                int oldSlowmode = forumChannel.getSlowmode();
                int oldDefaultThreadSlowmode = forumChannel.getDefaultThreadSlowmode();
                int oldFlags = forumChannel.getRawFlags();
                EmojiUnion oldDefaultReaction = forumChannel.getDefaultReaction();
                if (!Objects.equals(oldName, name)) {
                    forumChannel.setName(name);
                    this.getJDA().handleEvent(new ChannelUpdateNameEvent(this.getJDA(), this.responseNumber, forumChannel, oldName, name));
                }
                if (oldParentId != parentId) {
                    Category oldParent = forumChannel.getParentCategory();
                    forumChannel.setParentCategory(parentId);
                    this.getJDA().handleEvent(new ChannelUpdateParentEvent(this.getJDA(), this.responseNumber, forumChannel, oldParent, forumChannel.getParentCategory()));
                }
                if (!Objects.equals(oldTopic, topic)) {
                    forumChannel.setTopic(topic);
                    this.getJDA().handleEvent(new ChannelUpdateTopicEvent(this.getJDA(), this.responseNumber, forumChannel, oldTopic, topic));
                }
                if (oldPosition != position) {
                    forumChannel.setPosition(position);
                    this.getJDA().handleEvent(new ChannelUpdatePositionEvent(this.getJDA(), this.responseNumber, forumChannel, oldPosition, position));
                }
                if (oldNsfw != nsfw) {
                    forumChannel.setNSFW(nsfw);
                    this.getJDA().handleEvent(new ChannelUpdateNSFWEvent(this.getJDA(), this.responseNumber, forumChannel, oldNsfw, nsfw));
                }
                if (oldSlowmode != slowmode) {
                    forumChannel.setSlowmode(slowmode);
                    this.getJDA().handleEvent(new ChannelUpdateSlowmodeEvent(this.getJDA(), this.responseNumber, forumChannel, oldSlowmode, slowmode));
                }
                if (oldDefaultThreadSlowmode != defaultThreadSlowmode) {
                    forumChannel.setDefaultThreadSlowmode(defaultThreadSlowmode);
                    this.getJDA().handleEvent(new ChannelUpdateDefaultThreadSlowmodeEvent(this.getJDA(), this.responseNumber, forumChannel, oldDefaultThreadSlowmode, defaultThreadSlowmode));
                }
                if (oldFlags != flags) {
                    forumChannel.setFlags(flags);
                    this.getJDA().handleEvent(new ChannelUpdateFlagsEvent(this.getJDA(), this.responseNumber, forumChannel, ChannelFlag.fromRaw(oldFlags), ChannelFlag.fromRaw(flags)));
                }
                if (Objects.equals(oldDefaultReaction, defaultReaction)) break;
                forumChannel.setDefaultReaction(content.optObject("default_reaction_emoji").orElse(null));
                this.getJDA().handleEvent(new ChannelUpdateDefaultReactionEvent(this.getJDA(), this.responseNumber, forumChannel, oldDefaultReaction, defaultReaction));
                break;
            }
            case NEWS: {
                String topic = content.getString("topic", null);
                NewsChannelImpl newsChannel = (NewsChannelImpl)channel;
                long oldParentId = newsChannel.getParentCategoryIdLong();
                String oldName = newsChannel.getName();
                String oldTopic = newsChannel.getTopic();
                int oldPosition = newsChannel.getPositionRaw();
                boolean oldNsfw = newsChannel.isNSFW();
                if (!Objects.equals(oldName, name)) {
                    newsChannel.setName(name);
                    this.getJDA().handleEvent(new ChannelUpdateNameEvent(this.getJDA(), this.responseNumber, newsChannel, oldName, name));
                }
                if (oldParentId != parentId) {
                    Category oldParent = newsChannel.getParentCategory();
                    newsChannel.setParentCategory(parentId);
                    this.getJDA().handleEvent(new ChannelUpdateParentEvent(this.getJDA(), this.responseNumber, newsChannel, oldParent, newsChannel.getParentCategory()));
                }
                if (!Objects.equals(oldTopic, topic)) {
                    newsChannel.setTopic(topic);
                    this.getJDA().handleEvent(new ChannelUpdateTopicEvent(this.getJDA(), this.responseNumber, newsChannel, oldTopic, topic));
                }
                if (oldPosition != position) {
                    newsChannel.setPosition(position);
                    this.getJDA().handleEvent(new ChannelUpdatePositionEvent(this.getJDA(), this.responseNumber, newsChannel, oldPosition, position));
                }
                if (oldNsfw == nsfw) break;
                newsChannel.setNSFW(nsfw);
                this.getJDA().handleEvent(new ChannelUpdateNSFWEvent(this.getJDA(), this.responseNumber, newsChannel, oldNsfw, nsfw));
                break;
            }
            case VOICE: {
                int userLimit = content.getInt("user_limit");
                int bitrate = content.getInt("bitrate");
                String regionRaw = content.getString("rtc_region", null);
                VoiceChannelImpl voiceChannel = (VoiceChannelImpl)channel;
                long oldParentId = voiceChannel.getParentCategoryIdLong();
                String oldName = voiceChannel.getName();
                String oldRegionRaw = voiceChannel.getRegionRaw();
                int oldPosition = voiceChannel.getPositionRaw();
                int oldLimit = voiceChannel.getUserLimit();
                int oldBitrate = voiceChannel.getBitrate();
                boolean oldNsfw = voiceChannel.isNSFW();
                if (!Objects.equals(oldName, name)) {
                    voiceChannel.setName(name);
                    this.getJDA().handleEvent(new ChannelUpdateNameEvent(this.getJDA(), this.responseNumber, voiceChannel, oldName, name));
                }
                if (!Objects.equals(oldRegionRaw, regionRaw)) {
                    Region oldRegion = Region.fromKey(oldRegionRaw);
                    voiceChannel.setRegion(regionRaw);
                    this.getJDA().handleEvent(new ChannelUpdateRegionEvent(this.getJDA(), this.responseNumber, voiceChannel, oldRegion, voiceChannel.getRegion()));
                }
                if (oldParentId != parentId) {
                    Category oldParent = voiceChannel.getParentCategory();
                    voiceChannel.setParentCategory(parentId);
                    this.getJDA().handleEvent(new ChannelUpdateParentEvent(this.getJDA(), this.responseNumber, voiceChannel, oldParent, voiceChannel.getParentCategory()));
                }
                if (oldPosition != position) {
                    voiceChannel.setPosition(position);
                    this.getJDA().handleEvent(new ChannelUpdatePositionEvent(this.getJDA(), this.responseNumber, voiceChannel, oldPosition, position));
                }
                if (oldLimit != userLimit) {
                    voiceChannel.setUserLimit(userLimit);
                    this.getJDA().handleEvent(new ChannelUpdateUserLimitEvent(this.getJDA(), this.responseNumber, voiceChannel, oldLimit, userLimit));
                }
                if (oldBitrate != bitrate) {
                    voiceChannel.setBitrate(bitrate);
                    this.getJDA().handleEvent(new ChannelUpdateBitrateEvent(this.getJDA(), this.responseNumber, voiceChannel, oldBitrate, bitrate));
                }
                if (oldNsfw == nsfw) break;
                voiceChannel.setNSFW(nsfw);
                this.getJDA().handleEvent(new ChannelUpdateNSFWEvent(this.getJDA(), this.responseNumber, voiceChannel, oldNsfw, nsfw));
                break;
            }
            case STAGE: {
                int bitrate = content.getInt("bitrate");
                String regionRaw = content.getString("rtc_region", null);
                StageChannelImpl stageChannel = (StageChannelImpl)channel;
                long oldParentId = stageChannel.getParentCategoryIdLong();
                String oldName = stageChannel.getName();
                String oldRegionRaw = stageChannel.getRegionRaw();
                int oldPosition = stageChannel.getPositionRaw();
                int oldBitrate = stageChannel.getBitrate();
                if (!Objects.equals(oldName, name)) {
                    stageChannel.setName(name);
                    this.getJDA().handleEvent(new ChannelUpdateNameEvent(this.getJDA(), this.responseNumber, stageChannel, oldName, name));
                }
                if (!Objects.equals(oldRegionRaw, regionRaw)) {
                    Region oldRegion = Region.fromKey(oldRegionRaw);
                    stageChannel.setRegion(regionRaw);
                    this.getJDA().handleEvent(new ChannelUpdateRegionEvent(this.getJDA(), this.responseNumber, stageChannel, oldRegion, stageChannel.getRegion()));
                }
                if (oldParentId != parentId) {
                    Category oldParent = stageChannel.getParentCategory();
                    stageChannel.setParentCategory(parentId);
                    this.getJDA().handleEvent(new ChannelUpdateParentEvent(this.getJDA(), this.responseNumber, stageChannel, oldParent, stageChannel.getParentCategory()));
                }
                if (oldPosition != position) {
                    stageChannel.setPosition(position);
                    this.getJDA().handleEvent(new ChannelUpdatePositionEvent(this.getJDA(), this.responseNumber, stageChannel, oldPosition, position));
                }
                if (oldBitrate == bitrate) break;
                stageChannel.setBitrate(bitrate);
                this.getJDA().handleEvent(new ChannelUpdateBitrateEvent(this.getJDA(), this.responseNumber, stageChannel, oldBitrate, bitrate));
                break;
            }
            case CATEGORY: {
                CategoryImpl category = (CategoryImpl)channel;
                String oldName = category.getName();
                int oldPosition = category.getPositionRaw();
                if (!Objects.equals(oldName, name)) {
                    category.setName(name);
                    this.getJDA().handleEvent(new ChannelUpdateNameEvent(this.getJDA(), this.responseNumber, category, oldName, name));
                }
                if (Objects.equals(oldPosition, position)) break;
                category.setPosition(position);
                this.getJDA().handleEvent(new ChannelUpdatePositionEvent(this.getJDA(), this.responseNumber, category, oldPosition, position));
                break;
            }
            default: {
                WebSocketClient.LOG.debug("CHANNEL_UPDATE provided an unrecognized channel type JSON: {}", (Object)content);
            }
        }
        this.applyPermissions((IPermissionContainerMixin)channel, permOverwrites);
        boolean hasAccessToChannel = channel.getGuild().getSelfMember().hasPermission(channel, Permission.VIEW_CHANNEL);
        if (channel instanceof IThreadContainer && !hasAccessToChannel) {
            this.handleHideChildThreads((IThreadContainer)channel);
        }
        return null;
    }

    private GuildChannel handleChannelTypeChange(GuildChannel channel, DataObject content, ChannelType newChannelType) {
        if (channel.getType() == newChannelType) {
            return channel;
        }
        EntityBuilder builder = this.getJDA().getEntityBuilder();
        GuildImpl guild = (GuildImpl)channel.getGuild();
        if (newChannelType == ChannelType.TEXT) {
            NewsChannel newsChannel = (NewsChannel)channel;
            this.getJDA().getNewsChannelView().remove(newsChannel.getIdLong());
            guild.getNewsChannelView().remove(newsChannel.getIdLong());
            TextChannelImpl textChannel = (TextChannelImpl)builder.createTextChannel(guild, content, guild.getIdLong());
            textChannel.setLatestMessageIdLong(newsChannel.getLatestMessageIdLong());
            this.getJDA().handleEvent(new ChannelUpdateTypeEvent(this.getJDA(), this.responseNumber, textChannel, ChannelType.NEWS, ChannelType.TEXT));
            return textChannel;
        }
        if (newChannelType == ChannelType.NEWS) {
            TextChannel textChannel = (TextChannel)channel;
            this.getJDA().getTextChannelsView().remove(textChannel.getIdLong());
            guild.getTextChannelsView().remove(textChannel.getIdLong());
            NewsChannelImpl newsChannel = (NewsChannelImpl)builder.createNewsChannel(guild, content, guild.getIdLong());
            newsChannel.setLatestMessageIdLong(textChannel.getLatestMessageIdLong());
            this.getJDA().handleEvent(new ChannelUpdateTypeEvent(this.getJDA(), this.responseNumber, newsChannel, ChannelType.TEXT, ChannelType.NEWS));
            return newsChannel;
        }
        return channel;
    }

    private void applyPermissions(IPermissionContainerMixin<?> channel, DataArray permOverwrites) {
        TLongObjectHashMap<PermissionOverride> currentOverrides = new TLongObjectHashMap<PermissionOverride>(channel.getPermissionOverrideMap());
        ArrayList<IPermissionHolder> changed = new ArrayList<IPermissionHolder>(currentOverrides.size());
        Guild guild = channel.getGuild();
        for (int i = 0; i < permOverwrites.length(); ++i) {
            DataObject overrideJson = permOverwrites.getObject(i);
            long id = overrideJson.getUnsignedLong("id", 0L);
            if (!this.handlePermissionOverride((PermissionOverride)currentOverrides.remove(id), overrideJson, id, channel)) continue;
            this.addPermissionHolder(changed, guild, id);
        }
        currentOverrides.forEachValue(override -> {
            channel.getPermissionOverrideMap().remove(override.getIdLong());
            this.addPermissionHolder(changed, guild, override.getIdLong());
            this.api.handleEvent(new PermissionOverrideDeleteEvent(this.api, this.responseNumber, channel, (PermissionOverride)override));
            return true;
        });
    }

    private void addPermissionHolder(List<IPermissionHolder> changed, Guild guild, long id) {
        IPermissionHolder holder = guild.getRoleById(id);
        if (holder == null) {
            holder = guild.getMemberById(id);
        }
        if (holder != null) {
            changed.add(holder);
        }
    }

    private boolean handlePermissionOverride(PermissionOverride currentOverride, DataObject override, long overrideId, IPermissionContainerMixin<?> channel) {
        boolean isRole;
        long allow = override.getLong("allow");
        long deny = override.getLong("deny");
        int type = override.getInt("type");
        boolean bl = isRole = type == 0;
        if (!isRole) {
            if (type != 1) {
                EntityBuilder.LOG.debug("Ignoring unknown invite of type '{}'. JSON: {}", (Object)type, (Object)override);
                return false;
            }
            if (!this.api.isCacheFlagSet(CacheFlag.MEMBER_OVERRIDES) && overrideId != this.api.getSelfUser().getIdLong()) {
                return false;
            }
        }
        if (currentOverride != null) {
            long oldAllow = currentOverride.getAllowedRaw();
            long oldDeny = currentOverride.getDeniedRaw();
            PermissionOverrideImpl impl = (PermissionOverrideImpl)currentOverride;
            if (oldAllow == allow && oldDeny == deny) {
                return false;
            }
            if (overrideId == channel.getGuild().getIdLong() && (allow | deny) == 0L) {
                channel.getPermissionOverrideMap().remove(overrideId);
                this.api.handleEvent(new PermissionOverrideDeleteEvent(this.api, this.responseNumber, channel, currentOverride));
                return true;
            }
            impl.setAllow(allow);
            impl.setDeny(deny);
            this.api.handleEvent(new PermissionOverrideUpdateEvent(this.api, this.responseNumber, channel, currentOverride, oldAllow, oldDeny));
        } else {
            if (overrideId == channel.getGuild().getIdLong() && (allow | deny) == 0L) {
                return false;
            }
            PermissionOverrideImpl impl = new PermissionOverrideImpl(channel, overrideId, isRole);
            currentOverride = impl;
            impl.setAllow(allow);
            impl.setDeny(deny);
            channel.getPermissionOverrideMap().put(overrideId, currentOverride);
            this.api.handleEvent(new PermissionOverrideCreateEvent(this.api, this.responseNumber, channel, currentOverride));
        }
        return true;
    }

    private void handleHideChildThreads(IThreadContainer channel) {
        List<ThreadChannel> threads = channel.getThreadChannels();
        if (threads.isEmpty()) {
            return;
        }
        for (ThreadChannel thread : threads) {
            GuildImpl guild = (GuildImpl)channel.getGuild();
            SortedSnowflakeCacheViewImpl<ThreadChannel> guildThreadView = guild.getThreadChannelsView();
            SnowflakeCacheViewImpl<ThreadChannel> threadView = this.getJDA().getThreadChannelsView();
            UnlockHook vlock = guildThreadView.writeLock();
            try {
                UnlockHook jlock = threadView.writeLock();
                try {
                    threadView.getMap().remove(thread.getIdLong());
                    guildThreadView.getMap().remove(thread.getIdLong());
                }
                finally {
                    if (jlock == null) continue;
                    jlock.close();
                }
            }
            finally {
                if (vlock == null) continue;
                vlock.close();
            }
        }
        for (ThreadChannel thread : threads) {
            this.api.handleEvent(new ThreadHiddenEvent(this.api, this.responseNumber, thread));
        }
    }

    private void handleTagsUpdate(ForumChannelImpl channel, DataArray tags) {
        if (!this.api.isCacheFlagSet(CacheFlag.FORUM_TAGS)) {
            return;
        }
        EntityBuilder builder = this.api.getEntityBuilder();
        SortedSnowflakeCacheView view = channel.getAvailableTagCache();
        try (UnlockHook hook = ((ReadWriteLockCache)((Object)view)).writeLock();){
            TLongObjectMap cache = ((AbstractCacheView)((Object)view)).getMap();
            TLongHashSet removedTags = new TLongHashSet(cache.keySet());
            for (int i = 0; i < tags.length(); ++i) {
                DataObject tagJson = tags.getObject(i);
                long id2 = tagJson.getUnsignedLong("id");
                if (removedTags.remove(id2)) {
                    ForumTagImpl impl = (ForumTagImpl)cache.get(id2);
                    if (impl == null) continue;
                    String name = tagJson.getString("name");
                    boolean moderated = tagJson.getBoolean("moderated");
                    String oldName = impl.getName();
                    EmojiUnion oldEmoji = impl.getEmoji();
                    impl.setEmoji(tagJson);
                    impl.setPosition(i);
                    if (!Objects.equals(oldEmoji, impl.getEmoji())) {
                        this.api.handleEvent(new ForumTagUpdateEmojiEvent(this.api, this.responseNumber, channel, impl, oldEmoji));
                    }
                    if (!name.equals(oldName)) {
                        impl.setName(name);
                        this.api.handleEvent(new ForumTagUpdateNameEvent(this.api, this.responseNumber, channel, impl, oldName));
                    }
                    if (moderated == impl.isModerated()) continue;
                    impl.setModerated(moderated);
                    this.api.handleEvent(new ForumTagUpdateModeratedEvent(this.api, this.responseNumber, channel, impl, moderated));
                    continue;
                }
                ForumTagImpl tag = builder.createForumTag(channel, tagJson, i);
                cache.put(id2, tag);
                this.api.handleEvent(new ForumTagAddEvent(this.api, this.responseNumber, channel, tag));
            }
            removedTags.forEach(id -> {
                ForumTag tag = (ForumTag)cache.remove(id);
                if (tag != null) {
                    this.api.handleEvent(new ForumTagRemoveEvent(this.api, this.responseNumber, channel, tag));
                }
                return true;
            });
        }
    }
}

