/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.handle;

import java.util.Objects;
import net.dv8tion.jda.api.entities.channel.concrete.ThreadChannel;
import net.dv8tion.jda.api.events.channel.update.ChannelUpdateArchiveTimestampEvent;
import net.dv8tion.jda.api.events.channel.update.ChannelUpdateArchivedEvent;
import net.dv8tion.jda.api.events.channel.update.ChannelUpdateAutoArchiveDurationEvent;
import net.dv8tion.jda.api.events.channel.update.ChannelUpdateInvitableEvent;
import net.dv8tion.jda.api.events.channel.update.ChannelUpdateLockedEvent;
import net.dv8tion.jda.api.events.channel.update.ChannelUpdateNameEvent;
import net.dv8tion.jda.api.events.channel.update.ChannelUpdateSlowmodeEvent;
import net.dv8tion.jda.api.utils.data.DataObject;
import net.dv8tion.jda.internal.JDAImpl;
import net.dv8tion.jda.internal.entities.channel.concrete.ThreadChannelImpl;
import net.dv8tion.jda.internal.handle.SocketHandler;
import net.dv8tion.jda.internal.utils.Helpers;

public class ThreadUpdateHandler
extends SocketHandler {
    public ThreadUpdateHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(DataObject content) {
        long guildId = content.getLong("guild_id");
        if (this.api.getGuildSetupController().isLocked(guildId)) {
            return guildId;
        }
        long threadId = content.getLong("id");
        ThreadChannelImpl thread = (ThreadChannelImpl)this.getJDA().getThreadChannelById(threadId);
        if (thread == null) {
            thread = (ThreadChannelImpl)this.api.getEntityBuilder().createThreadChannel(content, guildId);
            this.api.handleEvent(new ChannelUpdateArchivedEvent(this.api, this.responseNumber, thread, true, false));
            return null;
        }
        DataObject threadMetadata = content.getObject("thread_metadata");
        String name = content.getString("name");
        ThreadChannel.AutoArchiveDuration autoArchiveDuration = ThreadChannel.AutoArchiveDuration.fromKey(threadMetadata.getInt("auto_archive_duration"));
        boolean locked = threadMetadata.getBoolean("locked");
        boolean archived = threadMetadata.getBoolean("archived");
        boolean invitable = threadMetadata.getBoolean("invitable");
        long archiveTimestamp = Helpers.toTimestamp(threadMetadata.getString("archive_timestamp"));
        int slowmode = content.getInt("rate_limit_per_user", 0);
        String oldName = thread.getName();
        ThreadChannel.AutoArchiveDuration oldAutoArchiveDuration = thread.getAutoArchiveDuration();
        boolean oldLocked = thread.isLocked();
        boolean oldArchived = thread.isArchived();
        boolean oldInvitable = !thread.isPublic() && thread.isInvitable();
        long oldArchiveTimestamp = thread.getArchiveTimestamp();
        int oldSlowmode = thread.getSlowmode();
        if (!Objects.equals(oldName, name)) {
            thread.setName(name);
            this.api.handleEvent(new ChannelUpdateNameEvent(this.getJDA(), this.responseNumber, thread, oldName, name));
        }
        if (oldSlowmode != slowmode) {
            thread.setSlowmode(slowmode);
            this.api.handleEvent(new ChannelUpdateSlowmodeEvent(this.api, this.responseNumber, thread, oldSlowmode, slowmode));
        }
        if (oldAutoArchiveDuration != autoArchiveDuration) {
            thread.setAutoArchiveDuration(autoArchiveDuration);
            this.api.handleEvent(new ChannelUpdateAutoArchiveDurationEvent(this.api, this.responseNumber, thread, oldAutoArchiveDuration, autoArchiveDuration));
        }
        if (oldLocked != locked) {
            thread.setLocked(locked);
            this.api.handleEvent(new ChannelUpdateLockedEvent(this.api, this.responseNumber, thread, oldLocked, locked));
        }
        if (oldArchived != archived) {
            thread.setArchived(archived);
            this.api.handleEvent(new ChannelUpdateArchivedEvent(this.api, this.responseNumber, thread, oldArchived, archived));
        }
        if (oldArchiveTimestamp != archiveTimestamp) {
            thread.setArchiveTimestamp(archiveTimestamp);
            this.api.handleEvent(new ChannelUpdateArchiveTimestampEvent(this.api, this.responseNumber, thread, oldArchiveTimestamp, archiveTimestamp));
        }
        if (oldInvitable != invitable) {
            thread.setInvitable(invitable);
            this.api.handleEvent(new ChannelUpdateInvitableEvent(this.api, this.responseNumber, thread, oldInvitable, invitable));
        }
        return null;
    }
}

