/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.entities.channel.concrete;

import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.ThreadMember;
import net.dv8tion.jda.api.entities.channel.ChannelType;
import net.dv8tion.jda.api.entities.channel.attribute.IPermissionContainer;
import net.dv8tion.jda.api.entities.channel.concrete.ThreadChannel;
import net.dv8tion.jda.api.entities.channel.middleman.GuildChannel;
import net.dv8tion.jda.api.entities.channel.unions.IThreadContainerUnion;
import net.dv8tion.jda.api.managers.channel.concrete.ThreadChannelManager;
import net.dv8tion.jda.api.requests.RestAction;
import net.dv8tion.jda.api.requests.restaction.CacheRestAction;
import net.dv8tion.jda.api.utils.TimeUtil;
import net.dv8tion.jda.api.utils.cache.CacheView;
import net.dv8tion.jda.api.utils.data.DataArray;
import net.dv8tion.jda.api.utils.data.DataObject;
import net.dv8tion.jda.internal.JDAImpl;
import net.dv8tion.jda.internal.entities.EntityBuilder;
import net.dv8tion.jda.internal.entities.GuildImpl;
import net.dv8tion.jda.internal.entities.channel.middleman.AbstractGuildChannelImpl;
import net.dv8tion.jda.internal.entities.channel.mixin.middleman.GuildMessageChannelMixin;
import net.dv8tion.jda.internal.managers.channel.concrete.ThreadChannelManagerImpl;
import net.dv8tion.jda.internal.requests.DeferredRestAction;
import net.dv8tion.jda.internal.requests.RestActionImpl;
import net.dv8tion.jda.internal.requests.Route;
import net.dv8tion.jda.internal.utils.Checks;
import net.dv8tion.jda.internal.utils.Helpers;

public class ThreadChannelImpl
extends AbstractGuildChannelImpl<ThreadChannelImpl>
implements ThreadChannel,
GuildMessageChannelMixin<ThreadChannelImpl> {
    private final ChannelType type;
    private final CacheView.SimpleCacheView<ThreadMember> threadMembers = new CacheView.SimpleCacheView<ThreadMember>(ThreadMember.class, null);
    private ThreadChannel.AutoArchiveDuration autoArchiveDuration;
    private boolean locked;
    private boolean archived;
    private boolean invitable;
    private long parentChannelId;
    private long archiveTimestamp;
    private long creationTimestamp;
    private long ownerId;
    private long latestMessageId;
    private int messageCount;
    private int memberCount;
    private int slowmode;

    public ThreadChannelImpl(long id, GuildImpl guild, ChannelType type) {
        super(id, guild);
        this.type = type;
    }

    @Override
    @Nonnull
    public ChannelType getType() {
        return this.type;
    }

    @Override
    public long getLatestMessageIdLong() {
        return this.latestMessageId;
    }

    @Override
    public int getMessageCount() {
        return this.messageCount;
    }

    @Override
    public int getMemberCount() {
        return this.memberCount;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public boolean canTalk(@Nonnull Member member) {
        Checks.notNull(member, "Member");
        return member.hasPermission((GuildChannel)this.getParentChannel(), Permission.VIEW_CHANNEL, Permission.MESSAGE_SEND_IN_THREADS);
    }

    @Override
    @Nonnull
    public List<Member> getMembers() {
        return null;
    }

    @Override
    @Nonnull
    public IThreadContainerUnion getParentChannel() {
        return (IThreadContainerUnion)this.guild.getGuildChannelById(this.parentChannelId);
    }

    @Override
    @Nonnull
    public RestAction<Message> retrieveParentMessage() {
        return this.getParentMessageChannel().retrieveMessageById(this.getIdLong());
    }

    @Override
    public IPermissionContainer getPermissionContainer() {
        return this.getParentChannel();
    }

    @Override
    @Nonnull
    public List<ThreadMember> getThreadMembers() {
        return this.threadMembers.asList();
    }

    @Override
    @Nullable
    public ThreadMember getThreadMemberById(long id) {
        return (ThreadMember)this.threadMembers.get(id);
    }

    @Override
    @Nonnull
    public CacheRestAction<ThreadMember> retrieveThreadMemberById(long id) {
        JDAImpl jda = (JDAImpl)this.getJDA();
        return new DeferredRestAction<ThreadMember, RestActionImpl>(jda, ThreadMember.class, () -> this.getThreadMemberById(id), () -> {
            Route.CompiledRoute route = Route.Channels.GET_THREAD_MEMBER.compile(this.getId(), Long.toUnsignedString(id));
            return new RestActionImpl<ThreadMember>((JDA)jda, route, (resp, req) -> jda.getEntityBuilder().createThreadMember(this.getGuild(), this, resp.getObject()));
        });
    }

    @Override
    public RestAction<List<ThreadMember>> retrieveThreadMembers() {
        Route.CompiledRoute route = Route.Channels.LIST_THREAD_MEMBERS.compile(this.getId());
        return new RestActionImpl<List<ThreadMember>>(this.getJDA(), route, (response, request) -> {
            EntityBuilder builder = this.api.getEntityBuilder();
            LinkedList<ThreadMember> threadMembers = new LinkedList<ThreadMember>();
            DataArray memberArr = response.getArray();
            for (int i = 0; i < memberArr.length(); ++i) {
                DataObject object = memberArr.getObject(i);
                threadMembers.add(builder.createThreadMember(this.getGuild(), this, object));
            }
            return Collections.unmodifiableList(threadMembers);
        });
    }

    @Override
    public long getOwnerIdLong() {
        return this.ownerId;
    }

    @Override
    public boolean isArchived() {
        return this.archived;
    }

    @Override
    public boolean isInvitable() {
        if (this.type != ChannelType.GUILD_PRIVATE_THREAD) {
            throw new UnsupportedOperationException("Only private threads support the concept of invitable.");
        }
        return this.invitable;
    }

    @Override
    public OffsetDateTime getTimeArchiveInfoLastModified() {
        return Helpers.toOffset(this.archiveTimestamp);
    }

    @Override
    @Nonnull
    public ThreadChannel.AutoArchiveDuration getAutoArchiveDuration() {
        return this.autoArchiveDuration;
    }

    @Override
    @Nonnull
    public OffsetDateTime getTimeCreated() {
        return this.creationTimestamp == 0L ? TimeUtil.getTimeCreated(this.getIdLong()) : Helpers.toOffset(this.creationTimestamp);
    }

    @Override
    public int getSlowmode() {
        return this.slowmode;
    }

    @Override
    public RestAction<Void> join() {
        this.checkUnarchived();
        Route.CompiledRoute route = Route.Channels.JOIN_THREAD.compile(this.getId());
        return new RestActionImpl<Void>(this.api, route);
    }

    @Override
    public RestAction<Void> leave() {
        this.checkUnarchived();
        Route.CompiledRoute route = Route.Channels.LEAVE_THREAD.compile(this.getId());
        return new RestActionImpl<Void>(this.api, route);
    }

    @Override
    public RestAction<Void> addThreadMemberById(long id) {
        this.checkUnarchived();
        Route.CompiledRoute route = Route.Channels.ADD_THREAD_MEMBER.compile(this.getId(), Long.toUnsignedString(id));
        return new RestActionImpl<Void>(this.api, route);
    }

    @Override
    public RestAction<Void> removeThreadMemberById(long id) {
        boolean privateThreadOwner;
        this.checkUnarchived();
        boolean bl = privateThreadOwner = this.type == ChannelType.GUILD_PRIVATE_THREAD && this.ownerId == this.api.getSelfUser().getIdLong();
        if (!privateThreadOwner) {
            this.checkPermission(Permission.MANAGE_THREADS);
        }
        Route.CompiledRoute route = Route.Channels.REMOVE_THREAD_MEMBER.compile(this.getId(), Long.toUnsignedString(id));
        return new RestActionImpl<Void>(this.api, route);
    }

    @Override
    @Nonnull
    public ThreadChannelManager getManager() {
        return new ThreadChannelManagerImpl(this);
    }

    @Override
    public void checkCanManage() {
        if (this.isOwner()) {
            return;
        }
        this.checkPermission(Permission.MANAGE_THREADS);
    }

    public CacheView.SimpleCacheView<ThreadMember> getThreadMemberView() {
        return this.threadMembers;
    }

    @Override
    public ThreadChannelImpl setLatestMessageIdLong(long latestMessageId) {
        this.latestMessageId = latestMessageId;
        return this;
    }

    public ThreadChannelImpl setAutoArchiveDuration(ThreadChannel.AutoArchiveDuration autoArchiveDuration) {
        this.autoArchiveDuration = autoArchiveDuration;
        return this;
    }

    public ThreadChannelImpl setParentChannelId(long parentChannelId) {
        this.parentChannelId = parentChannelId;
        return this;
    }

    public ThreadChannelImpl setLocked(boolean locked) {
        this.locked = locked;
        return this;
    }

    public ThreadChannelImpl setArchived(boolean archived) {
        this.archived = archived;
        return this;
    }

    public ThreadChannelImpl setInvitable(boolean invitable) {
        this.invitable = invitable;
        return this;
    }

    public ThreadChannelImpl setArchiveTimestamp(long archiveTimestamp) {
        this.archiveTimestamp = archiveTimestamp;
        return this;
    }

    public ThreadChannelImpl setCreationTimestamp(long creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
        return this;
    }

    public ThreadChannelImpl setOwnerId(long ownerId) {
        this.ownerId = ownerId;
        return this;
    }

    public ThreadChannelImpl setMessageCount(int messageCount) {
        this.messageCount = messageCount;
        return this;
    }

    public ThreadChannelImpl setMemberCount(int memberCount) {
        this.memberCount = memberCount;
        return this;
    }

    public ThreadChannelImpl setSlowmode(int slowmode) {
        this.slowmode = slowmode;
        return this;
    }

    public long getArchiveTimestamp() {
        return this.archiveTimestamp;
    }

    public String toString() {
        return "ThC:" + this.getName() + '(' + this.id + ')';
    }

    private void checkUnarchived() {
        if (this.archived) {
            throw new IllegalStateException("Cannot modify a ThreadChannel while it is archived!");
        }
    }
}

