/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.entities;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.WebhookClient;
import net.dv8tion.jda.api.interactions.components.ActionRow;
import net.dv8tion.jda.api.interactions.components.LayoutComponent;
import net.dv8tion.jda.api.requests.RestAction;
import net.dv8tion.jda.api.requests.restaction.WebhookMessageCreateAction;
import net.dv8tion.jda.api.requests.restaction.WebhookMessageEditAction;
import net.dv8tion.jda.api.utils.AttachedFile;
import net.dv8tion.jda.api.utils.FileUpload;
import net.dv8tion.jda.api.utils.messages.MessageCreateData;
import net.dv8tion.jda.api.utils.messages.MessageEditData;
import net.dv8tion.jda.internal.requests.RestActionImpl;
import net.dv8tion.jda.internal.requests.Route;
import net.dv8tion.jda.internal.requests.restaction.WebhookMessageCreateActionImpl;
import net.dv8tion.jda.internal.requests.restaction.WebhookMessageEditActionImpl;
import net.dv8tion.jda.internal.utils.Checks;

public abstract class AbstractWebhookClient<T>
implements WebhookClient<T> {
    protected final long id;
    protected final JDA api;
    protected String token;

    protected AbstractWebhookClient(long webhookId, String webhookToken, JDA api) {
        this.id = webhookId;
        this.token = webhookToken;
        this.api = api;
    }

    public abstract WebhookMessageCreateActionImpl<T> sendRequest();

    public abstract WebhookMessageEditActionImpl<T> editRequest(String var1);

    @Override
    @Nonnull
    public WebhookMessageCreateAction<T> sendMessage(@Nonnull String content) {
        return (WebhookMessageCreateAction)this.sendRequest().setContent(content);
    }

    @Override
    @Nonnull
    public WebhookMessageCreateAction<T> sendMessageEmbeds(@Nonnull Collection<? extends MessageEmbed> embeds) {
        return (WebhookMessageCreateAction)this.sendRequest().addEmbeds(embeds);
    }

    @Override
    @Nonnull
    public WebhookMessageCreateAction<T> sendMessage(@Nonnull MessageCreateData message) {
        return (WebhookMessageCreateAction)this.sendRequest().applyData(message);
    }

    @Override
    @Nonnull
    public WebhookMessageCreateAction<T> sendFiles(@Nonnull Collection<? extends FileUpload> files) {
        return (WebhookMessageCreateAction)this.sendRequest().addFiles(files);
    }

    @Override
    @Nonnull
    public WebhookMessageEditActionImpl<T> editMessageById(@Nonnull String messageId, @Nonnull String content) {
        return (WebhookMessageEditActionImpl)this.editRequest(messageId).setContent(content);
    }

    @Override
    @Nonnull
    public WebhookMessageEditAction<T> editMessageComponentsById(@Nonnull String messageId, @Nonnull Collection<? extends LayoutComponent> components) {
        Checks.noneNull(components, "Components");
        if (components.stream().anyMatch(x -> !(x instanceof ActionRow))) {
            throw new UnsupportedOperationException("The provided component layout is not supported");
        }
        List actionRows = components.stream().map(ActionRow.class::cast).collect(Collectors.toList());
        return (WebhookMessageEditAction)this.editRequest(messageId).setComponents(actionRows);
    }

    @Override
    @Nonnull
    public WebhookMessageEditActionImpl<T> editMessageEmbedsById(@Nonnull String messageId, @Nonnull Collection<? extends MessageEmbed> embeds) {
        return (WebhookMessageEditActionImpl)this.editRequest(messageId).setEmbeds(embeds);
    }

    @Override
    @Nonnull
    public WebhookMessageEditActionImpl<T> editMessageById(@Nonnull String messageId, @Nonnull MessageEditData message) {
        return (WebhookMessageEditActionImpl)this.editRequest(messageId).applyData(message);
    }

    @Override
    @Nonnull
    public WebhookMessageEditActionImpl<T> editMessageAttachmentsById(@Nonnull String messageId, @Nonnull Collection<? extends AttachedFile> attachments) {
        return (WebhookMessageEditActionImpl)this.editRequest(messageId).setAttachments(attachments);
    }

    @Override
    @Nonnull
    public RestAction<Void> deleteMessageById(@Nonnull String messageId) {
        Checks.isSnowflake(messageId);
        Route.CompiledRoute route = Route.Webhooks.EXECUTE_WEBHOOK_DELETE.compile(Long.toUnsignedString(this.id), this.token, messageId);
        return new RestActionImpl<Void>(this.api, route);
    }
}

