/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.entities;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.Category;
import net.dv8tion.jda.api.entities.ChannelType;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Mentions;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.MessageReaction;
import net.dv8tion.jda.api.entities.MessageReference;
import net.dv8tion.jda.api.entities.MessageType;
import net.dv8tion.jda.api.entities.ThreadChannel;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.channel.unions.GuildMessageChannelUnion;
import net.dv8tion.jda.api.entities.channel.unions.MessageChannelUnion;
import net.dv8tion.jda.api.entities.emoji.Emoji;
import net.dv8tion.jda.api.entities.sticker.StickerItem;
import net.dv8tion.jda.api.interactions.components.LayoutComponent;
import net.dv8tion.jda.api.requests.RestAction;
import net.dv8tion.jda.api.requests.restaction.AuditableRestAction;
import net.dv8tion.jda.api.requests.restaction.MessageEditAction;
import net.dv8tion.jda.api.requests.restaction.ThreadChannelAction;
import net.dv8tion.jda.api.requests.restaction.pagination.ReactionPaginationAction;
import net.dv8tion.jda.api.utils.AttachedFile;
import net.dv8tion.jda.api.utils.messages.MessageEditData;
import net.dv8tion.jda.internal.utils.Helpers;

public abstract class AbstractMessage
implements Message {
    protected static final String UNSUPPORTED = "This operation is not supported for Messages of this type!";
    protected final String content;
    protected final String nonce;
    protected final boolean isTTS;

    public AbstractMessage(String content, String nonce, boolean isTTS) {
        this.content = content;
        this.nonce = nonce;
        this.isTTS = isTTS;
    }

    @Override
    @Nonnull
    public String getContentRaw() {
        return this.content;
    }

    @Override
    public String getNonce() {
        return this.nonce;
    }

    @Override
    public boolean isTTS() {
        return this.isTTS;
    }

    protected abstract void unsupported();

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        boolean upper = (flags & 2) == 2;
        boolean leftJustified = (flags & 1) == 1;
        String out = this.content;
        if (upper) {
            out = out.toUpperCase(formatter.locale());
        }
        this.appendFormat(formatter, width, precision, leftJustified, out);
    }

    protected void appendFormat(Formatter formatter, int width, int precision, boolean leftJustified, String out) {
        try {
            Appendable appendable = formatter.out();
            if (precision > -1 && out.length() > precision) {
                appendable.append(Helpers.truncate(out, precision - 3)).append("...");
                return;
            }
            if (leftJustified) {
                appendable.append(Helpers.rightPad(out, width));
            } else {
                appendable.append(Helpers.leftPad(out, width));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    @Nullable
    public MessageReference getMessageReference() {
        this.unsupported();
        return null;
    }

    @Override
    @Nonnull
    public Mentions getMentions() {
        this.unsupported();
        return null;
    }

    @Override
    public boolean isEdited() {
        this.unsupported();
        return false;
    }

    @Override
    public OffsetDateTime getTimeEdited() {
        this.unsupported();
        return null;
    }

    @Override
    @Nonnull
    public User getAuthor() {
        this.unsupported();
        return null;
    }

    @Override
    public Member getMember() {
        this.unsupported();
        return null;
    }

    @Override
    @Nonnull
    public String getJumpUrl() {
        this.unsupported();
        return null;
    }

    @Override
    @Nonnull
    public String getContentDisplay() {
        this.unsupported();
        return null;
    }

    @Override
    @Nonnull
    public String getContentStripped() {
        this.unsupported();
        return null;
    }

    @Override
    @Nonnull
    public List<String> getInvites() {
        this.unsupported();
        return null;
    }

    @Override
    public boolean isFromType(@Nonnull ChannelType type) {
        this.unsupported();
        return false;
    }

    @Override
    @Nonnull
    public ChannelType getChannelType() {
        this.unsupported();
        return null;
    }

    @Override
    public boolean isWebhookMessage() {
        this.unsupported();
        return false;
    }

    @Override
    @Nonnull
    public MessageChannelUnion getChannel() {
        this.unsupported();
        return null;
    }

    @Override
    @Nonnull
    public GuildMessageChannelUnion getGuildChannel() {
        this.unsupported();
        return null;
    }

    @Override
    public Category getCategory() {
        this.unsupported();
        return null;
    }

    @Override
    @Nonnull
    public Guild getGuild() {
        this.unsupported();
        return null;
    }

    @Override
    @Nonnull
    public List<Message.Attachment> getAttachments() {
        this.unsupported();
        return null;
    }

    @Override
    @Nonnull
    public List<MessageEmbed> getEmbeds() {
        this.unsupported();
        return null;
    }

    @Override
    @Nonnull
    public List<LayoutComponent> getComponents() {
        this.unsupported();
        return null;
    }

    @Override
    @Nonnull
    public List<MessageReaction> getReactions() {
        this.unsupported();
        return null;
    }

    @Override
    @Nonnull
    public List<StickerItem> getStickers() {
        this.unsupported();
        return null;
    }

    @Override
    @Nonnull
    public MessageEditAction editMessage(@Nonnull CharSequence newContent) {
        this.unsupported();
        return null;
    }

    @Override
    @Nonnull
    public MessageEditAction editMessageEmbeds(@Nonnull Collection<? extends MessageEmbed> newContent) {
        this.unsupported();
        return null;
    }

    @Override
    @Nonnull
    public MessageEditAction editMessageComponents(@Nonnull Collection<? extends LayoutComponent> components) {
        this.unsupported();
        return null;
    }

    @Override
    @Nonnull
    public MessageEditAction editMessageFormat(@Nonnull String format, Object ... args2) {
        this.unsupported();
        return null;
    }

    @Override
    @Nonnull
    public MessageEditAction editMessageAttachments(@Nonnull Collection<? extends AttachedFile> attachments) {
        this.unsupported();
        return null;
    }

    @Override
    @Nonnull
    public MessageEditAction editMessage(@Nonnull MessageEditData newContent) {
        this.unsupported();
        return null;
    }

    @Override
    @Nonnull
    public AuditableRestAction<Void> delete() {
        this.unsupported();
        return null;
    }

    @Override
    @Nonnull
    public JDA getJDA() {
        this.unsupported();
        return null;
    }

    @Override
    public boolean isPinned() {
        this.unsupported();
        return false;
    }

    @Override
    @Nonnull
    public RestAction<Void> pin() {
        this.unsupported();
        return null;
    }

    @Override
    @Nonnull
    public RestAction<Void> unpin() {
        this.unsupported();
        return null;
    }

    @Override
    @Nonnull
    public RestAction<Void> addReaction(@Nonnull Emoji emoji) {
        this.unsupported();
        return null;
    }

    @Override
    @Nonnull
    public RestAction<Void> clearReactions() {
        this.unsupported();
        return null;
    }

    @Override
    @Nonnull
    public RestAction<Void> clearReactions(@Nonnull Emoji emoji) {
        this.unsupported();
        return null;
    }

    @Override
    @Nonnull
    public RestAction<Void> removeReaction(@Nonnull Emoji emoji) {
        this.unsupported();
        return null;
    }

    @Override
    @Nonnull
    public RestAction<Void> removeReaction(@Nonnull Emoji emoji, @Nonnull User user) {
        this.unsupported();
        return null;
    }

    @Override
    @Nonnull
    public ReactionPaginationAction retrieveReactionUsers(@Nonnull Emoji emoji) {
        this.unsupported();
        return null;
    }

    @Override
    @Nullable
    public MessageReaction getReaction(@Nonnull Emoji emoji) {
        this.unsupported();
        return null;
    }

    @Override
    @Nonnull
    public AuditableRestAction<Void> suppressEmbeds(boolean suppressed) {
        this.unsupported();
        return null;
    }

    @Override
    @Nonnull
    public RestAction<Message> crosspost() {
        this.unsupported();
        return null;
    }

    @Override
    public boolean isSuppressedEmbeds() {
        this.unsupported();
        return false;
    }

    @Override
    @Nonnull
    public EnumSet<Message.MessageFlag> getFlags() {
        this.unsupported();
        return null;
    }

    @Override
    public long getFlagsRaw() {
        this.unsupported();
        return 0L;
    }

    @Override
    public boolean isEphemeral() {
        this.unsupported();
        return false;
    }

    @Override
    @Nullable
    public ThreadChannel getStartedThread() {
        this.unsupported();
        return null;
    }

    @Override
    @Nonnull
    public MessageType getType() {
        this.unsupported();
        return null;
    }

    @Override
    @Nullable
    public Message.Interaction getInteraction() {
        this.unsupported();
        return null;
    }

    @Override
    public ThreadChannelAction createThreadChannel(String name) {
        this.unsupported();
        return null;
    }
}

