/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.interactions.callbacks;

import java.util.Collection;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.interactions.callbacks.IDeferrableCallback;
import net.dv8tion.jda.api.requests.restaction.interactions.ReplyCallbackAction;
import net.dv8tion.jda.api.utils.FileUpload;
import net.dv8tion.jda.api.utils.messages.MessageCreateData;
import net.dv8tion.jda.internal.requests.restaction.interactions.ReplyCallbackActionImpl;
import net.dv8tion.jda.internal.utils.Checks;

public interface IReplyCallback
extends IDeferrableCallback {
    @Nonnull
    @CheckReturnValue
    public ReplyCallbackAction deferReply();

    @Nonnull
    @CheckReturnValue
    default public ReplyCallbackAction deferReply(boolean ephemeral) {
        return this.deferReply().setEphemeral(ephemeral);
    }

    @Nonnull
    @CheckReturnValue
    default public ReplyCallbackAction reply(@Nonnull MessageCreateData message) {
        Checks.notNull(message, "Message");
        ReplyCallbackActionImpl action = (ReplyCallbackActionImpl)this.deferReply();
        return (ReplyCallbackAction)action.applyData(message);
    }

    @Nonnull
    @CheckReturnValue
    default public ReplyCallbackAction reply(@Nonnull String content) {
        Checks.notNull(content, "Content");
        return (ReplyCallbackAction)this.deferReply().setContent(content);
    }

    @Nonnull
    @CheckReturnValue
    default public ReplyCallbackAction replyEmbeds(@Nonnull Collection<? extends MessageEmbed> embeds) {
        return (ReplyCallbackAction)this.deferReply().addEmbeds(embeds);
    }

    @Nonnull
    @CheckReturnValue
    default public ReplyCallbackAction replyEmbeds(@Nonnull MessageEmbed embed, MessageEmbed ... embeds) {
        Checks.notNull(embed, "MessageEmbed");
        Checks.noneNull(embeds, "MessageEmbed");
        return (ReplyCallbackAction)((ReplyCallbackAction)this.deferReply().addEmbeds(embed)).addEmbeds(embeds);
    }

    @Nonnull
    @CheckReturnValue
    default public ReplyCallbackAction replyFormat(@Nonnull String format, Object ... args2) {
        Checks.notNull(format, "Format String");
        return this.reply(String.format(format, args2));
    }

    @Nonnull
    @CheckReturnValue
    default public ReplyCallbackAction replyFiles(@Nonnull Collection<? extends FileUpload> files) {
        Checks.notEmpty(files, "File Collection");
        return (ReplyCallbackAction)this.deferReply().setFiles(files);
    }

    @Nonnull
    @CheckReturnValue
    default public ReplyCallbackAction replyFiles(FileUpload ... files) {
        Checks.notEmpty(files, "File Collection");
        Checks.noneNull(files, "FileUpload");
        return (ReplyCallbackAction)this.deferReply().setFiles(files);
    }
}

