/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.entities;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.interactions.components.LayoutComponent;
import net.dv8tion.jda.api.requests.RestAction;
import net.dv8tion.jda.api.requests.restaction.WebhookMessageCreateAction;
import net.dv8tion.jda.api.requests.restaction.WebhookMessageEditAction;
import net.dv8tion.jda.api.utils.AttachedFile;
import net.dv8tion.jda.api.utils.FileUpload;
import net.dv8tion.jda.api.utils.messages.MessageCreateData;
import net.dv8tion.jda.api.utils.messages.MessageEditData;
import net.dv8tion.jda.internal.utils.Checks;

public interface WebhookClient<T> {
    @Nonnull
    @CheckReturnValue
    public WebhookMessageCreateAction<T> sendMessage(@Nonnull String var1);

    @Nonnull
    @CheckReturnValue
    public WebhookMessageCreateAction<T> sendMessage(@Nonnull MessageCreateData var1);

    @Nonnull
    @CheckReturnValue
    default public WebhookMessageCreateAction<T> sendMessageFormat(@Nonnull String format, Object ... args) {
        Checks.notNull(format, "Format String");
        return this.sendMessage(String.format(format, args));
    }

    @Nonnull
    @CheckReturnValue
    public WebhookMessageCreateAction<T> sendMessageEmbeds(@Nonnull Collection<? extends MessageEmbed> var1);

    @Nonnull
    @CheckReturnValue
    default public WebhookMessageCreateAction<T> sendMessageEmbeds(@Nonnull MessageEmbed embed, MessageEmbed ... embeds) {
        Checks.notNull(embed, "MessageEmbeds");
        Checks.noneNull(embeds, "MessageEmbeds");
        ArrayList<MessageEmbed> embedList = new ArrayList<MessageEmbed>();
        embedList.add(embed);
        Collections.addAll(embedList, embeds);
        return this.sendMessageEmbeds(embedList);
    }

    @Nonnull
    @CheckReturnValue
    public WebhookMessageCreateAction<T> sendFiles(@Nonnull Collection<? extends FileUpload> var1);

    @Nonnull
    @CheckReturnValue
    default public WebhookMessageCreateAction<T> sendFiles(FileUpload ... files) {
        Checks.noneNull(files, "Files");
        Checks.notEmpty(files, "Files");
        return this.sendFiles(Arrays.asList(files));
    }

    @Nonnull
    @CheckReturnValue
    public WebhookMessageEditAction<T> editMessageById(@Nonnull String var1, @Nonnull String var2);

    @Nonnull
    @CheckReturnValue
    default public WebhookMessageEditAction<T> editMessageById(long messageId, @Nonnull String content) {
        return this.editMessageById(Long.toUnsignedString(messageId), content);
    }

    @Nonnull
    @CheckReturnValue
    public WebhookMessageEditAction<T> editMessageById(@Nonnull String var1, @Nonnull MessageEditData var2);

    @Nonnull
    @CheckReturnValue
    default public WebhookMessageEditAction<T> editMessageById(long messageId, MessageEditData message) {
        return this.editMessageById(Long.toUnsignedString(messageId), message);
    }

    @Nonnull
    @CheckReturnValue
    default public WebhookMessageEditAction<T> editMessageFormatById(@Nonnull String messageId, @Nonnull String format, Object ... args) {
        Checks.notNull(format, "Format String");
        return this.editMessageById(messageId, String.format(format, args));
    }

    @Nonnull
    @CheckReturnValue
    default public WebhookMessageEditAction<T> editMessageFormatById(long messageId, @Nonnull String format, Object ... args) {
        return this.editMessageFormatById(Long.toUnsignedString(messageId), format, args);
    }

    @Nonnull
    @CheckReturnValue
    public WebhookMessageEditAction<T> editMessageEmbedsById(@Nonnull String var1, @Nonnull Collection<? extends MessageEmbed> var2);

    @Nonnull
    @CheckReturnValue
    default public WebhookMessageEditAction<T> editMessageEmbedsById(long messageId, @Nonnull Collection<? extends MessageEmbed> embeds) {
        return this.editMessageEmbedsById(Long.toUnsignedString(messageId), embeds);
    }

    @Nonnull
    @CheckReturnValue
    default public WebhookMessageEditAction<T> editMessageEmbedsById(@Nonnull String messageId, MessageEmbed ... embeds) {
        Checks.noneNull(embeds, "MessageEmbeds");
        return this.editMessageEmbedsById(messageId, Arrays.asList(embeds));
    }

    @Nonnull
    @CheckReturnValue
    default public WebhookMessageEditAction<T> editMessageEmbedsById(long messageId, MessageEmbed ... embeds) {
        return this.editMessageEmbedsById(Long.toUnsignedString(messageId), embeds);
    }

    @Nonnull
    @CheckReturnValue
    public WebhookMessageEditAction<T> editMessageComponentsById(@Nonnull String var1, @Nonnull Collection<? extends LayoutComponent> var2);

    @Nonnull
    @CheckReturnValue
    default public WebhookMessageEditAction<T> editMessageComponentsById(long messageId, @Nonnull Collection<? extends LayoutComponent> components) {
        return this.editMessageComponentsById(Long.toUnsignedString(messageId), components);
    }

    @Nonnull
    @CheckReturnValue
    default public WebhookMessageEditAction<T> editMessageComponentsById(@Nonnull String messageId, LayoutComponent ... components) {
        Checks.noneNull(components, "LayoutComponents");
        return this.editMessageComponentsById(messageId, Arrays.asList(components));
    }

    @Nonnull
    @CheckReturnValue
    default public WebhookMessageEditAction<T> editMessageComponentsById(long messageId, LayoutComponent ... components) {
        return this.editMessageComponentsById(Long.toUnsignedString(messageId), components);
    }

    @Nonnull
    @CheckReturnValue
    public WebhookMessageEditAction<T> editMessageAttachmentsById(@Nonnull String var1, @Nonnull Collection<? extends AttachedFile> var2);

    @Nonnull
    @CheckReturnValue
    default public WebhookMessageEditAction<T> editMessageAttachmentsById(@Nonnull String messageId, AttachedFile ... attachments) {
        Checks.noneNull(attachments, "Attachments");
        return this.editMessageAttachmentsById(messageId, Arrays.asList(attachments));
    }

    @Nonnull
    @CheckReturnValue
    default public WebhookMessageEditAction<T> editMessageAttachmentsById(long messageId, @Nonnull Collection<? extends AttachedFile> attachments) {
        return this.editMessageAttachmentsById(Long.toUnsignedString(messageId), attachments);
    }

    @Nonnull
    @CheckReturnValue
    default public WebhookMessageEditAction<T> editMessageAttachmentsById(long messageId, AttachedFile ... attachments) {
        return this.editMessageAttachmentsById(Long.toUnsignedString(messageId), attachments);
    }

    @Nonnull
    @CheckReturnValue
    public RestAction<Void> deleteMessageById(@Nonnull String var1);

    @Nonnull
    @CheckReturnValue
    default public RestAction<Void> deleteMessageById(long messageId) {
        return this.deleteMessageById(Long.toUnsignedString(messageId));
    }
}

