/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.utils;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;

public class BufferedRequestBody
extends RequestBody {
    private final Source source;
    private final MediaType type;
    private byte[] data;

    public BufferedRequestBody(Source source, MediaType type) {
        this.source = source;
        this.type = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public BufferedRequestBody withType(@Nonnull MediaType type) {
        if (type.equals((Object)this.type)) {
            return this;
        }
        Source source = this.source;
        synchronized (source) {
            BufferedRequestBody copy = new BufferedRequestBody(this.source, type);
            copy.data = this.data;
            return copy;
        }
    }

    @Nullable
    public MediaType contentType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(@Nonnull BufferedSink sink) throws IOException {
        Source source = this.source;
        synchronized (source) {
            if (this.data != null) {
                sink.write(this.data);
                return;
            }
            try (BufferedSource s = Okio.buffer((Source)this.source);){
                this.data = s.readByteArray();
                sink.write(this.data);
            }
        }
    }
}

