/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.entities.mixin.channel.attribute;

import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.ChannelType;
import net.dv8tion.jda.api.entities.GuildChannel;
import net.dv8tion.jda.api.entities.IThreadContainer;
import net.dv8tion.jda.api.entities.channel.unions.IThreadContainerUnion;
import net.dv8tion.jda.api.requests.restaction.ThreadChannelAction;
import net.dv8tion.jda.api.requests.restaction.pagination.ThreadChannelPaginationAction;
import net.dv8tion.jda.internal.entities.mixin.channel.middleman.GuildChannelMixin;
import net.dv8tion.jda.internal.requests.Route;
import net.dv8tion.jda.internal.requests.restaction.ThreadChannelActionImpl;
import net.dv8tion.jda.internal.requests.restaction.pagination.ThreadChannelPaginationActionImpl;

public interface IThreadContainerMixin<T extends IThreadContainerMixin<T>>
extends IThreadContainer,
IThreadContainerUnion,
GuildChannelMixin<T> {
    @Override
    @Nonnull
    @CheckReturnValue
    default public ThreadChannelAction createThreadChannel(String name, boolean isPrivate) {
        this.checkPermission(Permission.VIEW_CHANNEL);
        if (isPrivate) {
            if (!this.getGuild().getFeatures().contains("PRIVATE_THREADS")) {
                throw new IllegalStateException("Can only use private threads in Guilds with the PRIVATE_THREADS feature");
            }
            this.checkPermission(Permission.CREATE_PRIVATE_THREADS);
        } else {
            this.checkPermission(Permission.CREATE_PUBLIC_THREADS);
        }
        ChannelType threadType = isPrivate ? ChannelType.GUILD_PRIVATE_THREAD : (this.getType() == ChannelType.TEXT ? ChannelType.GUILD_PUBLIC_THREAD : ChannelType.GUILD_NEWS_THREAD);
        return new ThreadChannelActionImpl((GuildChannel)this, name, threadType);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    default public ThreadChannelAction createThreadChannel(String name, long messageId) {
        this.checkPermission(Permission.VIEW_CHANNEL);
        this.checkPermission(Permission.CREATE_PUBLIC_THREADS);
        return new ThreadChannelActionImpl((GuildChannel)this, name, Long.toUnsignedString(messageId));
    }

    @Override
    @Nonnull
    @CheckReturnValue
    default public ThreadChannelPaginationAction retrieveArchivedPublicThreadChannels() {
        this.checkPermission(Permission.MESSAGE_HISTORY);
        Route.CompiledRoute route = Route.Channels.LIST_PUBLIC_ARCHIVED_THREADS.compile(this.getId());
        return new ThreadChannelPaginationActionImpl(this.getJDA(), route, this, false);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    default public ThreadChannelPaginationAction retrieveArchivedPrivateThreadChannels() {
        this.checkPermission(Permission.MESSAGE_HISTORY);
        this.checkPermission(Permission.MANAGE_THREADS);
        Route.CompiledRoute route = Route.Channels.LIST_PRIVATE_ARCHIVED_THREADS.compile(this.getId());
        return new ThreadChannelPaginationActionImpl(this.getJDA(), route, this, false);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    default public ThreadChannelPaginationAction retrieveArchivedPrivateJoinedThreadChannels() {
        this.checkPermission(Permission.MESSAGE_HISTORY);
        Route.CompiledRoute route = Route.Channels.LIST_JOINED_PRIVATE_ARCHIVED_THREADS.compile(this.getId());
        return new ThreadChannelPaginationActionImpl(this.getJDA(), route, this, true);
    }
}

