/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.requests.restaction.interactions;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.dv8tion.jda.api.requests.Request;
import net.dv8tion.jda.api.requests.Response;
import net.dv8tion.jda.api.requests.RestAction;
import net.dv8tion.jda.api.requests.restaction.interactions.InteractionCallbackAction;
import net.dv8tion.jda.api.utils.AttachedFile;
import net.dv8tion.jda.api.utils.FileUpload;
import net.dv8tion.jda.api.utils.data.DataArray;
import net.dv8tion.jda.api.utils.data.DataObject;
import net.dv8tion.jda.internal.interactions.InteractionImpl;
import net.dv8tion.jda.internal.requests.RestActionImpl;
import net.dv8tion.jda.internal.requests.Route;
import net.dv8tion.jda.internal.utils.IOUtil;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;

public abstract class InteractionCallbackImpl<T>
extends RestActionImpl<T>
implements InteractionCallbackAction<T> {
    protected final List<AttachedFile> files = new ArrayList<AttachedFile>();
    protected final InteractionImpl interaction;
    protected boolean isFileUpdate = false;

    public InteractionCallbackImpl(InteractionImpl interaction) {
        super(interaction.getJDA(), Route.Interactions.CALLBACK.compile(interaction.getId(), interaction.getToken()));
        this.interaction = interaction;
    }

    protected abstract DataObject toData();

    @Override
    protected RequestBody finalizeData() {
        RequestBody body;
        DataObject json = this.toData();
        if (this.isFileUpdate || !this.files.isEmpty()) {
            DataArray attachments;
            DataObject data;
            if (json.isNull("data")) {
                data = DataObject.empty();
                json.put("data", data);
            } else {
                data = json.getObject("data");
            }
            if (data.isNull("attachments")) {
                attachments = DataArray.empty();
                data.put("attachments", attachments);
            } else {
                attachments = data.getArray("attachments");
            }
            for (int i = 0; i < this.files.size(); ++i) {
                attachments.add(this.files.get(i).toAttachmentData(i));
            }
        }
        if (this.files.stream().anyMatch(FileUpload.class::isInstance)) {
            MultipartBody.Builder form = AttachedFile.createMultipartBody(this.files, null);
            form.addFormDataPart("payload_json", json.toString());
            body = form.build();
        } else {
            body = this.getRequestBody(json);
        }
        this.isFileUpdate = false;
        this.files.clear();
        return body;
    }

    @Override
    @Nonnull
    public InteractionCallbackAction<T> closeResources() {
        this.files.forEach(IOUtil::silentClose);
        this.files.clear();
        return this;
    }

    protected void finalize() {
        if (this.files.stream().noneMatch(FileUpload.class::isInstance)) {
            return;
        }
        LOG.warn("Found open resources in interaction callback. Did you forget to close them?");
        this.closeResources();
    }

    protected final IllegalStateException tryAck() {
        return this.interaction.ack() ? new IllegalStateException("This interaction has already been acknowledged or replied to. You can only reply or acknowledge an interaction once!") : null;
    }

    @Override
    public final void queue(Consumer<? super T> success, Consumer<? super Throwable> failure) {
        IllegalStateException exception = this.tryAck();
        if (exception != null) {
            if (failure != null) {
                failure.accept(exception);
            } else {
                RestAction.getDefaultFailure().accept(exception);
            }
            return;
        }
        super.queue(success, failure);
    }

    @Override
    @Nonnull
    public final CompletableFuture<T> submit(boolean shouldQueue) {
        IllegalStateException exception = this.tryAck();
        if (exception != null) {
            CompletableFuture future = new CompletableFuture();
            future.completeExceptionally(exception);
            return future;
        }
        return super.submit(shouldQueue);
    }

    @Override
    protected void handleSuccess(Response response, Request<T> request) {
        this.interaction.releaseHook(true);
        super.handleSuccess(response, request);
    }

    @Override
    public void handleResponse(Response response, Request<T> request) {
        if (!response.isOk()) {
            this.interaction.releaseHook(false);
        }
        super.handleResponse(response, request);
    }
}

