/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.dv8tion.jda.api.exceptions.HttpException;
import net.dv8tion.jda.internal.requests.FunctionalCallback;
import net.dv8tion.jda.internal.requests.Requester;
import net.dv8tion.jda.internal.utils.Checks;
import net.dv8tion.jda.internal.utils.FutureUtil;
import net.dv8tion.jda.internal.utils.IOUtil;
import okhttp3.Call;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;

public class FileProxy {
    private static volatile OkHttpClient defaultHttpClient;
    private final String url;
    private OkHttpClient customHttpClient;

    public FileProxy(@Nonnull String url) {
        Checks.notNull(url, "URL");
        this.url = url;
    }

    public static void setDefaultHttpClient(@Nonnull OkHttpClient httpClient) {
        Checks.notNull(httpClient, "Default OkHttpClient");
        defaultHttpClient = httpClient;
    }

    @Nonnull
    public String getUrl() {
        return this.url;
    }

    @Nonnull
    public FileProxy withClient(@Nonnull OkHttpClient customHttpClient) {
        Checks.notNull(customHttpClient, "Custom HTTP client");
        this.customHttpClient = customHttpClient;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OkHttpClient getHttpClient() {
        if (this.customHttpClient != null) {
            return this.customHttpClient;
        }
        if (defaultHttpClient == null) {
            FileProxy fileProxy = this;
            synchronized (fileProxy) {
                if (defaultHttpClient == null) {
                    defaultHttpClient = new OkHttpClient();
                }
            }
        }
        return defaultHttpClient;
    }

    protected Request getRequest(String url) {
        return new Request.Builder().url(url).addHeader("user-agent", Requester.USER_AGENT).addHeader("accept-encoding", "gzip, deflate").build();
    }

    protected CompletableFuture<InputStream> download(String url) {
        DownloadTask downloadTask = this.downloadInternal(url);
        return FutureUtil.thenApplyCancellable(downloadTask.getFuture(), Function.identity(), downloadTask::cancelCall);
    }

    private DownloadTask downloadInternal(String url) {
        CompletableFuture<InputStream> future = new CompletableFuture<InputStream>();
        Request req = this.getRequest(url);
        OkHttpClient httpClient = this.getHttpClient();
        Call newCall = httpClient.newCall(req);
        newCall.enqueue(FunctionalCallback.onFailure((call, e) -> future.completeExceptionally(new UncheckedIOException((IOException)e))).onSuccess((call, response) -> {
            if (response.isSuccessful()) {
                InputStream body = IOUtil.getBody(response);
                if (!future.complete(body)) {
                    IOUtil.silentClose(response);
                }
            } else {
                future.completeExceptionally(new HttpException(response.code() + ": " + response.message()));
                IOUtil.silentClose(response);
            }
        }).build());
        return new DownloadTask(newCall, future);
    }

    protected CompletableFuture<Path> downloadToPath(String url) {
        HttpUrl parsedUrl = HttpUrl.parse(url);
        Checks.check(parsedUrl != null, "URL '" + url + "' is not valid");
        List<String> segments = parsedUrl.pathSegments();
        String fileName = segments.get(segments.size() - 1);
        return this.downloadToPath(Paths.get(fileName, new String[0]));
    }

    protected CompletableFuture<Path> downloadToPath(String url, Path path) {
        Checks.check(Files.exists(path.getParent(), new LinkOption[0]), "Parent folder of the file '" + path.toAbsolutePath() + "' does not exist.");
        DownloadTask downloadTask = this.downloadInternal(url);
        return FutureUtil.thenApplyCancellable(downloadTask.getFuture(), stream -> {
            try {
                Path tmpPath = Files.createTempFile(path.getFileName().toString(), ".part", new FileAttribute[0]);
                Files.copy(stream, tmpPath, StandardCopyOption.REPLACE_EXISTING);
                Files.move(tmpPath, path, StandardCopyOption.REPLACE_EXISTING);
                Path path2 = path;
                return path2;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            finally {
                IOUtil.silentClose(stream);
            }
        }, downloadTask::cancelCall);
    }

    @Nonnull
    public CompletableFuture<InputStream> download() {
        return this.download(this.url);
    }

    @Nonnull
    public CompletableFuture<Path> downloadToPath() {
        return this.downloadToPath(this.url);
    }

    @Nonnull
    public CompletableFuture<File> downloadToFile(@Nonnull File file) {
        Checks.notNull(file, "File");
        CompletableFuture<Path> downloadToPathFuture = this.downloadToPath(this.url, file.toPath());
        return FutureUtil.thenApplyCancellable(downloadToPathFuture, Path::toFile);
    }

    @Nonnull
    public CompletableFuture<Path> downloadToPath(@Nonnull Path path) {
        Checks.notNull(path, "Path");
        return this.downloadToPath(this.url, path);
    }

    protected static class DownloadTask {
        private final Call call;
        private final CompletableFuture<InputStream> future;

        public DownloadTask(Call call, CompletableFuture<InputStream> future) {
            this.call = call;
            this.future = future;
        }

        protected void cancelCall() {
            this.call.cancel();
        }

        protected CompletableFuture<InputStream> getFuture() {
            return this.future;
        }
    }
}

