/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.entities;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import net.dv8tion.jda.api.entities.GuildChannel;
import net.dv8tion.jda.api.entities.IPermissionContainer;
import net.dv8tion.jda.api.entities.ThreadChannel;
import net.dv8tion.jda.api.requests.restaction.ThreadChannelAction;
import net.dv8tion.jda.api.requests.restaction.pagination.ThreadChannelPaginationAction;
import net.dv8tion.jda.api.utils.MiscUtil;

public interface IThreadContainer
extends GuildChannel,
IPermissionContainer {
    default public List<ThreadChannel> getThreadChannels() {
        return this.getGuild().getThreadChannels().stream().filter(thread -> thread.getParentChannel() == this).collect(Collectors.toList());
    }

    @Nonnull
    @CheckReturnValue
    default public ThreadChannelAction createThreadChannel(String name) {
        return this.createThreadChannel(name, false);
    }

    @Nonnull
    @CheckReturnValue
    public ThreadChannelAction createThreadChannel(String var1, boolean var2);

    @Nonnull
    @CheckReturnValue
    public ThreadChannelAction createThreadChannel(String var1, long var2);

    @Nonnull
    @CheckReturnValue
    default public ThreadChannelAction createThreadChannel(String name, String messageId) {
        return this.createThreadChannel(name, MiscUtil.parseSnowflake(messageId));
    }

    @Nonnull
    @CheckReturnValue
    public ThreadChannelPaginationAction retrieveArchivedPublicThreadChannels();

    @Nonnull
    @CheckReturnValue
    public ThreadChannelPaginationAction retrieveArchivedPrivateThreadChannels();

    @Nonnull
    @CheckReturnValue
    public ThreadChannelPaginationAction retrieveArchivedPrivateJoinedThreadChannels();
}

