/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.interactions;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.interactions.components.Component;
import net.dv8tion.jda.api.interactions.components.selections.SelectionMenu;
import net.dv8tion.jda.api.interactions.components.selections.SelectionMenuInteraction;
import net.dv8tion.jda.api.utils.data.DataArray;
import net.dv8tion.jda.api.utils.data.DataObject;
import net.dv8tion.jda.internal.JDAImpl;
import net.dv8tion.jda.internal.interactions.ComponentInteractionImpl;

public class SelectionMenuInteractionImpl
extends ComponentInteractionImpl
implements SelectionMenuInteraction {
    private final List<String> values;
    private final SelectionMenu menu;

    public SelectionMenuInteractionImpl(JDAImpl jda, DataObject data) {
        super(jda, data);
        this.values = Collections.unmodifiableList(data.getObject("data").getArray("values").stream(DataArray::getString).collect(Collectors.toList()));
        this.menu = this.message != null ? (SelectionMenu)this.message.getActionRows().stream().flatMap(row -> row.getComponents().stream()).filter(c -> c.getType() == Component.Type.SELECTION_MENU && this.customId.equals(c.getId())).findFirst().orElse(null) : null;
    }

    @Override
    @Nullable
    public SelectionMenu getComponent() {
        return this.menu;
    }

    @Override
    @Nonnull
    public Component.Type getComponentType() {
        return Component.Type.SELECTION_MENU;
    }

    @Override
    @Nonnull
    public List<String> getValues() {
        return this.values;
    }
}

