/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.entities;

import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.Category;
import net.dv8tion.jda.api.entities.ChannelType;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.GuildChannel;
import net.dv8tion.jda.api.entities.ICategorizableChannel;
import net.dv8tion.jda.api.entities.IThreadContainer;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Mentions;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageActivity;
import net.dv8tion.jda.api.entities.MessageChannel;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.MessageReaction;
import net.dv8tion.jda.api.entities.MessageReference;
import net.dv8tion.jda.api.entities.MessageType;
import net.dv8tion.jda.api.entities.NewsChannel;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.ThreadChannel;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.channel.unions.GuildMessageChannelUnion;
import net.dv8tion.jda.api.entities.channel.unions.MessageChannelUnion;
import net.dv8tion.jda.api.entities.emoji.CustomEmoji;
import net.dv8tion.jda.api.entities.emoji.Emoji;
import net.dv8tion.jda.api.entities.emoji.RichCustomEmoji;
import net.dv8tion.jda.api.entities.sticker.StickerItem;
import net.dv8tion.jda.api.exceptions.InsufficientPermissionException;
import net.dv8tion.jda.api.exceptions.MissingAccessException;
import net.dv8tion.jda.api.exceptions.PermissionException;
import net.dv8tion.jda.api.interactions.InteractionHook;
import net.dv8tion.jda.api.interactions.components.ActionRow;
import net.dv8tion.jda.api.interactions.components.LayoutComponent;
import net.dv8tion.jda.api.requests.RestAction;
import net.dv8tion.jda.api.requests.restaction.AuditableRestAction;
import net.dv8tion.jda.api.requests.restaction.MessageAction;
import net.dv8tion.jda.api.requests.restaction.pagination.ReactionPaginationAction;
import net.dv8tion.jda.api.utils.MarkdownSanitizer;
import net.dv8tion.jda.api.utils.data.DataObject;
import net.dv8tion.jda.internal.JDAImpl;
import net.dv8tion.jda.internal.entities.AbstractMessage;
import net.dv8tion.jda.internal.requests.CompletedRestAction;
import net.dv8tion.jda.internal.requests.Route;
import net.dv8tion.jda.internal.requests.restaction.AuditableRestActionImpl;
import net.dv8tion.jda.internal.requests.restaction.MessageActionImpl;
import net.dv8tion.jda.internal.utils.Checks;
import net.dv8tion.jda.internal.utils.Helpers;

public class ReceivedMessage
extends AbstractMessage {
    private final Object mutex = new Object();
    protected final JDAImpl api;
    protected final long id;
    protected final MessageType type;
    protected final MessageChannel channel;
    protected final MessageReference messageReference;
    protected final boolean fromWebhook;
    protected final boolean pinned;
    protected final User author;
    protected final Member member;
    protected final MessageActivity activity;
    protected final OffsetDateTime editedTime;
    protected final Mentions mentions;
    protected final List<MessageReaction> reactions;
    protected final List<Message.Attachment> attachments;
    protected final List<MessageEmbed> embeds;
    protected final List<StickerItem> stickers;
    protected final List<ActionRow> components;
    protected final int flags;
    protected final Message.Interaction interaction;
    protected final ThreadChannel startedThread;
    protected InteractionHook interactionHook = null;
    protected String altContent = null;
    protected String strippedContent = null;
    protected List<String> invites = null;

    public ReceivedMessage(long id, MessageChannel channel, MessageType type, MessageReference messageReference, boolean fromWebhook, boolean tts, boolean pinned, String content, String nonce, User author, Member member, MessageActivity activity, OffsetDateTime editTime, Mentions mentions, List<MessageReaction> reactions, List<Message.Attachment> attachments, List<MessageEmbed> embeds, List<StickerItem> stickers, List<ActionRow> components, int flags, Message.Interaction interaction, ThreadChannel startedThread) {
        super(content, nonce, tts);
        this.id = id;
        this.channel = channel;
        this.messageReference = messageReference;
        this.type = type;
        this.api = channel != null ? (JDAImpl)channel.getJDA() : null;
        this.fromWebhook = fromWebhook;
        this.pinned = pinned;
        this.author = author;
        this.member = member;
        this.activity = activity;
        this.editedTime = editTime;
        this.mentions = mentions;
        this.reactions = Collections.unmodifiableList(reactions);
        this.attachments = Collections.unmodifiableList(attachments);
        this.embeds = Collections.unmodifiableList(embeds);
        this.stickers = Collections.unmodifiableList(stickers);
        this.components = Collections.unmodifiableList(components);
        this.flags = flags;
        this.interaction = interaction;
        this.startedThread = startedThread;
    }

    public ReceivedMessage withHook(InteractionHook hook) {
        this.interactionHook = hook;
        return this;
    }

    @Override
    @Nonnull
    public JDA getJDA() {
        return this.api;
    }

    @Override
    @Nullable
    public MessageReference getMessageReference() {
        return this.messageReference;
    }

    @Override
    public boolean isPinned() {
        return this.pinned;
    }

    @Override
    @Nonnull
    public RestAction<Void> pin() {
        if (this.isEphemeral()) {
            throw new IllegalStateException("Cannot pin ephemeral messages.");
        }
        return this.channel.pinMessageById(this.getId());
    }

    @Override
    @Nonnull
    public RestAction<Void> unpin() {
        if (this.isEphemeral()) {
            throw new IllegalStateException("Cannot unpin ephemeral messages.");
        }
        return this.channel.unpinMessageById(this.getId());
    }

    @Override
    @Nonnull
    public RestAction<Void> addReaction(@Nonnull Emoji emoji) {
        if (this.isEphemeral()) {
            throw new IllegalStateException("Cannot add reactions to ephemeral messages.");
        }
        Checks.notNull(emoji, "Emoji");
        boolean missingReaction = this.reactions.stream().map(MessageReaction::getEmoji).noneMatch(r -> r.getAsReactionCode().equals(emoji.getAsReactionCode()));
        if (missingReaction && emoji instanceof RichCustomEmoji) {
            Checks.check(((RichCustomEmoji)emoji).canInteract(this.getJDA().getSelfUser(), this.channel), "Cannot react with the provided emoji because it is not available in the current channel.");
        }
        return this.channel.addReactionById(this.getId(), emoji);
    }

    @Override
    @Nonnull
    public RestAction<Void> clearReactions() {
        if (this.isEphemeral()) {
            throw new IllegalStateException("Cannot clear reactions from ephemeral messages.");
        }
        if (!this.isFromGuild()) {
            throw new IllegalStateException("Cannot clear reactions from a message in a Group or PrivateChannel.");
        }
        return this.getGuildChannel().clearReactionsById(this.getId());
    }

    @Override
    @Nonnull
    public RestAction<Void> clearReactions(@Nonnull Emoji emoji) {
        if (this.isEphemeral()) {
            throw new IllegalStateException("Cannot clear reactions from ephemeral messages.");
        }
        if (!this.isFromGuild()) {
            throw new IllegalStateException("Cannot clear reactions from a message in a Group or PrivateChannel.");
        }
        return this.getGuildChannel().clearReactionsById(this.getId(), emoji);
    }

    @Override
    @Nonnull
    public RestAction<Void> removeReaction(@Nonnull Emoji emoji) {
        if (this.isEphemeral()) {
            throw new IllegalStateException("Cannot remove reactions from ephemeral messages.");
        }
        return this.channel.removeReactionById(this.getId(), emoji);
    }

    @Override
    @Nonnull
    public RestAction<Void> removeReaction(@Nonnull Emoji emoji, @Nonnull User user) {
        Checks.notNull(user, "User");
        if (this.isEphemeral()) {
            throw new IllegalStateException("Cannot remove reactions from ephemeral messages.");
        }
        if (user.equals(this.getJDA().getSelfUser())) {
            return this.channel.removeReactionById(this.getIdLong(), emoji);
        }
        if (!this.isFromGuild()) {
            throw new IllegalStateException("Cannot remove reactions of others from a message in a Group or PrivateChannel.");
        }
        return this.getGuildChannel().removeReactionById(this.getIdLong(), emoji, user);
    }

    @Override
    @Nonnull
    public ReactionPaginationAction retrieveReactionUsers(@Nonnull Emoji emoji) {
        if (this.isEphemeral()) {
            throw new IllegalStateException("Cannot retrieve reactions on ephemeral messages.");
        }
        return this.channel.retrieveReactionUsersById(this.id, emoji);
    }

    @Override
    @Nullable
    public MessageReaction getReaction(@Nonnull Emoji emoji) {
        Checks.notNull(emoji, "Emoji");
        String code = emoji.getAsReactionCode();
        return this.reactions.stream().filter(r -> code.equals(r.getEmoji().getAsReactionCode())).findFirst().orElse(null);
    }

    @Override
    @Nonnull
    public MessageType getType() {
        return this.type;
    }

    @Override
    @Nullable
    public Message.Interaction getInteraction() {
        return this.interaction;
    }

    @Override
    public long getIdLong() {
        return this.id;
    }

    @Override
    @Nonnull
    public String getJumpUrl() {
        return Helpers.format("https://discord.com/channels/%s/%s/%s", this.isFromGuild() ? this.getGuild().getId() : "@me", this.getChannel().getId(), this.getId());
    }

    @Override
    public boolean isEdited() {
        return this.editedTime != null;
    }

    @Override
    public OffsetDateTime getTimeEdited() {
        return this.editedTime;
    }

    @Override
    @Nonnull
    public User getAuthor() {
        return this.author;
    }

    @Override
    public Member getMember() {
        return this.member;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public String getContentStripped() {
        if (this.strippedContent != null) {
            return this.strippedContent;
        }
        Object object = this.mutex;
        synchronized (object) {
            if (this.strippedContent != null) {
                return this.strippedContent;
            }
            this.strippedContent = MarkdownSanitizer.sanitize(this.getContentDisplay());
            return this.strippedContent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public String getContentDisplay() {
        if (this.altContent != null) {
            return this.altContent;
        }
        Object object = this.mutex;
        synchronized (object) {
            if (this.altContent != null) {
                return this.altContent;
            }
            String tmp = this.content;
            for (User user : this.mentions.getUsers()) {
                String name = this.isFromGuild() && this.getGuild().isMember(user) ? this.getGuild().getMember(user).getEffectiveName() : user.getName();
                tmp = tmp.replaceAll("<@!?" + Pattern.quote(user.getId()) + '>', '@' + Matcher.quoteReplacement(name));
            }
            for (CustomEmoji emoji : this.mentions.getCustomEmojis()) {
                tmp = tmp.replace(emoji.getAsMention(), ":" + emoji.getName() + ":");
            }
            for (GuildChannel mentionedChannel : this.mentions.getChannels()) {
                tmp = tmp.replace(mentionedChannel.getAsMention(), '#' + mentionedChannel.getName());
            }
            for (Role mentionedRole : this.mentions.getRoles()) {
                tmp = tmp.replace(mentionedRole.getAsMention(), '@' + mentionedRole.getName());
            }
            this.altContent = tmp;
            return this.altContent;
        }
    }

    @Override
    @Nonnull
    public String getContentRaw() {
        return this.content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public List<String> getInvites() {
        if (this.invites != null) {
            return this.invites;
        }
        Object object = this.mutex;
        synchronized (object) {
            if (this.invites != null) {
                return this.invites;
            }
            this.invites = new ArrayList<String>();
            Matcher m = INVITE_PATTERN.matcher(this.getContentRaw());
            while (m.find()) {
                this.invites.add(m.group(1));
            }
            this.invites = Collections.unmodifiableList(this.invites);
            return this.invites;
        }
    }

    @Override
    public String getNonce() {
        return this.nonce;
    }

    @Override
    public boolean isFromType(@Nonnull ChannelType type) {
        return this.getChannelType() == type;
    }

    @Override
    @Nonnull
    public ChannelType getChannelType() {
        return this.channel.getType();
    }

    @Override
    @Nonnull
    public MessageChannelUnion getChannel() {
        return (MessageChannelUnion)this.channel;
    }

    @Override
    @Nonnull
    public GuildMessageChannelUnion getGuildChannel() {
        if (!this.isFromGuild()) {
            throw new IllegalStateException("This message was not sent in a guild.");
        }
        return (GuildMessageChannelUnion)this.channel;
    }

    @Override
    public Category getCategory() {
        GuildMessageChannelUnion chan = this.getGuildChannel();
        return chan instanceof ICategorizableChannel ? ((ICategorizableChannel)((Object)chan)).getParentCategory() : null;
    }

    @Override
    @Nonnull
    public Guild getGuild() {
        return this.getGuildChannel().getGuild();
    }

    @Override
    @Nonnull
    public List<Message.Attachment> getAttachments() {
        return this.attachments;
    }

    @Override
    @Nonnull
    public List<MessageEmbed> getEmbeds() {
        return this.embeds;
    }

    @Override
    @Nonnull
    public List<ActionRow> getActionRows() {
        return this.components;
    }

    @Override
    @Nonnull
    public Mentions getMentions() {
        return this.mentions;
    }

    @Override
    @Nonnull
    public List<MessageReaction> getReactions() {
        return this.reactions;
    }

    @Override
    @Nonnull
    public List<StickerItem> getStickers() {
        return this.stickers;
    }

    @Override
    public boolean isWebhookMessage() {
        return this.fromWebhook;
    }

    @Override
    public boolean isTTS() {
        return this.isTTS;
    }

    @Override
    @Nullable
    public MessageActivity getActivity() {
        return this.activity;
    }

    @Override
    @Nonnull
    public MessageAction editMessage(@Nonnull CharSequence newContent) {
        this.checkUser();
        return ((MessageActionImpl)this.channel.editMessageById(this.getId(), newContent)).withHook(this.interactionHook);
    }

    @Override
    @Nonnull
    public MessageAction editMessageEmbeds(@Nonnull Collection<? extends MessageEmbed> embeds) {
        this.checkUser();
        return ((MessageActionImpl)this.channel.editMessageEmbedsById(this.getId(), embeds)).withHook(this.interactionHook);
    }

    @Override
    @Nonnull
    public MessageAction editMessageComponents(@Nonnull Collection<? extends LayoutComponent> components) {
        this.checkUser();
        return ((MessageActionImpl)this.channel.editMessageComponentsById(this.getId(), components)).withHook(this.interactionHook);
    }

    @Override
    @Nonnull
    public MessageAction editMessageFormat(@Nonnull String format, Object ... args2) {
        this.checkUser();
        return ((MessageActionImpl)this.channel.editMessageFormatById(this.getId(), format, args2)).withHook(this.interactionHook);
    }

    @Override
    @Nonnull
    public MessageAction editMessage(@Nonnull Message newContent) {
        this.checkUser();
        return ((MessageActionImpl)this.channel.editMessageById(this.getId(), newContent)).withHook(this.interactionHook);
    }

    private void checkUser() {
        if (!this.getJDA().getSelfUser().equals(this.getAuthor())) {
            throw new IllegalStateException("Attempted to update message that was not sent by this account. You cannot modify other User's messages!");
        }
    }

    @Override
    @Nonnull
    public AuditableRestAction<Void> delete() {
        if (this.isEphemeral()) {
            throw new IllegalStateException("Cannot delete ephemeral messages.");
        }
        if (!this.getJDA().getSelfUser().equals(this.getAuthor())) {
            if (this.isFromType(ChannelType.PRIVATE)) {
                throw new IllegalStateException("Cannot delete another User's messages in a PrivateChannel.");
            }
            GuildMessageChannelUnion gChan = this.getGuildChannel();
            Member sMember = this.getGuild().getSelfMember();
            if (!sMember.hasAccess(gChan)) {
                throw new MissingAccessException(gChan, Permission.VIEW_CHANNEL);
            }
            if (!sMember.hasPermission((GuildChannel)gChan, Permission.MESSAGE_MANAGE)) {
                throw new InsufficientPermissionException(gChan, Permission.MESSAGE_MANAGE);
            }
        }
        if (!this.type.canDelete()) {
            throw new IllegalStateException("Cannot delete messages of type " + (Object)((Object)this.type));
        }
        return this.channel.deleteMessageById(this.getIdLong());
    }

    @Override
    @Nonnull
    public AuditableRestAction<Void> suppressEmbeds(boolean suppressed) {
        if (this.isEphemeral()) {
            throw new IllegalStateException("Cannot suppress embeds on ephemeral messages.");
        }
        if (!this.getJDA().getSelfUser().equals(this.getAuthor())) {
            if (this.isFromType(ChannelType.PRIVATE)) {
                throw new PermissionException("Cannot suppress embeds of others in a PrivateChannel.");
            }
            GuildMessageChannelUnion gChan = this.getGuildChannel();
            if (!this.getGuild().getSelfMember().hasPermission((GuildChannel)gChan, Permission.MESSAGE_MANAGE)) {
                throw new InsufficientPermissionException(gChan, Permission.MESSAGE_MANAGE);
            }
        }
        JDAImpl jda = (JDAImpl)this.getJDA();
        Route.CompiledRoute route = Route.Messages.EDIT_MESSAGE.compile(this.getChannel().getId(), this.getId());
        int newFlags = this.flags;
        int suppressionValue = Message.MessageFlag.EMBEDS_SUPPRESSED.getValue();
        newFlags = suppressed ? (newFlags |= suppressionValue) : (newFlags &= ~suppressionValue);
        return new AuditableRestActionImpl<Void>((JDA)jda, route, DataObject.empty().put("flags", newFlags));
    }

    @Override
    @Nonnull
    public RestAction<Message> crosspost() {
        if (this.isEphemeral()) {
            throw new IllegalStateException("Cannot crosspost ephemeral messages.");
        }
        if (this.getFlags().contains((Object)Message.MessageFlag.CROSSPOSTED)) {
            return new CompletedRestAction<Message>(this.getJDA(), this);
        }
        if (!(this.getChannel() instanceof NewsChannel)) {
            throw new IllegalStateException("This message was not sent in a news channel");
        }
        NewsChannel newsChannel = (NewsChannel)((Object)this.getChannel());
        if (!this.getGuild().getSelfMember().hasAccess(newsChannel)) {
            throw new MissingAccessException(newsChannel, Permission.VIEW_CHANNEL);
        }
        if (!this.getAuthor().equals(this.getJDA().getSelfUser()) && !this.getGuild().getSelfMember().hasPermission((GuildChannel)newsChannel, Permission.MESSAGE_MANAGE)) {
            throw new InsufficientPermissionException(newsChannel, Permission.MESSAGE_MANAGE);
        }
        return newsChannel.crosspostMessageById(this.getId());
    }

    @Override
    public boolean isSuppressedEmbeds() {
        return (this.flags & Message.MessageFlag.EMBEDS_SUPPRESSED.getValue()) > 0;
    }

    @Override
    @Nonnull
    public EnumSet<Message.MessageFlag> getFlags() {
        return Message.MessageFlag.fromBitField(this.flags);
    }

    @Override
    public long getFlagsRaw() {
        return this.flags;
    }

    @Override
    public boolean isEphemeral() {
        return (this.flags & Message.MessageFlag.EPHEMERAL.getValue()) != 0;
    }

    @Override
    @Nullable
    public ThreadChannel getStartedThread() {
        return this.startedThread;
    }

    @Override
    public RestAction<ThreadChannel> createThreadChannel(String name) {
        return ((IThreadContainer)((Object)this.getGuildChannel())).createThreadChannel(name, this.getIdLong());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReceivedMessage)) {
            return false;
        }
        ReceivedMessage oMsg = (ReceivedMessage)o;
        return this.id == oMsg.id;
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public String toString() {
        return this.author != null ? String.format("M:%#s:%.20s(%s)", this.author, this, this.getId()) : String.format("M:%.20s", this);
    }

    @Override
    protected void unsupported() {
        throw new UnsupportedOperationException("This operation is not supported on received messages!");
    }

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        String out;
        boolean upper = (flags & 2) == 2;
        boolean leftJustified = (flags & 1) == 1;
        boolean alt = (flags & 4) == 4;
        String string = out = alt ? this.getContentRaw() : this.getContentDisplay();
        if (upper) {
            out = out.toUpperCase(formatter.locale());
        }
        this.appendFormat(formatter, width, precision, leftJustified, out);
    }
}

