/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.entities;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.GuildChannel;
import net.dv8tion.jda.api.entities.IPermissionContainer;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageChannel;
import net.dv8tion.jda.api.entities.channel.unions.MessageChannelUnion;
import net.dv8tion.jda.api.exceptions.InsufficientPermissionException;
import net.dv8tion.jda.api.exceptions.MissingAccessException;
import net.dv8tion.jda.api.requests.RestAction;
import net.dv8tion.jda.internal.JDAImpl;
import net.dv8tion.jda.internal.entities.ReceivedMessage;
import net.dv8tion.jda.internal.requests.CompletedRestAction;
import net.dv8tion.jda.internal.requests.RestActionImpl;
import net.dv8tion.jda.internal.requests.Route;

public class MessageReference {
    private final long messageId;
    private final long channelId;
    private final long guildId;
    private final JDA api;
    private final MessageChannel channel;
    private final Guild guild;
    private Message referencedMessage;

    public MessageReference(long messageId, long channelId, long guildId, @Nullable Message referencedMessage, JDA api) {
        this.messageId = messageId;
        this.channelId = channelId;
        this.guildId = guildId;
        this.referencedMessage = referencedMessage;
        this.channel = guildId == 0L ? api.getPrivateChannelById(channelId) : (MessageChannel)((Object)api.getGuildChannelById(channelId));
        this.guild = api.getGuildById(guildId);
        this.api = api;
    }

    @Nonnull
    public RestAction<Message> resolve() {
        return this.resolve(true);
    }

    @Nonnull
    public RestAction<Message> resolve(boolean update) {
        this.checkPermission(Permission.VIEW_CHANNEL);
        this.checkPermission(Permission.MESSAGE_HISTORY);
        if (this.channel == null) {
            throw new IllegalStateException("Cannot resolve a message without a channel present.");
        }
        JDAImpl jda = (JDAImpl)this.getJDA();
        Message referenced = this.getMessage();
        if (referenced != null && !update) {
            return new CompletedRestAction<Message>((JDA)jda, referenced);
        }
        Route.CompiledRoute route = Route.Messages.GET_MESSAGE.compile(this.getChannelId(), this.getMessageId());
        return new RestActionImpl<Message>((JDA)jda, route, (response, request) -> {
            ReceivedMessage created = jda.getEntityBuilder().createMessageWithChannel(response.getObject(), this.channel, false);
            this.referencedMessage = created;
            return created;
        });
    }

    @Nullable
    public Message getMessage() {
        return this.referencedMessage;
    }

    @Nullable
    public MessageChannelUnion getChannel() {
        return (MessageChannelUnion)this.channel;
    }

    @Nullable
    public Guild getGuild() {
        return this.guild;
    }

    public long getMessageIdLong() {
        return this.messageId;
    }

    public long getChannelIdLong() {
        return this.channelId;
    }

    public long getGuildIdLong() {
        return this.guildId;
    }

    @Nonnull
    public String getMessageId() {
        return Long.toUnsignedString(this.getMessageIdLong());
    }

    @Nonnull
    public String getChannelId() {
        return Long.toUnsignedString(this.getChannelIdLong());
    }

    @Nonnull
    public String getGuildId() {
        return Long.toUnsignedString(this.getGuildIdLong());
    }

    @Nonnull
    public JDA getJDA() {
        return this.api;
    }

    private void checkPermission(Permission permission) {
        IPermissionContainer permChannel;
        if (this.guild == null || !(this.channel instanceof IPermissionContainer)) {
            return;
        }
        Member selfMember = this.guild.getSelfMember();
        if (!selfMember.hasAccess(permChannel = (IPermissionContainer)((Object)this.channel))) {
            throw new MissingAccessException(permChannel, Permission.VIEW_CHANNEL);
        }
        if (!selfMember.hasPermission((GuildChannel)permChannel, permission)) {
            throw new InsufficientPermissionException(permChannel, permission);
        }
    }
}

