/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.entities.mixin.channel.middleman;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.ChannelType;
import net.dv8tion.jda.api.entities.GuildChannel;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageChannel;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.MessageHistory;
import net.dv8tion.jda.api.entities.emoji.Emoji;
import net.dv8tion.jda.api.exceptions.InsufficientPermissionException;
import net.dv8tion.jda.api.interactions.components.LayoutComponent;
import net.dv8tion.jda.api.requests.RestAction;
import net.dv8tion.jda.api.requests.restaction.AuditableRestAction;
import net.dv8tion.jda.api.requests.restaction.MessageAction;
import net.dv8tion.jda.api.requests.restaction.pagination.MessagePaginationAction;
import net.dv8tion.jda.api.requests.restaction.pagination.ReactionPaginationAction;
import net.dv8tion.jda.api.utils.AttachmentOption;
import net.dv8tion.jda.api.utils.TimeUtil;
import net.dv8tion.jda.api.utils.data.DataObject;
import net.dv8tion.jda.internal.requests.RestActionImpl;
import net.dv8tion.jda.internal.requests.Route;

public interface MessageChannelMixin<T extends MessageChannelMixin<T>>
extends MessageChannel {
    @Override
    @Nonnull
    default public List<CompletableFuture<Void>> purgeMessages(@Nonnull List<? extends Message> messages) {
        if (messages == null || messages.isEmpty()) {
            return Collections.emptyList();
        }
        if (!this.canDeleteOtherUsersMessages()) {
            for (Message message : messages) {
                if (message.getAuthor().equals(this.getJDA().getSelfUser())) continue;
                if (this.getType() == ChannelType.PRIVATE) {
                    throw new IllegalStateException("Cannot delete messages of other users in a private channel");
                }
                throw new InsufficientPermissionException((GuildChannel)((Object)this), Permission.MESSAGE_MANAGE, "Cannot delete messages of other users");
            }
        }
        return MessageChannel.super.purgeMessages(messages);
    }

    @Override
    @Nonnull
    default public List<CompletableFuture<Void>> purgeMessagesById(long ... messageIds) {
        if (messageIds == null || messageIds.length == 0) {
            return Collections.emptyList();
        }
        if (!this.canDeleteOtherUsersMessages()) {
            return MessageChannel.super.purgeMessagesById(messageIds);
        }
        LinkedList<CompletableFuture<Void>> list = new LinkedList<CompletableFuture<Void>>();
        TreeSet bulk = new TreeSet(Comparator.reverseOrder());
        TreeSet norm = new TreeSet(Comparator.reverseOrder());
        long twoWeeksAgo = TimeUtil.getDiscordTimestamp(System.currentTimeMillis() - 1209600000L + 10000L);
        for (long messageId : messageIds) {
            if (messageId > twoWeeksAgo) {
                bulk.add(messageId);
                continue;
            }
            norm.add(messageId);
        }
        if (!bulk.isEmpty()) {
            ArrayList<String> toDelete = new ArrayList<String>(100);
            while (!bulk.isEmpty()) {
                toDelete.clear();
                for (int i = 0; i < 100 && !bulk.isEmpty(); ++i) {
                    toDelete.add(Long.toUnsignedString((Long)bulk.pollLast()));
                }
                if (toDelete.size() == 1) {
                    list.add(this.deleteMessageById((String)toDelete.get(0)).submit());
                    continue;
                }
                if (toDelete.isEmpty()) continue;
                list.add(this.bulkDeleteMessages(toDelete).submit());
            }
        }
        if (!norm.isEmpty()) {
            Object object = norm.iterator();
            while (object.hasNext()) {
                long message = (Long)object.next();
                list.add(this.deleteMessageById(message).submit());
            }
        }
        return list;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    default public MessageAction sendMessage(@Nonnull CharSequence text) {
        this.checkCanAccessChannel();
        this.checkCanSendMessage();
        return MessageChannel.super.sendMessage(text);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    default public MessageAction sendMessageEmbeds(@Nonnull MessageEmbed embed, MessageEmbed ... other) {
        this.checkCanAccessChannel();
        this.checkCanSendMessage();
        this.checkCanSendMessageEmbeds();
        return MessageChannel.super.sendMessageEmbeds(embed, other);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    default public MessageAction sendMessageEmbeds(@Nonnull Collection<? extends MessageEmbed> embeds) {
        this.checkCanAccessChannel();
        this.checkCanSendMessage();
        this.checkCanSendMessageEmbeds();
        return MessageChannel.super.sendMessageEmbeds(embeds);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    default public MessageAction sendMessage(@Nonnull Message msg) {
        this.checkCanAccessChannel();
        this.checkCanSendMessage();
        return MessageChannel.super.sendMessage(msg);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    default public MessageAction sendFile(@Nonnull InputStream data, @Nonnull String fileName, AttachmentOption ... options) {
        this.checkCanAccessChannel();
        this.checkCanSendMessage();
        this.checkCanSendFiles();
        return MessageChannel.super.sendFile(data, fileName, options);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    default public RestAction<Message> retrieveMessageById(@Nonnull String messageId) {
        this.checkCanAccessChannel();
        this.checkCanViewHistory();
        return MessageChannel.super.retrieveMessageById(messageId);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    default public AuditableRestAction<Void> deleteMessageById(@Nonnull String messageId) {
        this.checkCanAccessChannel();
        return MessageChannel.super.deleteMessageById(messageId);
    }

    @Override
    @Nonnull
    default public MessageHistory getHistory() {
        this.checkCanAccessChannel();
        this.checkCanViewHistory();
        return MessageChannel.super.getHistory();
    }

    @Override
    @Nonnull
    @CheckReturnValue
    default public MessagePaginationAction getIterableHistory() {
        this.checkCanAccessChannel();
        this.checkCanViewHistory();
        return MessageChannel.super.getIterableHistory();
    }

    @Override
    @Nonnull
    @CheckReturnValue
    default public MessageHistory.MessageRetrieveAction getHistoryAround(@Nonnull String messageId, int limit) {
        this.checkCanAccessChannel();
        this.checkCanViewHistory();
        return MessageChannel.super.getHistoryAround(messageId, limit);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    default public MessageHistory.MessageRetrieveAction getHistoryAfter(@Nonnull String messageId, int limit) {
        this.checkCanAccessChannel();
        this.checkCanViewHistory();
        return MessageChannel.super.getHistoryAfter(messageId, limit);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    default public MessageHistory.MessageRetrieveAction getHistoryBefore(@Nonnull String messageId, int limit) {
        this.checkCanAccessChannel();
        this.checkCanViewHistory();
        return MessageChannel.super.getHistoryBefore(messageId, limit);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    default public MessageHistory.MessageRetrieveAction getHistoryFromBeginning(int limit) {
        this.checkCanAccessChannel();
        this.checkCanViewHistory();
        return MessageHistory.getHistoryFromBeginning(this).limit(limit);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    default public RestAction<Void> sendTyping() {
        this.checkCanAccessChannel();
        return MessageChannel.super.sendTyping();
    }

    @Override
    @Nonnull
    @CheckReturnValue
    default public RestAction<Void> addReactionById(@Nonnull String messageId, @Nonnull Emoji emoji) {
        this.checkCanAccessChannel();
        this.checkCanAddReactions();
        return MessageChannel.super.addReactionById(messageId, emoji);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    default public RestAction<Void> removeReactionById(@Nonnull String messageId, @Nonnull Emoji emoji) {
        this.checkCanAccessChannel();
        this.checkCanRemoveReactions();
        return MessageChannel.super.removeReactionById(messageId, emoji);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    default public ReactionPaginationAction retrieveReactionUsersById(@Nonnull String messageId, @Nonnull Emoji emoji) {
        this.checkCanAccessChannel();
        this.checkCanRemoveReactions();
        return MessageChannel.super.retrieveReactionUsersById(messageId, emoji);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    default public RestAction<Void> pinMessageById(@Nonnull String messageId) {
        this.checkCanAccessChannel();
        this.checkCanControlMessagePins();
        return MessageChannel.super.pinMessageById(messageId);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    default public RestAction<Void> unpinMessageById(@Nonnull String messageId) {
        this.checkCanAccessChannel();
        this.checkCanControlMessagePins();
        return MessageChannel.super.unpinMessageById(messageId);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    default public RestAction<List<Message>> retrievePinnedMessages() {
        this.checkCanAccessChannel();
        return MessageChannel.super.retrievePinnedMessages();
    }

    @Override
    @Nonnull
    @CheckReturnValue
    default public MessageAction editMessageById(@Nonnull String messageId, @Nonnull CharSequence newContent) {
        this.checkCanAccessChannel();
        this.checkCanSendMessage();
        return MessageChannel.super.editMessageById(messageId, newContent);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    default public MessageAction editMessageById(@Nonnull String messageId, @Nonnull Message newContent) {
        this.checkCanAccessChannel();
        this.checkCanSendMessage();
        return MessageChannel.super.editMessageById(messageId, newContent);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    default public MessageAction editMessageEmbedsById(@Nonnull String messageId, @Nonnull Collection<? extends MessageEmbed> newEmbeds) {
        this.checkCanAccessChannel();
        this.checkCanSendMessage();
        this.checkCanSendMessageEmbeds();
        return MessageChannel.super.editMessageEmbedsById(messageId, newEmbeds);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    default public MessageAction editMessageComponentsById(@Nonnull String messageId, @Nonnull Collection<? extends LayoutComponent> components) {
        this.checkCanAccessChannel();
        this.checkCanSendMessage();
        return MessageChannel.super.editMessageComponentsById(messageId, components);
    }

    public T setLatestMessageIdLong(long var1);

    public void checkCanAccessChannel();

    public void checkCanSendMessage();

    public void checkCanSendMessageEmbeds();

    public void checkCanSendFiles();

    public void checkCanViewHistory();

    public void checkCanAddReactions();

    public void checkCanRemoveReactions();

    public void checkCanControlMessagePins();

    public boolean canDeleteOtherUsersMessages();

    default public RestActionImpl<Void> bulkDeleteMessages(Collection<String> messageIds) {
        DataObject body = DataObject.empty().put("messages", messageIds);
        Route.CompiledRoute route = Route.Messages.DELETE_MESSAGES.compile(this.getId());
        return new RestActionImpl<Void>(this.getJDA(), route, body);
    }
}

