/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.entities.emoji;

import java.util.Objects;
import net.dv8tion.jda.api.entities.emoji.UnicodeEmoji;
import net.dv8tion.jda.api.utils.data.DataObject;
import net.dv8tion.jda.internal.utils.EncodingUtil;
import org.jetbrains.annotations.NotNull;

public class UnicodeEmojiImpl
implements UnicodeEmoji {
    private final String name;

    public UnicodeEmojiImpl(String name) {
        this.name = name;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getAsReactionCode() {
        return this.name;
    }

    @Override
    @NotNull
    public String getAsCodepoints() {
        return EncodingUtil.encodeCodepoints(this.name);
    }

    @Override
    @NotNull
    public DataObject toData() {
        return DataObject.empty().put("name", this.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UnicodeEmoji)) {
            return false;
        }
        return this.name.equals(((UnicodeEmoji)obj).getName());
    }

    public String toString() {
        return "UnicodeEmoji(" + this.getAsCodepoints() + ')';
    }
}

