/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.entities.emoji;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.dv8tion.jda.api.entities.emoji.CustomEmoji;
import net.dv8tion.jda.api.utils.data.DataObject;
import net.dv8tion.jda.internal.utils.Helpers;

public class CustomEmojiImpl
implements CustomEmoji {
    private final String name;
    private final long id;
    private final boolean animated;

    public CustomEmojiImpl(String name, long id, boolean animated) {
        this.name = name;
        this.id = id;
        this.animated = animated;
    }

    @Override
    @Nonnull
    public String getAsReactionCode() {
        return this.name + ":" + this.id;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    public long getIdLong() {
        return this.id;
    }

    @Override
    public boolean isAnimated() {
        return this.animated;
    }

    @Override
    @Nonnull
    public DataObject toData() {
        return DataObject.empty().put("name", this.name).put("id", this.id).put("animated", this.animated);
    }

    @Override
    @Nonnull
    public String getAsMention() {
        return Helpers.format("<%s:%s:%s>", this.animated ? "a" : "", this.name, this.getId());
    }

    @Override
    @Nonnull
    public String getFormatted() {
        return CustomEmoji.super.getFormatted();
    }

    public int hashCode() {
        return Objects.hash(this.name, this.id, this.animated);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CustomEmoji)) {
            return false;
        }
        CustomEmoji other = (CustomEmoji)obj;
        return other.getIdLong() == this.id;
    }

    public String toString() {
        return "CustomEmoji:" + this.name + "(" + this.id + ")";
    }
}

