/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.interactions.commands.build;

import javax.annotation.Nonnull;
import net.dv8tion.jda.api.interactions.commands.Command;
import net.dv8tion.jda.api.interactions.commands.DefaultMemberPermissions;
import net.dv8tion.jda.api.interactions.commands.build.SlashCommandData;
import net.dv8tion.jda.api.utils.data.DataObject;
import net.dv8tion.jda.api.utils.data.SerializableData;
import net.dv8tion.jda.internal.interactions.CommandDataImpl;
import net.dv8tion.jda.internal.utils.Checks;

public interface CommandData
extends SerializableData {
    @Nonnull
    public CommandData setName(@Nonnull String var1);

    @Nonnull
    public CommandData setDefaultPermissions(@Nonnull DefaultMemberPermissions var1);

    @Nonnull
    public CommandData setGuildOnly(boolean var1);

    @Nonnull
    public String getName();

    @Nonnull
    public Command.Type getType();

    @Nonnull
    public DefaultMemberPermissions getDefaultPermissions();

    public boolean isGuildOnly();

    @Nonnull
    public static CommandData fromCommand(@Nonnull Command command) {
        Checks.notNull(command, "Command");
        if (command.getType() != Command.Type.SLASH) {
            return new CommandDataImpl(command.getType(), command.getName()).setDefaultPermissions(command.getDefaultPermissions()).setGuildOnly(command.isGuildOnly());
        }
        return SlashCommandData.fromCommand(command);
    }

    @Nonnull
    public static CommandData fromData(@Nonnull DataObject object) {
        Checks.notNull(object, "DataObject");
        String name = object.getString("name");
        Command.Type commandType = Command.Type.fromId(object.getInt("type", 1));
        if (commandType != Command.Type.SLASH) {
            CommandDataImpl data = new CommandDataImpl(commandType, name);
            if (!object.isNull("default_member_permissions")) {
                long defaultPermissions = object.getLong("default_member_permissions");
                data.setDefaultPermissions(defaultPermissions == 0L ? DefaultMemberPermissions.DISABLED : DefaultMemberPermissions.enabledFor(defaultPermissions));
            }
            data.setGuildOnly(!object.getBoolean("dm_permission", true));
            return data;
        }
        return SlashCommandData.fromData(object);
    }
}

