/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.requests.restaction.interactions;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.dv8tion.jda.api.requests.Request;
import net.dv8tion.jda.api.requests.Response;
import net.dv8tion.jda.api.requests.RestAction;
import net.dv8tion.jda.api.requests.restaction.interactions.InteractionCallbackAction;
import net.dv8tion.jda.api.utils.AttachedFile;
import net.dv8tion.jda.api.utils.data.DataObject;
import net.dv8tion.jda.internal.interactions.InteractionImpl;
import net.dv8tion.jda.internal.requests.RestActionImpl;
import net.dv8tion.jda.internal.requests.Route;
import net.dv8tion.jda.internal.utils.IOUtil;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;

public abstract class InteractionCallbackImpl<T>
extends RestActionImpl<T>
implements InteractionCallbackAction<T> {
    protected final List<AttachedFile> files = new ArrayList<AttachedFile>();
    protected final InteractionImpl interaction;

    public InteractionCallbackImpl(InteractionImpl interaction) {
        super(interaction.getJDA(), Route.Interactions.CALLBACK.compile(interaction.getId(), interaction.getToken()));
        this.interaction = interaction;
    }

    protected abstract DataObject toData();

    @Override
    protected RequestBody finalizeData() {
        DataObject json = this.toData();
        if (this.files.isEmpty()) {
            return this.getRequestBody(json);
        }
        MultipartBody.Builder body = AttachedFile.createMultipartBody(this.files, null);
        body.addFormDataPart("payload_json", json.toString());
        this.files.clear();
        return body.build();
    }

    @Override
    @Nonnull
    public InteractionCallbackAction<T> closeResources() {
        this.files.forEach(IOUtil::silentClose);
        this.files.clear();
        return this;
    }

    protected void finalize() {
        if (this.files.isEmpty()) {
            return;
        }
        LOG.warn("Found open resources in interaction callback. Did you forget to close them?");
        this.closeResources();
    }

    protected final IllegalStateException tryAck() {
        return this.interaction.ack() ? new IllegalStateException("This interaction has already been acknowledged or replied to. You can only reply or acknowledge an interaction once!") : null;
    }

    @Override
    public final void queue(Consumer<? super T> success, Consumer<? super Throwable> failure) {
        IllegalStateException exception = this.tryAck();
        if (exception != null) {
            if (failure != null) {
                failure.accept(exception);
            } else {
                RestAction.getDefaultFailure().accept(exception);
            }
            return;
        }
        super.queue(success, failure);
    }

    @Override
    @Nonnull
    public final CompletableFuture<T> submit(boolean shouldQueue) {
        IllegalStateException exception = this.tryAck();
        if (exception != null) {
            CompletableFuture future = new CompletableFuture();
            future.completeExceptionally(exception);
            return future;
        }
        return super.submit(shouldQueue);
    }

    @Override
    protected void handleSuccess(Response response, Request<T> request) {
        this.interaction.releaseHook(true);
        super.handleSuccess(response, request);
    }

    @Override
    public void handleResponse(Response response, Request<T> request) {
        if (!response.isOk()) {
            this.interaction.releaseHook(false);
        }
        super.handleResponse(response, request);
    }
}

