/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.requests.restaction.interactions;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.interactions.InteractionHook;
import net.dv8tion.jda.api.interactions.components.ActionRow;
import net.dv8tion.jda.api.interactions.components.ItemComponent;
import net.dv8tion.jda.api.requests.restaction.interactions.InteractionCallbackAction;
import net.dv8tion.jda.api.utils.AllowedMentions;
import net.dv8tion.jda.api.utils.AttachmentOption;
import net.dv8tion.jda.internal.utils.Checks;

public interface ReplyCallbackAction
extends InteractionCallbackAction<InteractionHook>,
AllowedMentions<ReplyCallbackAction> {
    @Nonnull
    public ReplyCallbackAction setCheck(@Nullable BooleanSupplier var1);

    @Nonnull
    public ReplyCallbackAction timeout(long var1, @Nonnull TimeUnit var3);

    @Nonnull
    public ReplyCallbackAction deadline(long var1);

    @Nonnull
    public ReplyCallbackAction closeResources();

    @Nonnull
    @CheckReturnValue
    default public ReplyCallbackAction addEmbeds(MessageEmbed ... embeds) {
        Checks.noneNull(embeds, "MessageEmbed");
        return this.addEmbeds(Arrays.asList(embeds));
    }

    @Nonnull
    @CheckReturnValue
    public ReplyCallbackAction addEmbeds(@Nonnull Collection<? extends MessageEmbed> var1);

    @Nonnull
    @CheckReturnValue
    default public ReplyCallbackAction addActionRow(ItemComponent ... components) {
        return this.addActionRows(ActionRow.of(components));
    }

    @Nonnull
    @CheckReturnValue
    default public ReplyCallbackAction addActionRow(@Nonnull Collection<? extends ItemComponent> components) {
        return this.addActionRows(ActionRow.of(components));
    }

    @Nonnull
    @CheckReturnValue
    default public ReplyCallbackAction addActionRows(@Nonnull Collection<? extends ActionRow> rows) {
        Checks.noneNull(rows, "ActionRows");
        return this.addActionRows(rows.toArray(new ActionRow[0]));
    }

    @Nonnull
    @CheckReturnValue
    public ReplyCallbackAction addActionRows(ActionRow ... var1);

    @Nonnull
    public ReplyCallbackAction setContent(@Nullable String var1);

    @Nonnull
    public ReplyCallbackAction setTTS(boolean var1);

    @Nonnull
    @CheckReturnValue
    public ReplyCallbackAction setEphemeral(boolean var1);

    @Nonnull
    @CheckReturnValue
    default public ReplyCallbackAction addFile(@Nonnull File file, AttachmentOption ... options) {
        Checks.notNull(file, "File");
        return this.addFile(file, file.getName(), options);
    }

    @Nonnull
    @CheckReturnValue
    default public ReplyCallbackAction addFile(@Nonnull File file, @Nonnull String name, AttachmentOption ... options) {
        try {
            Checks.notNull(file, "File");
            Checks.check(file.exists() && file.canRead(), "Provided file either does not exist or cannot be read from!");
            return this.addFile(new FileInputStream(file), name, options);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Nonnull
    @CheckReturnValue
    default public ReplyCallbackAction addFile(@Nonnull byte[] data, @Nonnull String name, AttachmentOption ... options) {
        Checks.notNull(data, "Data");
        return this.addFile(new ByteArrayInputStream(data), name, options);
    }

    @Nonnull
    @CheckReturnValue
    public ReplyCallbackAction addFile(@Nonnull InputStream var1, @Nonnull String var2, AttachmentOption ... var3);
}

