/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.entities;

import java.awt.Color;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.annotations.Incubating;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.OnlineStatus;
import net.dv8tion.jda.api.entities.Activity;
import net.dv8tion.jda.api.entities.BaseGuildMessageChannel;
import net.dv8tion.jda.api.entities.ClientType;
import net.dv8tion.jda.api.entities.Emote;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.GuildVoiceState;
import net.dv8tion.jda.api.entities.IMentionable;
import net.dv8tion.jda.api.entities.IPermissionHolder;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.UserSnowflake;
import net.dv8tion.jda.api.requests.restaction.AuditableRestAction;
import net.dv8tion.jda.api.utils.ImageProxy;

public interface Member
extends IMentionable,
IPermissionHolder,
UserSnowflake {
    public static final String AVATAR_URL = "https://cdn.discordapp.com/guilds/%s/users/%s/avatars/%s.%s";
    public static final int MAX_TIME_OUT_LENGTH = 28;

    @Nonnull
    public User getUser();

    @Override
    @Nonnull
    public Guild getGuild();

    @Nonnull
    public JDA getJDA();

    @Nonnull
    public OffsetDateTime getTimeJoined();

    public boolean hasTimeJoined();

    @Nullable
    public OffsetDateTime getTimeBoosted();

    public boolean isBoosting();

    @Nullable
    public OffsetDateTime getTimeOutEnd();

    default public boolean isTimedOut() {
        return this.getTimeOutEnd() != null && this.getTimeOutEnd().isAfter(OffsetDateTime.now());
    }

    @Nullable
    public GuildVoiceState getVoiceState();

    @Nonnull
    public List<Activity> getActivities();

    @Nonnull
    public OnlineStatus getOnlineStatus();

    @Nonnull
    public OnlineStatus getOnlineStatus(@Nonnull ClientType var1);

    @Nonnull
    public EnumSet<ClientType> getActiveClients();

    @Nullable
    public String getNickname();

    @Nonnull
    public String getEffectiveName();

    @Nullable
    public String getAvatarId();

    @Nullable
    default public String getAvatarUrl() {
        String avatarId = this.getAvatarId();
        return avatarId == null ? null : String.format(AVATAR_URL, this.getGuild().getId(), this.getId(), avatarId, avatarId.startsWith("a_") ? "gif" : "png");
    }

    @Nullable
    default public ImageProxy getAvatar() {
        String avatarUrl = this.getAvatarUrl();
        return avatarUrl == null ? null : new ImageProxy(avatarUrl);
    }

    @Nonnull
    default public String getEffectiveAvatarUrl() {
        String avatarUrl = this.getAvatarUrl();
        return avatarUrl == null ? this.getUser().getEffectiveAvatarUrl() : avatarUrl;
    }

    @Nonnull
    default public ImageProxy getEffectiveAvatar() {
        ImageProxy avatar = this.getAvatar();
        return avatar == null ? this.getUser().getEffectiveAvatar() : avatar;
    }

    @Nonnull
    public List<Role> getRoles();

    @Nullable
    public Color getColor();

    public int getColorRaw();

    public boolean canInteract(@Nonnull Member var1);

    public boolean canInteract(@Nonnull Role var1);

    public boolean canInteract(@Nonnull Emote var1);

    public boolean isOwner();

    @Incubating
    public boolean isPending();

    @Nullable
    public BaseGuildMessageChannel getDefaultChannel();

    @Nonnull
    @CheckReturnValue
    default public AuditableRestAction<Void> ban(int delDays) {
        return this.getGuild().ban(this, delDays);
    }

    @Nonnull
    @CheckReturnValue
    default public AuditableRestAction<Void> ban(int delDays, @Nullable String reason) {
        return this.getGuild().ban(this, delDays, reason);
    }

    @Nonnull
    @CheckReturnValue
    default public AuditableRestAction<Void> kick() {
        return this.getGuild().kick(this);
    }

    @Nonnull
    @CheckReturnValue
    default public AuditableRestAction<Void> kick(@Nullable String reason) {
        return this.getGuild().kick(this, reason);
    }

    @Nonnull
    @CheckReturnValue
    default public AuditableRestAction<Void> timeoutFor(long amount, @Nonnull TimeUnit unit) {
        return this.getGuild().timeoutFor(this, amount, unit);
    }

    @Nonnull
    @CheckReturnValue
    default public AuditableRestAction<Void> timeoutFor(@Nonnull Duration duration) {
        return this.getGuild().timeoutFor(this, duration);
    }

    @Nonnull
    @CheckReturnValue
    default public AuditableRestAction<Void> timeoutUntil(@Nullable TemporalAccessor temporal) {
        return this.getGuild().timeoutUntil(this, temporal);
    }

    @Nonnull
    @CheckReturnValue
    default public AuditableRestAction<Void> removeTimeout() {
        return this.getGuild().removeTimeout(this);
    }

    @Nonnull
    @CheckReturnValue
    default public AuditableRestAction<Void> mute(boolean mute) {
        return this.getGuild().mute(this, mute);
    }

    @Nonnull
    @CheckReturnValue
    default public AuditableRestAction<Void> deafen(boolean deafen) {
        return this.getGuild().deafen(this, deafen);
    }

    @Nonnull
    @CheckReturnValue
    default public AuditableRestAction<Void> modifyNickname(@Nullable String nickname) {
        return this.getGuild().modifyNickname(this, nickname);
    }
}

