/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.requests.restaction;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import net.dv8tion.jda.api.entities.ChannelType;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.GuildChannel;
import net.dv8tion.jda.api.entities.ThreadChannel;
import net.dv8tion.jda.api.requests.Request;
import net.dv8tion.jda.api.requests.Response;
import net.dv8tion.jda.api.requests.restaction.ThreadAction;
import net.dv8tion.jda.api.utils.data.DataObject;
import net.dv8tion.jda.internal.requests.Route;
import net.dv8tion.jda.internal.requests.restaction.AuditableRestActionImpl;
import net.dv8tion.jda.internal.utils.Checks;
import okhttp3.RequestBody;

public class ThreadActionImpl
extends AuditableRestActionImpl<ThreadChannel>
implements ThreadAction {
    protected final Guild guild;
    protected final ChannelType type;
    protected final String parentMessageId;
    protected String name;
    protected ThreadChannel.AutoArchiveDuration autoArchiveDuration = null;
    protected Boolean invitable = null;

    public ThreadActionImpl(GuildChannel channel, String name, ChannelType type) {
        super(channel.getJDA(), Route.Channels.CREATE_THREAD_WITHOUT_MESSAGE.compile(channel.getId()));
        this.guild = channel.getGuild();
        this.type = type;
        this.parentMessageId = null;
        this.name = name;
    }

    public ThreadActionImpl(GuildChannel channel, String name, String parentMessageId) {
        super(channel.getJDA(), Route.Channels.CREATE_THREAD_WITH_MESSAGE.compile(channel.getId(), parentMessageId));
        this.guild = channel.getGuild();
        this.type = channel.getType() == ChannelType.TEXT ? ChannelType.GUILD_PUBLIC_THREAD : ChannelType.GUILD_NEWS_THREAD;
        this.parentMessageId = parentMessageId;
        this.name = name;
    }

    @Override
    @Nonnull
    public ThreadActionImpl setCheck(BooleanSupplier checks) {
        return (ThreadActionImpl)super.setCheck(checks);
    }

    @Override
    @Nonnull
    public ThreadActionImpl timeout(long timeout, @Nonnull TimeUnit unit) {
        return (ThreadActionImpl)super.timeout(timeout, unit);
    }

    @Override
    @Nonnull
    public ThreadActionImpl deadline(long timestamp) {
        return (ThreadActionImpl)super.deadline(timestamp);
    }

    @Override
    @Nonnull
    public Guild getGuild() {
        return this.guild;
    }

    @Override
    @Nonnull
    public ChannelType getType() {
        return this.type;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public ThreadActionImpl setName(@Nonnull String name) {
        Checks.notEmpty(name, "Name");
        Checks.notLonger(name, 100, "Name");
        this.name = name;
        return this;
    }

    @Override
    @Nonnull
    public ThreadAction setAutoArchiveDuration(@Nonnull ThreadChannel.AutoArchiveDuration autoArchiveDuration) {
        Checks.notNull((Object)autoArchiveDuration, "autoArchiveDuration");
        Set<String> features = this.guild.getFeatures();
        if (autoArchiveDuration == ThreadChannel.AutoArchiveDuration.TIME_3_DAYS && !features.contains("THREE_DAY_THREAD_ARCHIVE")) {
            throw new IllegalStateException("Cannot use TIME_3_DAYS archive duration because feature isn't supported on this Guild. Missing THREE_DAY_THREAD_ARCHIVE feature due to boost level being too low.");
        }
        if (autoArchiveDuration == ThreadChannel.AutoArchiveDuration.TIME_1_WEEK && !features.contains("SEVEN_DAY_THREAD_ARCHIVE")) {
            throw new IllegalStateException("Cannot use TIME_1_WEEK archive duration because feature isn't supported on this Guild. Missing SEVEN_DAY_THREAD_ARCHIVE feature due to boost level being too low.");
        }
        this.autoArchiveDuration = autoArchiveDuration;
        return this;
    }

    @Override
    @Nonnull
    public ThreadAction setInvitable(boolean invitable) {
        if (this.type != ChannelType.GUILD_PRIVATE_THREAD) {
            throw new UnsupportedOperationException("Can only set invitable on private threads");
        }
        this.invitable = invitable;
        return this;
    }

    @Override
    protected RequestBody finalizeData() {
        DataObject object = DataObject.empty();
        object.put("name", this.name);
        if (this.parentMessageId == null) {
            object.put("type", this.type.getId());
        }
        if (this.autoArchiveDuration != null) {
            object.put("auto_archive_duration", this.autoArchiveDuration.getMinutes());
        }
        if (this.invitable != null) {
            object.put("invitable", this.invitable);
        }
        return this.getRequestBody(object);
    }

    @Override
    protected void handleSuccess(Response response, Request<ThreadChannel> request) {
        ThreadChannel channel = this.api.getEntityBuilder().createThreadChannel(response.getObject(), this.guild.getIdLong());
        request.onSuccess(channel);
    }
}

