/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.requests.restaction;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.ChannelType;
import net.dv8tion.jda.api.entities.EmbedType;
import net.dv8tion.jda.api.entities.GuildChannel;
import net.dv8tion.jda.api.entities.IMentionable;
import net.dv8tion.jda.api.entities.IPermissionContainer;
import net.dv8tion.jda.api.entities.ISnowflake;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageChannel;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.TextChannel;
import net.dv8tion.jda.api.entities.sticker.GuildSticker;
import net.dv8tion.jda.api.entities.sticker.StickerSnowflake;
import net.dv8tion.jda.api.exceptions.InsufficientPermissionException;
import net.dv8tion.jda.api.exceptions.MissingAccessException;
import net.dv8tion.jda.api.interactions.InteractionHook;
import net.dv8tion.jda.api.interactions.components.ActionRow;
import net.dv8tion.jda.api.requests.Request;
import net.dv8tion.jda.api.requests.Response;
import net.dv8tion.jda.api.requests.restaction.MessageAction;
import net.dv8tion.jda.api.utils.AttachedFile;
import net.dv8tion.jda.api.utils.AttachmentOption;
import net.dv8tion.jda.api.utils.FileUpload;
import net.dv8tion.jda.api.utils.data.DataArray;
import net.dv8tion.jda.api.utils.data.DataObject;
import net.dv8tion.jda.internal.entities.DataMessage;
import net.dv8tion.jda.internal.requests.Requester;
import net.dv8tion.jda.internal.requests.RestActionImpl;
import net.dv8tion.jda.internal.requests.Route;
import net.dv8tion.jda.internal.utils.AllowedMentionsImpl;
import net.dv8tion.jda.internal.utils.Checks;
import net.dv8tion.jda.internal.utils.Helpers;
import net.dv8tion.jda.internal.utils.IOUtil;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;

public class MessageActionImpl
extends RestActionImpl<Message>
implements MessageAction {
    private static final String CONTENT_TOO_BIG = Helpers.format("A message may not exceed %d characters. Please limit your input!", 2000);
    protected static boolean defaultFailOnInvalidReply = false;
    protected final List<AttachedFile> files = new ArrayList<AttachedFile>();
    protected final StringBuilder content;
    protected final MessageChannel channel;
    protected final AllowedMentionsImpl allowedMentions = new AllowedMentionsImpl();
    protected List<ActionRow> components;
    protected List<String> retainedAttachments;
    protected List<MessageEmbed> embeds = null;
    protected List<String> stickers = null;
    protected String nonce = null;
    protected boolean tts = false;
    protected boolean override = false;
    protected boolean failOnInvalidReply = defaultFailOnInvalidReply;
    protected long messageReference;
    protected final String messageId;
    private InteractionHook hook = null;

    public static void setDefaultFailOnInvalidReply(boolean fail) {
        defaultFailOnInvalidReply = fail;
    }

    public static boolean isDefaultFailOnInvalidReply() {
        return defaultFailOnInvalidReply;
    }

    public MessageActionImpl(JDA api, String messageId, MessageChannel channel) {
        super(api, messageId != null ? Route.Messages.EDIT_MESSAGE.compile(channel.getId(), messageId) : Route.Messages.SEND_MESSAGE.compile(channel.getId()));
        this.content = new StringBuilder();
        this.channel = channel;
        this.messageId = messageId;
    }

    public MessageActionImpl(JDA api, String messageId, MessageChannel channel, StringBuilder contentBuilder) {
        super(api, messageId != null ? Route.Messages.EDIT_MESSAGE.compile(channel.getId(), messageId) : Route.Messages.SEND_MESSAGE.compile(channel.getId()));
        Checks.check(contentBuilder.length() <= 2000, "Cannot build a Message with more than %d characters. Please limit your input.", (Object)2000);
        this.content = contentBuilder;
        this.channel = channel;
        this.messageId = messageId;
    }

    public MessageActionImpl withHook(InteractionHook hook) {
        this.hook = hook;
        return this;
    }

    @Override
    protected Route.CompiledRoute finalizeRoute() {
        if (this.hook == null || this.hook.isExpired()) {
            return super.finalizeRoute();
        }
        if (this.isEdit()) {
            return Route.Interactions.EDIT_FOLLOWUP.compile(this.api.getSelfUser().getApplicationId(), this.hook.getInteraction().getToken(), this.messageId);
        }
        return Route.Interactions.CREATE_FOLLOWUP.compile(this.api.getSelfUser().getApplicationId(), this.hook.getInteraction().getToken());
    }

    @Override
    @Nonnull
    public MessageAction setCheck(BooleanSupplier checks) {
        return (MessageAction)super.setCheck(checks);
    }

    @Override
    @Nonnull
    public MessageAction timeout(long timeout, @Nonnull TimeUnit unit) {
        return (MessageAction)super.timeout(timeout, unit);
    }

    @Override
    @Nonnull
    public MessageAction deadline(long timestamp) {
        return (MessageAction)super.deadline(timestamp);
    }

    @Override
    @Nonnull
    public MessageChannel getChannel() {
        return this.channel;
    }

    @Override
    public boolean isEmpty() {
        return !this.isEdit() && Helpers.isBlank(this.content) && (this.embeds == null || this.embeds.isEmpty() || !this.hasPermission(Permission.MESSAGE_EMBED_LINKS)) && this.stickers == null;
    }

    @Override
    public boolean isEdit() {
        return this.messageId != null;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public MessageActionImpl apply(Message message) {
        if (message == null || message.getType().isSystem()) {
            return this;
        }
        List<MessageEmbed> embeds = message.getEmbeds();
        if (embeds != null && !embeds.isEmpty()) {
            this.setEmbeds((Collection)embeds.stream().filter(e -> e != null && e.getType() == EmbedType.RICH).collect(Collectors.toList()));
        }
        this.files.clear();
        if (message instanceof DataMessage) {
            this.setStickers(((DataMessage)message).getStickerSnowflakes());
        } else {
            this.setStickers(message.getStickers());
        }
        this.components = new ArrayList<ActionRow>();
        this.components.addAll(message.getActionRows());
        this.allowedMentions.applyMessage(message);
        String content = message.getContentRaw();
        return this.content(content).tts(message.isTTS());
    }

    @Override
    @Nonnull
    public MessageActionImpl referenceById(long messageId) {
        this.messageReference = messageId;
        return this;
    }

    @Override
    @Nonnull
    public MessageActionImpl failOnInvalidReply(boolean fail) {
        this.failOnInvalidReply = fail;
        return this;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public MessageActionImpl tts(boolean isTTS) {
        this.tts = isTTS;
        return this;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public MessageActionImpl reset() {
        return ((MessageActionImpl)this.content(null).nonce(null).setEmbeds((Collection)Collections.emptyList())).tts(false).override(false).clearFiles();
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public MessageActionImpl nonce(String nonce) {
        this.nonce = nonce;
        return this;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public MessageActionImpl content(String content) {
        if (content == null || content.isEmpty()) {
            this.content.setLength(0);
        } else if (content.length() <= 2000) {
            this.content.replace(0, this.content.length(), content);
        } else {
            throw new IllegalArgumentException(CONTENT_TOO_BIG);
        }
        return this;
    }

    @Override
    @Nonnull
    public MessageActionImpl setEmbeds(@Nonnull Collection<? extends MessageEmbed> embeds) {
        Checks.noneNull(embeds, "MessageEmbeds");
        embeds.forEach(embed -> Checks.check(embed.isSendable(), "Provided Message contains an empty embed or an embed with a length greater than %d characters, which is the max for bot accounts!", (Object)6000));
        Checks.check(embeds.size() <= 10, "Cannot have more than %d embeds in a message!", (Object)10);
        Checks.check(embeds.stream().mapToInt(MessageEmbed::getLength).sum() <= 6000, "The sum of all MessageEmbeds may not exceed %d!", (Object)6000);
        if (this.embeds == null) {
            this.embeds = new ArrayList<MessageEmbed>();
        }
        this.embeds.clear();
        this.embeds.addAll(embeds);
        return this;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public MessageActionImpl append(CharSequence csq, int start, int end) {
        if (this.content.length() + end - start > 2000) {
            throw new IllegalArgumentException("A message may not exceed 2000 characters. Please limit your input!");
        }
        this.content.append(csq, start, end);
        return this;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public MessageActionImpl append(char c) {
        if (this.content.length() == 2000) {
            throw new IllegalArgumentException("A message may not exceed 2000 characters. Please limit your input!");
        }
        this.content.append(c);
        return this;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public MessageActionImpl addFile(@Nonnull InputStream data, @Nonnull String name, AttachmentOption ... options) {
        Checks.notNull(data, "Data");
        Checks.notBlank(name, "Name");
        Checks.noneNull((Object[])options, "Options");
        this.checkFileAmount();
        this.checkPermission(Permission.MESSAGE_ATTACH_FILES);
        name = this.applyOptions(name, options);
        this.files.add(FileUpload.fromData(data, name));
        return this;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public MessageActionImpl addFile(@Nonnull File file, @Nonnull String name, AttachmentOption ... options) {
        Checks.notNull(file, "File");
        Checks.noneNull((Object[])options, "Options");
        Checks.check(file.exists() && file.canRead(), "Provided file either does not exist or cannot be read from!");
        long maxSize = this.getMaxFileSize();
        Checks.check(file.length() <= maxSize, "File may not exceed the maximum file length of %d bytes!", (Object)maxSize);
        try {
            FileInputStream data = new FileInputStream(file);
            name = this.applyOptions(name, options);
            return this.addFile(data, name, new AttachmentOption[0]);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    @Nonnull
    public MessageAction addFile(@Nonnull byte[] data, @Nonnull String name, AttachmentOption ... options) {
        Checks.notNull(data, "Data");
        long maxSize = this.getMaxFileSize();
        Checks.check((long)data.length <= maxSize, "File may not exceed the maximum file length of %d bytes!", (Object)maxSize);
        return this.addFile(new ByteArrayInputStream(data), name, options);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public MessageActionImpl clearFiles() {
        this.files.forEach(IOUtil::silentClose);
        this.files.clear();
        return this;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public MessageActionImpl clearFiles(@Nonnull BiConsumer<String, InputStream> finalizer) {
        Checks.notNull(finalizer, "Finalizer");
        for (AttachedFile file : this.files) {
            if (!(file instanceof FileUpload)) continue;
            FileUpload upload = (FileUpload)file;
            finalizer.accept(upload.getName(), upload.getData());
        }
        return this.clearFiles();
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public MessageActionImpl clearFiles(@Nonnull Consumer<InputStream> finalizer) {
        Checks.notNull(finalizer, "Finalizer");
        for (AttachedFile file : this.files) {
            if (!(file instanceof FileUpload)) continue;
            FileUpload upload = (FileUpload)file;
            finalizer.accept(upload.getData());
        }
        return this.clearFiles();
    }

    @Override
    @Nonnull
    public MessageActionImpl retainFilesById(@Nonnull Collection<String> ids) {
        if (!this.isEdit()) {
            return this;
        }
        if (this.retainedAttachments == null) {
            this.retainedAttachments = new ArrayList<String>();
        }
        this.retainedAttachments.addAll(ids);
        return this;
    }

    @Override
    @Nonnull
    public MessageActionImpl setActionRows(ActionRow ... rows) {
        Checks.noneNull(rows, "ActionRows");
        Checks.checkComponents("Some components are incompatible with Messages", rows, component -> component.getType().isMessageCompatible());
        if (this.components == null) {
            this.components = new ArrayList<ActionRow>();
        }
        Checks.check(rows.length <= 5, "Can only have 5 action rows per message!");
        Checks.checkDuplicateIds(Arrays.stream(rows));
        this.components.clear();
        Collections.addAll(this.components, rows);
        return this;
    }

    @Override
    @Nonnull
    public MessageAction setStickers(@Nullable Collection<? extends StickerSnowflake> stickers) {
        if (this.isEdit()) {
            throw new IllegalStateException("Cannot edit stickers on messages!");
        }
        if (stickers == null || stickers.isEmpty()) {
            this.stickers = new ArrayList<String>();
            return this;
        }
        if (!(this.channel instanceof GuildChannel)) {
            throw new IllegalStateException("Cannot send stickers in direct messages!");
        }
        GuildChannel guildChannel = (GuildChannel)((Object)this.channel);
        Checks.noneNull(stickers, "Stickers");
        Checks.check(stickers.size() <= 3, "Cannot send more than %d stickers in a message!", (Object)3);
        for (StickerSnowflake stickerSnowflake : stickers) {
            if (!(stickerSnowflake instanceof GuildSticker)) continue;
            GuildSticker guildSticker = (GuildSticker)stickerSnowflake;
            Checks.check(guildSticker.isAvailable(), "Cannot use unavailable sticker. The guild may have lost the boost level required to use this sticker!");
            Checks.check(guildSticker.getGuildIdLong() == guildChannel.getGuild().getIdLong(), "Sticker must be from the same guild. Cross-guild sticker posting is not supported!");
        }
        this.stickers = stickers.stream().map(ISnowflake::getId).collect(Collectors.toList());
        return this;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public MessageActionImpl override(boolean bool) {
        this.override = this.isEdit() && bool;
        return this;
    }

    @Override
    @Nonnull
    public MessageActionImpl mentionRepliedUser(boolean mention) {
        this.allowedMentions.mentionRepliedUser(mention);
        return this;
    }

    @Override
    @Nonnull
    public MessageActionImpl allowedMentions(@Nullable Collection<Message.MentionType> allowedMentions) {
        this.allowedMentions.allowedMentions((Collection)allowedMentions);
        return this;
    }

    @Override
    @Nonnull
    public MessageActionImpl mention(IMentionable ... mentions) {
        this.allowedMentions.mention(mentions);
        return this;
    }

    @Override
    @Nonnull
    public MessageActionImpl mentionUsers(String ... userIds) {
        this.allowedMentions.mentionUsers(userIds);
        return this;
    }

    @Override
    @Nonnull
    public MessageActionImpl mentionRoles(String ... roleIds) {
        this.allowedMentions.mentionRoles(roleIds);
        return this;
    }

    private String applyOptions(String name, AttachmentOption[] options) {
        for (AttachmentOption opt : options) {
            if (opt != AttachmentOption.SPOILER) continue;
            name = "SPOILER_" + name;
            break;
        }
        return name;
    }

    private long getMaxFileSize() {
        if (this.channel.getType().isGuild()) {
            return ((GuildChannel)((Object)this.channel)).getGuild().getMaxFileSize();
        }
        return this.getJDA().getSelfUser().getAllowedFileSize();
    }

    protected RequestBody asMultipart() {
        MultipartBody.Builder builder = AttachedFile.createMultipartBody(this.files, null);
        if (this.messageReference != 0L || this.components != null || this.retainedAttachments != null || !this.isEmpty()) {
            builder.addFormDataPart("payload_json", this.getJSON().toString());
        }
        this.files.clear();
        return builder.build();
    }

    protected RequestBody asJSON() {
        return RequestBody.create((MediaType)Requester.MEDIA_TYPE_JSON, (byte[])this.getJSON().toJson());
    }

    protected DataObject getJSON() {
        DataObject obj = DataObject.empty();
        if (this.override) {
            if (this.embeds == null) {
                obj.put("embeds", DataArray.empty());
            } else {
                obj.put("embeds", DataArray.fromCollection(this.embeds));
            }
            if (this.content.length() == 0) {
                obj.putNull("content");
            } else {
                obj.put("content", this.content.toString());
            }
            if (this.nonce == null) {
                obj.putNull("nonce");
            } else {
                obj.put("nonce", this.nonce);
            }
            if (this.components == null) {
                obj.put("components", DataArray.empty());
            } else {
                obj.put("components", DataArray.fromCollection(this.components));
            }
            if (this.retainedAttachments != null) {
                obj.put("attachments", DataArray.fromCollection(this.retainedAttachments.stream().map((? super T id) -> DataObject.empty().put("id", id)).collect(Collectors.toList())));
            } else {
                obj.put("attachments", DataArray.empty());
            }
        } else {
            if (this.embeds != null) {
                obj.put("embeds", DataArray.fromCollection(this.embeds));
            }
            if (this.content.length() > 0) {
                obj.put("content", this.content.toString());
            }
            if (this.nonce != null) {
                obj.put("nonce", this.nonce);
            }
            if (this.components != null) {
                obj.put("components", DataArray.fromCollection(this.components));
            }
            if (this.stickers != null) {
                obj.put("sticker_ids", DataArray.fromCollection(this.stickers));
            }
            if (this.retainedAttachments != null) {
                obj.put("attachments", DataArray.fromCollection(this.retainedAttachments.stream().map((? super T id) -> DataObject.empty().put("id", id)).collect(Collectors.toList())));
            }
        }
        if (this.messageReference != 0L) {
            obj.put("message_reference", DataObject.empty().put("message_id", this.messageReference).put("channel_id", this.channel.getId()).put("fail_if_not_exists", this.failOnInvalidReply));
        }
        obj.put("tts", this.tts);
        obj.put("allowed_mentions", this.allowedMentions);
        return obj;
    }

    protected void checkFileAmount() {
        if (this.files.size() >= 10) {
            throw new IllegalStateException("Cannot add more than 10 files!");
        }
    }

    protected void checkEdit() {
        if (this.isEdit()) {
            throw new IllegalStateException("Cannot add files to an existing message! Edit-Message does not support this operation!");
        }
    }

    protected void checkPermission(Permission perm) {
        if (!this.channel.getType().isGuild()) {
            return;
        }
        if (!(this.channel instanceof IPermissionContainer)) {
            return;
        }
        IPermissionContainer gc = (IPermissionContainer)((Object)this.channel);
        if (!gc.getGuild().getSelfMember().hasAccess(gc)) {
            throw new MissingAccessException(gc, Permission.VIEW_CHANNEL);
        }
        if (!this.hasPermission(perm)) {
            throw new InsufficientPermissionException(gc, perm);
        }
    }

    protected boolean hasPermission(Permission perm) {
        if (this.channel.getType() != ChannelType.TEXT) {
            return true;
        }
        TextChannel text = (TextChannel)this.channel;
        Member self = text.getGuild().getSelfMember();
        return self.hasPermission((GuildChannel)text, perm);
    }

    @Override
    protected RequestBody finalizeData() {
        if (!this.files.isEmpty()) {
            return this.asMultipart();
        }
        if (!this.isEmpty()) {
            return this.asJSON();
        }
        if (this.embeds != null && !this.embeds.isEmpty() && this.channel instanceof GuildChannel) {
            throw new InsufficientPermissionException((GuildChannel)((Object)this.channel), Permission.MESSAGE_EMBED_LINKS, "Cannot send message with only embeds without Permission.MESSAGE_EMBED_LINKS!");
        }
        throw new IllegalStateException("Cannot build a message without content!");
    }

    @Override
    protected void handleSuccess(Response response, Request<Message> request) {
        request.onSuccess(this.api.getEntityBuilder().createMessageWithChannel(response.getObject(), this.channel, false));
    }

    protected void finalize() {
        if (this.files.isEmpty()) {
            return;
        }
        LOG.warn("Found unclosed resources in MessageAction instance, closing on finalization step!");
        this.clearFiles();
    }
}

