/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.utils;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.annotation.Nonnull;
import net.dv8tion.jda.api.utils.AttachedFile;
import net.dv8tion.jda.api.utils.data.DataObject;
import net.dv8tion.jda.internal.requests.Requester;
import net.dv8tion.jda.internal.utils.Checks;
import net.dv8tion.jda.internal.utils.IOUtil;
import okhttp3.MultipartBody;

public class FileUpload
implements Closeable,
AttachedFile {
    private final InputStream resource;
    private final String name;
    private boolean claimed = false;

    protected FileUpload(InputStream resource, String name) {
        this.resource = resource;
        this.name = name;
    }

    @Nonnull
    public static FileUpload fromData(@Nonnull InputStream data, @Nonnull String name) {
        Checks.notNull(data, "Data");
        Checks.notBlank(name, "Name");
        return new FileUpload(data, name);
    }

    @Nonnull
    public static FileUpload fromData(@Nonnull byte[] data, @Nonnull String name) {
        Checks.notNull(data, "Data");
        Checks.notNull(name, "Name");
        return FileUpload.fromData(new ByteArrayInputStream(data), name);
    }

    @Nonnull
    public static FileUpload fromData(@Nonnull File file, @Nonnull String name) {
        Checks.notNull(file, "File");
        try {
            return FileUpload.fromData(new FileInputStream(file), name);
        }
        catch (FileNotFoundException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Nonnull
    public static FileUpload fromData(@Nonnull File file) {
        Checks.notNull(file, "File");
        try {
            return FileUpload.fromData(new FileInputStream(file), file.getName());
        }
        catch (FileNotFoundException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Nonnull
    public static FileUpload fromData(@Nonnull Path path, @Nonnull String name, OpenOption ... options) {
        Checks.notNull(path, "Path");
        Checks.noneNull(options, "Options");
        Checks.check(Files.isReadable(path), "File for specified path cannot be read. Path: %s", (Object)path);
        try {
            return FileUpload.fromData(Files.newInputStream(path, options), name);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not open file for specified path. Path: " + path, e);
        }
    }

    @Nonnull
    public static FileUpload fromData(@Nonnull Path path, OpenOption ... options) {
        Checks.notNull(path, "Path");
        Path fileName = path.getFileName();
        Checks.check(fileName != null, "Path does not have a file name. Path: %s", (Object)path);
        return FileUpload.fromData(path, fileName.toString(), options);
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public InputStream getData() {
        return this.resource;
    }

    @Override
    public synchronized void claim() {
        if (this.claimed) {
            throw new IllegalStateException("Instances of FileUpload can only be used once. Create a new instance with a new data source for each use.");
        }
        this.claimed = true;
    }

    @Override
    public synchronized boolean isClaimed() {
        return this.claimed;
    }

    @Override
    public void addPart(@Nonnull MultipartBody.Builder builder, int index) {
        builder.addFormDataPart("files[" + index + "]", this.name, IOUtil.createRequestBody(Requester.MEDIA_TYPE_OCTET, this.resource));
    }

    @Override
    @Nonnull
    public DataObject toAttachmentData(int index) {
        return DataObject.empty().put("id", index).put("filename", this.name);
    }

    @Override
    public void close() throws IOException {
        if (this.resource != null) {
            this.resource.close();
        }
    }

    protected void finalize() {
        IOUtil.silentClose(this.resource);
    }

    public String toString() {
        return "AttachedFile[Data]:" + this.name;
    }
}

