/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.entities;

import javax.annotation.Nonnull;
import net.dv8tion.jda.api.AccountType;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.ChannelType;
import net.dv8tion.jda.api.entities.PrivateChannel;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.requests.RestAction;
import net.dv8tion.jda.internal.entities.AbstractChannelImpl;
import net.dv8tion.jda.internal.entities.mixin.channel.middleman.MessageChannelMixin;
import net.dv8tion.jda.internal.requests.RestActionImpl;
import net.dv8tion.jda.internal.requests.Route;

public class PrivateChannelImpl
extends AbstractChannelImpl<PrivateChannelImpl>
implements PrivateChannel,
MessageChannelMixin<PrivateChannelImpl> {
    private User user;
    private long latestMessageId;

    public PrivateChannelImpl(long id, User user) {
        super(id, user.getJDA());
        this.user = user;
    }

    @Override
    @Nonnull
    public ChannelType getType() {
        return ChannelType.PRIVATE;
    }

    @Override
    @Nonnull
    public User getUser() {
        this.updateUser();
        return this.user;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.getUser().getName();
    }

    @Override
    @Nonnull
    public JDA getJDA() {
        return this.user.getJDA();
    }

    @Override
    @Nonnull
    public RestAction<Void> delete() {
        Route.CompiledRoute route = Route.Channels.DELETE_CHANNEL.compile(this.getId());
        return new RestActionImpl<Void>(this.getJDA(), route);
    }

    @Override
    public long getLatestMessageIdLong() {
        return this.latestMessageId;
    }

    @Override
    public void checkCanAccessChannel() {
    }

    @Override
    public void checkCanSendMessage() {
        this.checkBot();
    }

    @Override
    public void checkCanSendMessageEmbeds() {
    }

    @Override
    public void checkCanSendFiles() {
    }

    @Override
    public void checkCanViewHistory() {
    }

    @Override
    public void checkCanAddReactions() {
    }

    @Override
    public void checkCanRemoveReactions() {
    }

    @Override
    public void checkCanControlMessagePins() {
    }

    @Override
    public boolean canDeleteOtherUsersMessages() {
        return false;
    }

    @Override
    public PrivateChannelImpl setLatestMessageIdLong(long latestMessageId) {
        this.latestMessageId = latestMessageId;
        return this;
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PrivateChannelImpl)) {
            return false;
        }
        PrivateChannelImpl impl = (PrivateChannelImpl)obj;
        return impl.id == this.id;
    }

    public String toString() {
        return "PC:" + this.getUser().getName() + '(' + this.getId() + ')';
    }

    private void updateUser() {
        User realUser = this.getJDA().getUserById(this.user.getIdLong());
        if (realUser != null) {
            this.user = realUser;
        }
    }

    private void checkBot() {
        if (this.getUser().isBot() && this.getJDA().getAccountType() == AccountType.BOT) {
            throw new UnsupportedOperationException("Cannot send a private message between bots.");
        }
    }
}

