/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.requests;

import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import javax.net.ssl.SSLPeerUnverifiedException;
import net.dv8tion.jda.api.AccountType;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDAInfo;
import net.dv8tion.jda.internal.JDAImpl;
import net.dv8tion.jda.internal.requests.FunctionalCallback;
import net.dv8tion.jda.internal.requests.RateLimiter;
import net.dv8tion.jda.internal.requests.Route;
import net.dv8tion.jda.internal.requests.ratelimit.BotRateLimiter;
import net.dv8tion.jda.internal.requests.ratelimit.ClientRateLimiter;
import net.dv8tion.jda.internal.utils.JDALogger;
import net.dv8tion.jda.internal.utils.config.AuthorizationConfig;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal.http.HttpMethod;
import org.slf4j.Logger;
import org.slf4j.MDC;

public class Requester {
    public static final Logger LOG = JDALogger.getLog(Requester.class);
    public static final String DISCORD_API_PREFIX = String.format("https://discordapp.com/api/v%d/", 6);
    public static final String USER_AGENT = "DiscordBot (https://github.com/DV8FromTheWorld/JDA, " + JDAInfo.VERSION + ")";
    public static final RequestBody EMPTY_BODY = RequestBody.create(null, (byte[])new byte[0]);
    public static final MediaType MEDIA_TYPE_JSON = MediaType.parse((String)"application/json; charset=utf-8");
    public static final MediaType MEDIA_TYPE_OCTET = MediaType.parse((String)"application/octet-stream; charset=utf-8");
    protected final JDAImpl api;
    protected final AuthorizationConfig authConfig;
    private final RateLimiter rateLimiter;
    private final OkHttpClient httpClient;
    private boolean isContextReady = false;
    private ConcurrentMap<String, String> contextMap = null;
    private volatile boolean retryOnTimeout = false;

    public Requester(JDA api) {
        this(api, ((JDAImpl)api).getAuthorizationConfig());
    }

    public Requester(JDA api, AuthorizationConfig authConfig) {
        if (authConfig == null) {
            throw new NullPointerException("Provided config was null!");
        }
        this.authConfig = authConfig;
        this.api = (JDAImpl)api;
        this.rateLimiter = authConfig.getAccountType() == AccountType.BOT ? new BotRateLimiter(this) : new ClientRateLimiter(this);
        this.httpClient = this.api.getHttpClient();
    }

    public void setContextReady(boolean ready) {
        this.isContextReady = ready;
    }

    public void setContext() {
        if (!this.isContextReady) {
            return;
        }
        if (this.contextMap == null) {
            this.contextMap = this.api.getContextMap();
        }
        this.contextMap.forEach(MDC::put);
    }

    public JDAImpl getJDA() {
        return this.api;
    }

    public <T> void request(net.dv8tion.jda.api.requests.Request<T> apiRequest) {
        if (this.rateLimiter.isShutdown) {
            throw new IllegalStateException("The Requester has been shutdown! No new requests can be requested!");
        }
        if (apiRequest.shouldQueue()) {
            this.rateLimiter.queueRequest(apiRequest);
        } else {
            this.execute(apiRequest, true);
        }
    }

    private static boolean isRetry(Throwable e) {
        return e instanceof SocketException || e instanceof SocketTimeoutException || e instanceof SSLPeerUnverifiedException;
    }

    private void attemptRequest(CompletableFuture<Long> task, Request request, List<Response> responses, Set<String> rays, net.dv8tion.jda.api.requests.Request apiRequest, String url, boolean handleOnRatelimit, boolean timeout, int attempt) {
        Response lastResponse;
        Route.CompiledRoute route = apiRequest.getRoute();
        Response response2 = lastResponse = responses.isEmpty() ? null : responses.get(responses.size() - 1);
        if (apiRequest.isCanceled()) {
            apiRequest.onFailure(new CancellationException("RestAction has been cancelled"));
            task.complete(null);
            return;
        }
        if (attempt >= 4) {
            net.dv8tion.jda.api.requests.Response response3 = new net.dv8tion.jda.api.requests.Response(Objects.requireNonNull(lastResponse), -1L, rays);
            apiRequest.handleResponse(response3);
            task.complete(null);
            return;
        }
        Call call = this.httpClient.newCall(request);
        call.enqueue((Callback)FunctionalCallback.onFailure((c, e) -> {
            if (Requester.isRetry(e)) {
                if (this.retryOnTimeout && !timeout) {
                    this.attemptRequest(task, request, responses, rays, apiRequest, url, true, true, attempt + 1);
                } else {
                    LOG.error("Requester timed out while executing a request", (Throwable)e);
                    apiRequest.handleResponse(new net.dv8tion.jda.api.requests.Response(null, (Exception)e, rays));
                    task.complete(null);
                }
                return;
            }
            LOG.error("There was an exception while executing a REST request", (Throwable)e);
            apiRequest.handleResponse(new net.dv8tion.jda.api.requests.Response(null, (Exception)e, rays));
            task.complete(null);
        }).onSuccess((c, response) -> {
            responses.add((Response)response);
            String cfRay = response.header("CF-RAY");
            if (cfRay != null) {
                rays.add(cfRay);
            }
            if (response.code() >= 500) {
                LOG.debug("Requesting {} -> {} returned status {}... retrying (attempt {})", new Object[]{route.getMethod(), url, response.code(), attempt});
                this.attemptRequest(task, request, responses, rays, apiRequest, url, true, timeout, attempt + 1);
                return;
            }
            Long retryAfter = this.rateLimiter.handleResponse(route, (Response)response);
            if (!rays.isEmpty()) {
                LOG.debug("Received response with following cf-rays: {}", (Object)rays);
            }
            LOG.trace("Finished Request {} {} with code {}", new Object[]{route.getMethod(), response.request().url(), response.code()});
            if (retryAfter == null) {
                apiRequest.handleResponse(new net.dv8tion.jda.api.requests.Response((Response)response, -1L, rays));
            } else if (handleOnRatelimit) {
                apiRequest.handleResponse(new net.dv8tion.jda.api.requests.Response((Response)response, retryAfter, rays));
            }
            task.complete(retryAfter);
        }).build());
    }

    public CompletableFuture<Long> execute(net.dv8tion.jda.api.requests.Request<?> apiRequest) {
        return this.execute(apiRequest, false);
    }

    public CompletableFuture<Long> execute(net.dv8tion.jda.api.requests.Request<?> apiRequest, boolean handleOnRatelimit) {
        Route.CompiledRoute route = apiRequest.getRoute();
        Long retryAfter = this.rateLimiter.getRateLimit(route);
        if (retryAfter != null) {
            if (handleOnRatelimit) {
                apiRequest.handleResponse(new net.dv8tion.jda.api.requests.Response(retryAfter, Collections.emptySet()));
            }
            return CompletableFuture.completedFuture(retryAfter);
        }
        Request.Builder builder = new Request.Builder();
        String url = DISCORD_API_PREFIX + route.getCompiledRoute();
        builder.url(url);
        this.applyBody(apiRequest, builder);
        this.applyHeaders(apiRequest, builder, url.startsWith(DISCORD_API_PREFIX));
        Request request = builder.build();
        LinkedHashSet<String> rays = new LinkedHashSet<String>();
        ArrayList<Response> responses = new ArrayList<Response>(4);
        CompletableFuture<Long> task = new CompletableFuture<Long>();
        task.whenComplete((i1, i2) -> {
            for (Response r : responses) {
                r.close();
            }
        });
        LOG.trace("Executing request {} {}", (Object)apiRequest.getRoute().getMethod(), (Object)url);
        this.attemptRequest(task, request, responses, rays, apiRequest, url, handleOnRatelimit, false, 0);
        return task;
    }

    private void applyBody(net.dv8tion.jda.api.requests.Request<?> apiRequest, Request.Builder builder) {
        String method = apiRequest.getRoute().getMethod().toString();
        RequestBody body = apiRequest.getBody();
        if (body == null && HttpMethod.requiresRequestBody((String)method)) {
            body = EMPTY_BODY;
        }
        builder.method(method, body);
    }

    private void applyHeaders(net.dv8tion.jda.api.requests.Request<?> apiRequest, Request.Builder builder, boolean authorized) {
        builder.header("user-agent", USER_AGENT).header("accept-encoding", "gzip").header("x-ratelimit-precision", "millisecond");
        if (authorized) {
            builder.header("authorization", this.authConfig.getToken());
        }
        if (apiRequest.getHeaders() != null) {
            for (Map.Entry header : apiRequest.getHeaders().entrySet()) {
                builder.addHeader((String)header.getKey(), (String)header.getValue());
            }
        }
    }

    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    public RateLimiter getRateLimiter() {
        return this.rateLimiter;
    }

    public void setRetryOnTimeout(boolean retryOnTimeout) {
        this.retryOnTimeout = retryOnTimeout;
    }

    public void shutdown() {
        this.rateLimiter.shutdown();
    }
}

