/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.entities;

import java.awt.Color;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.OnlineStatus;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.Activity;
import net.dv8tion.jda.api.entities.ClientType;
import net.dv8tion.jda.api.entities.Emote;
import net.dv8tion.jda.api.entities.GuildChannel;
import net.dv8tion.jda.api.entities.GuildVoiceState;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.TextChannel;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.utils.cache.CacheFlag;
import net.dv8tion.jda.internal.JDAImpl;
import net.dv8tion.jda.internal.entities.GuildImpl;
import net.dv8tion.jda.internal.entities.GuildVoiceStateImpl;
import net.dv8tion.jda.internal.utils.Checks;
import net.dv8tion.jda.internal.utils.PermissionUtil;
import net.dv8tion.jda.internal.utils.cache.UpstreamReference;

public class MemberImpl
implements Member {
    private static final ZoneOffset OFFSET = ZoneOffset.of("+00:00");
    private final UpstreamReference<GuildImpl> guild;
    private final User user;
    private final Set<Role> roles = ConcurrentHashMap.newKeySet();
    private final GuildVoiceState voiceState;
    private final Map<ClientType, OnlineStatus> clientStatus;
    private String nickname;
    private long joinDate;
    private long boostDate;
    private List<Activity> activities = null;
    private OnlineStatus onlineStatus = OnlineStatus.OFFLINE;

    public MemberImpl(GuildImpl guild, User user) {
        this.guild = new UpstreamReference<GuildImpl>(guild);
        this.user = user;
        JDAImpl jda = (JDAImpl)this.getJDA();
        boolean cacheState = jda.isCacheFlagSet(CacheFlag.VOICE_STATE) || user.equals(jda.getSelfUser());
        boolean cacheOnline = jda.isCacheFlagSet(CacheFlag.CLIENT_STATUS);
        this.voiceState = cacheState ? new GuildVoiceStateImpl(this) : null;
        this.clientStatus = cacheOnline ? Collections.synchronizedMap(new EnumMap(ClientType.class)) : null;
    }

    @Override
    @Nonnull
    public User getUser() {
        return this.user;
    }

    @Override
    @Nonnull
    public GuildImpl getGuild() {
        return this.guild.get();
    }

    @Override
    @Nonnull
    public JDA getJDA() {
        return this.user.getJDA();
    }

    @Override
    @Nonnull
    public OffsetDateTime getTimeJoined() {
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(this.joinDate), OFFSET);
    }

    @Override
    @Nullable
    public OffsetDateTime getTimeBoosted() {
        return this.boostDate != 0L ? OffsetDateTime.ofInstant(Instant.ofEpochMilli(this.boostDate), OFFSET) : null;
    }

    @Override
    public GuildVoiceState getVoiceState() {
        return this.voiceState;
    }

    @Override
    @Nonnull
    public List<Activity> getActivities() {
        return this.activities == null || this.activities.isEmpty() ? Collections.emptyList() : this.activities;
    }

    @Override
    @Nonnull
    public OnlineStatus getOnlineStatus() {
        return this.onlineStatus;
    }

    @Override
    @Nonnull
    public OnlineStatus getOnlineStatus(@Nonnull ClientType type) {
        Checks.notNull((Object)type, "Type");
        if (this.clientStatus == null || this.clientStatus.isEmpty()) {
            return OnlineStatus.OFFLINE;
        }
        OnlineStatus status = this.clientStatus.get((Object)type);
        return status == null ? OnlineStatus.OFFLINE : status;
    }

    @Override
    @Nonnull
    public EnumSet<ClientType> getActiveClients() {
        if (this.clientStatus == null || this.clientStatus.isEmpty()) {
            return EnumSet.noneOf(ClientType.class);
        }
        return EnumSet.copyOf(this.clientStatus.keySet());
    }

    @Override
    public String getNickname() {
        return this.nickname;
    }

    @Override
    @Nonnull
    public String getEffectiveName() {
        return this.nickname != null ? this.nickname : this.user.getName();
    }

    @Override
    @Nonnull
    public List<Role> getRoles() {
        ArrayList<Role> roleList = new ArrayList<Role>(this.roles);
        roleList.sort(Comparator.reverseOrder());
        return Collections.unmodifiableList(roleList);
    }

    @Override
    public Color getColor() {
        int raw = this.getColorRaw();
        return raw != 0x1FFFFFFF ? new Color(raw) : null;
    }

    @Override
    public int getColorRaw() {
        for (Role r : this.getRoles()) {
            int colorRaw = r.getColorRaw();
            if (colorRaw == 0x1FFFFFFF) continue;
            return colorRaw;
        }
        return 0x1FFFFFFF;
    }

    @Override
    @Nonnull
    public EnumSet<Permission> getPermissions() {
        return Permission.getPermissions(PermissionUtil.getEffectivePermission(this));
    }

    @Override
    @Nonnull
    public EnumSet<Permission> getPermissions(@Nonnull GuildChannel channel) {
        Checks.notNull(channel, "Channel");
        if (!this.getGuild().equals(channel.getGuild())) {
            throw new IllegalArgumentException("Provided channel is not in the same guild as this member!");
        }
        return Permission.getPermissions(PermissionUtil.getEffectivePermission(channel, this));
    }

    @Override
    @Nonnull
    public EnumSet<Permission> getPermissionsExplicit() {
        return Permission.getPermissions(PermissionUtil.getExplicitPermission(this));
    }

    @Override
    @Nonnull
    public EnumSet<Permission> getPermissionsExplicit(@Nonnull GuildChannel channel) {
        return Permission.getPermissions(PermissionUtil.getExplicitPermission(channel, this));
    }

    @Override
    public boolean hasPermission(Permission ... permissions) {
        return PermissionUtil.checkPermission(this, permissions);
    }

    @Override
    public boolean hasPermission(@Nonnull Collection<Permission> permissions) {
        Checks.notNull(permissions, "Permission Collection");
        return this.hasPermission(permissions.toArray(Permission.EMPTY_PERMISSIONS));
    }

    @Override
    public boolean hasPermission(@Nonnull GuildChannel channel, Permission ... permissions) {
        return PermissionUtil.checkPermission(channel, this, permissions);
    }

    @Override
    public boolean hasPermission(@Nonnull GuildChannel channel, @Nonnull Collection<Permission> permissions) {
        Checks.notNull(permissions, "Permission Collection");
        return this.hasPermission(channel, permissions.toArray(Permission.EMPTY_PERMISSIONS));
    }

    @Override
    public boolean canInteract(@Nonnull Member member) {
        return PermissionUtil.canInteract((Member)this, member);
    }

    @Override
    public boolean canInteract(@Nonnull Role role) {
        return PermissionUtil.canInteract((Member)this, role);
    }

    @Override
    public boolean canInteract(@Nonnull Emote emote) {
        return PermissionUtil.canInteract((Member)this, emote);
    }

    @Override
    public boolean isOwner() {
        return this.user.getIdLong() == this.getGuild().getOwnerIdLong();
    }

    @Override
    public boolean isFake() {
        return this.getGuild().getMemberById(this.getIdLong()) == null;
    }

    @Override
    public long getIdLong() {
        return this.user.getIdLong();
    }

    public MemberImpl setNickname(String nickname) {
        this.nickname = nickname;
        return this;
    }

    public MemberImpl setJoinDate(long joinDate) {
        this.joinDate = joinDate;
        return this;
    }

    public MemberImpl setBoostDate(long boostDate) {
        this.boostDate = boostDate;
        return this;
    }

    public MemberImpl setActivities(List<Activity> activities) {
        this.activities = Collections.unmodifiableList(activities);
        return this;
    }

    public MemberImpl setOnlineStatus(ClientType type, OnlineStatus status) {
        if (this.clientStatus == null || type == ClientType.UNKNOWN || type == null) {
            return this;
        }
        if (status == null || status == OnlineStatus.UNKNOWN || status == OnlineStatus.OFFLINE) {
            this.clientStatus.remove((Object)type);
        } else {
            this.clientStatus.put(type, status);
        }
        return this;
    }

    public MemberImpl setOnlineStatus(OnlineStatus onlineStatus) {
        this.onlineStatus = onlineStatus;
        return this;
    }

    public Set<Role> getRoleSet() {
        return this.roles;
    }

    public long getBoostDateRaw() {
        return this.boostDate;
    }

    public boolean isIncomplete() {
        return !this.isOwner() && Objects.equals(this.getGuild().getTimeCreated(), this.getTimeJoined());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Member)) {
            return false;
        }
        Member oMember = (Member)o;
        return oMember.getUser().equals(this.user) && oMember.getGuild().equals(this.getGuild());
    }

    public int hashCode() {
        return (this.getGuild().getId() + this.user.getId()).hashCode();
    }

    public String toString() {
        return "MB:" + this.getEffectiveName() + '(' + this.user.toString() + " / " + this.getGuild().toString() + ')';
    }

    @Override
    @Nonnull
    public String getAsMention() {
        return this.nickname == null ? this.user.getAsMention() : "<@!" + this.user.getIdLong() + '>';
    }

    @Override
    @Nullable
    public TextChannel getDefaultChannel() {
        return this.getGuild().getTextChannelsView().stream().sorted(Comparator.reverseOrder()).filter(c -> this.hasPermission((GuildChannel)c, Permission.MESSAGE_READ)).findFirst().orElse(null);
    }
}

