/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.handle;

import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.Emote;
import net.dv8tion.jda.api.entities.MessageChannel;
import net.dv8tion.jda.api.entities.MessageReaction;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.events.message.guild.react.GuildMessageReactionAddEvent;
import net.dv8tion.jda.api.events.message.guild.react.GuildMessageReactionRemoveEvent;
import net.dv8tion.jda.api.events.message.priv.react.PrivateMessageReactionAddEvent;
import net.dv8tion.jda.api.events.message.priv.react.PrivateMessageReactionRemoveEvent;
import net.dv8tion.jda.api.events.message.react.MessageReactionAddEvent;
import net.dv8tion.jda.api.events.message.react.MessageReactionRemoveEvent;
import net.dv8tion.jda.api.hooks.IEventManager;
import net.dv8tion.jda.api.utils.data.DataObject;
import net.dv8tion.jda.internal.JDAImpl;
import net.dv8tion.jda.internal.entities.EmoteImpl;
import net.dv8tion.jda.internal.handle.EventCache;
import net.dv8tion.jda.internal.handle.SocketHandler;
import net.dv8tion.jda.internal.requests.WebSocketClient;
import net.dv8tion.jda.internal.utils.JDALogger;

public class MessageReactionHandler
extends SocketHandler {
    private final boolean add;

    public MessageReactionHandler(JDAImpl api, boolean add) {
        super(api);
        this.add = add;
    }

    @Override
    protected Long handleInternally(DataObject content) {
        MessageReaction.ReactionEmote rEmote;
        if (!content.isNull("guild_id")) {
            long guildId = content.getLong("guild_id");
            if (this.getJDA().getGuildSetupController().isLocked(guildId)) {
                return guildId;
            }
        }
        DataObject emoji = content.getObject("emoji");
        long userId = content.getLong("user_id");
        long messageId = content.getLong("message_id");
        long channelId = content.getLong("channel_id");
        Long emojiId = emoji.isNull("id") ? null : Long.valueOf(emoji.getLong("id"));
        String emojiName = emoji.getString("name", null);
        boolean emojiAnimated = emoji.getBoolean("animated");
        if (emojiId == null && emojiName == null) {
            WebSocketClient.LOG.debug("Received a reaction {} with no name nor id. json: {}", JDALogger.getLazyString(() -> this.add ? "add" : "remove"), (Object)content);
            return null;
        }
        User user = this.getJDA().getUserById(userId);
        if (user == null) {
            user = this.getJDA().getFakeUserMap().get(userId);
        }
        if (user == null) {
            if (!this.add) {
                return null;
            }
            this.getJDA().getEventCache().cache(EventCache.Type.USER, userId, this.responseNumber, this.allContent, this::handle);
            EventCache.LOG.debug("Received a reaction for a user that JDA does not currently have cached. UserID: {} ChannelId: {} MessageId: {}", userId, channelId, messageId);
            return null;
        }
        MessageChannel channel = this.getJDA().getTextChannelById(channelId);
        if (channel == null) {
            channel = this.getJDA().getPrivateChannelById(channelId);
        }
        if (channel == null) {
            channel = this.getJDA().getFakePrivateChannelMap().get(channelId);
        }
        if (channel == null) {
            this.getJDA().getEventCache().cache(EventCache.Type.CHANNEL, channelId, this.responseNumber, this.allContent, this::handle);
            EventCache.LOG.debug("Received a reaction for a channel that JDA does not currently have cached");
            return null;
        }
        if (emojiId != null) {
            Emote emote = this.getJDA().getEmoteById(emojiId);
            if (emote == null) {
                if (emojiName != null) {
                    emote = new EmoteImpl((long)emojiId, this.getJDA()).setAnimated(emojiAnimated).setName(emojiName);
                } else {
                    WebSocketClient.LOG.debug("Received a reaction {} with a null name. json: {}", JDALogger.getLazyString(() -> this.add ? "add" : "remove"), (Object)content);
                    return null;
                }
            }
            rEmote = MessageReaction.ReactionEmote.fromCustom(emote);
        } else {
            rEmote = MessageReaction.ReactionEmote.fromUnicode(emojiName, this.getJDA());
        }
        MessageReaction reaction = new MessageReaction(channel, rEmote, messageId, user.equals(this.getJDA().getSelfUser()), -1);
        if (this.add) {
            this.onAdd(reaction, user);
        } else {
            this.onRemove(reaction, user);
        }
        return null;
    }

    private void onAdd(MessageReaction reaction, User user) {
        IEventManager manager = this.getJDA().getEventManager();
        switch (reaction.getChannelType()) {
            case TEXT: {
                manager.handle(new GuildMessageReactionAddEvent((JDA)this.getJDA(), this.responseNumber, user, reaction));
                break;
            }
            case PRIVATE: {
                manager.handle(new PrivateMessageReactionAddEvent((JDA)this.getJDA(), this.responseNumber, user, reaction));
                break;
            }
            case GROUP: {
                WebSocketClient.LOG.error("Received a reaction add for a group which should not be possible");
                return;
            }
        }
        manager.handle(new MessageReactionAddEvent((JDA)this.getJDA(), this.responseNumber, user, reaction));
    }

    private void onRemove(MessageReaction reaction, User user) {
        IEventManager manager = this.getJDA().getEventManager();
        switch (reaction.getChannelType()) {
            case TEXT: {
                manager.handle(new GuildMessageReactionRemoveEvent((JDA)this.getJDA(), this.responseNumber, user, reaction));
                break;
            }
            case PRIVATE: {
                manager.handle(new PrivateMessageReactionRemoveEvent((JDA)this.getJDA(), this.responseNumber, user, reaction));
                break;
            }
            case GROUP: {
                WebSocketClient.LOG.error("Received a reaction add for a group which should not be possible");
                return;
            }
        }
        manager.handle(new MessageReactionRemoveEvent((JDA)this.getJDA(), this.responseNumber, user, reaction));
    }
}

