/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.handle;

import java.util.LinkedList;
import net.dv8tion.jda.api.entities.TextChannel;
import net.dv8tion.jda.api.events.message.MessageBulkDeleteEvent;
import net.dv8tion.jda.api.utils.data.DataObject;
import net.dv8tion.jda.internal.JDAImpl;
import net.dv8tion.jda.internal.handle.EventCache;
import net.dv8tion.jda.internal.handle.SocketHandler;

public class MessageBulkDeleteHandler
extends SocketHandler {
    public MessageBulkDeleteHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(DataObject content) {
        if (!content.isNull("guild_id")) {
            long guildId = content.getLong("guild_id");
            if (this.getJDA().getGuildSetupController().isLocked(guildId)) {
                return guildId;
            }
        }
        long channelId = content.getLong("channel_id");
        if (this.getJDA().isBulkDeleteSplittingEnabled()) {
            SocketHandler handler = this.getJDA().getClient().getHandlers().get("MESSAGE_DELETE");
            content.getArray("ids").forEach(id -> handler.handle(this.responseNumber, DataObject.empty().put("t", "MESSAGE_DELETE").put("d", DataObject.empty().put("channel_id", Long.toUnsignedString(channelId)).put("id", id))));
        } else {
            TextChannel channel = this.getJDA().getTextChannelById(channelId);
            if (channel == null) {
                this.getJDA().getEventCache().cache(EventCache.Type.CHANNEL, channelId, this.responseNumber, this.allContent, this::handle);
                EventCache.LOG.debug("Received a Bulk Message Delete for a TextChannel that is not yet cached.");
                return null;
            }
            if (this.getJDA().getGuildSetupController().isLocked(channel.getGuild().getIdLong())) {
                return channel.getGuild().getIdLong();
            }
            LinkedList<String> msgIds = new LinkedList<String>();
            content.getArray("ids").forEach(id -> msgIds.add((String)id));
            this.getJDA().getEventManager().handle(new MessageBulkDeleteEvent(this.getJDA(), this.responseNumber, channel, msgIds));
        }
        return null;
    }
}

