/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.utils;

import java.util.Collection;
import net.dv8tion.jda.internal.utils.Helpers;

public class Checks {
    public static void isSnowflake(String snowflake) {
        Checks.isSnowflake(snowflake, snowflake);
    }

    public static void isSnowflake(String snowflake, String message) {
        Checks.notNull(snowflake, message);
        if (snowflake.length() > 20 || !Helpers.isNumeric(snowflake)) {
            throw new IllegalArgumentException(message + " is not a valid snowflake value!");
        }
    }

    public static void check(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void check(boolean expression, String message, Object ... args) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(message, args));
        }
    }

    public static void check(boolean expression, String message, Object arg) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(message, arg));
        }
    }

    public static void notNull(Object argument, String name) {
        if (argument == null) {
            throw new IllegalArgumentException(name + " may not be null");
        }
    }

    public static void notEmpty(CharSequence argument, String name) {
        Checks.notNull(argument, name);
        if (Helpers.isEmpty(argument)) {
            throw new IllegalArgumentException(name + " may not be empty");
        }
    }

    public static void notBlank(CharSequence argument, String name) {
        Checks.notNull(argument, name);
        if (Helpers.isBlank(argument)) {
            throw new IllegalArgumentException(name + " may not be blank");
        }
    }

    public static void noWhitespace(CharSequence argument, String name) {
        Checks.notNull(argument, name);
        if (Helpers.containsWhitespace(argument)) {
            throw new IllegalArgumentException(name + " may not contain blanks");
        }
    }

    public static void notEmpty(Collection<?> argument, String name) {
        Checks.notNull(argument, name);
        if (argument.isEmpty()) {
            throw new IllegalArgumentException(name + " may not be empty");
        }
    }

    public static void notEmpty(Object[] argument, String name) {
        Checks.notNull(argument, name);
        if (argument.length == 0) {
            throw new IllegalArgumentException(name + " may not be empty");
        }
    }

    public static void noneNull(Collection<?> argument, String name) {
        Checks.notNull(argument, name);
        argument.forEach(it -> Checks.notNull(it, name));
    }

    public static void noneNull(Object[] argument, String name) {
        Checks.notNull(argument, name);
        for (Object it : argument) {
            Checks.notNull(it, name);
        }
    }

    public static <T extends CharSequence> void noneEmpty(Collection<T> argument, String name) {
        Checks.notNull(argument, name);
        argument.forEach(it -> Checks.notEmpty(it, name));
    }

    public static <T extends CharSequence> void noneBlank(Collection<T> argument, String name) {
        Checks.notNull(argument, name);
        argument.forEach(it -> Checks.notBlank(it, name));
    }

    public static <T extends CharSequence> void noneContainBlanks(Collection<T> argument, String name) {
        Checks.notNull(argument, name);
        argument.forEach(it -> Checks.noWhitespace(it, name));
    }

    public static void positive(int n, String name) {
        if (n <= 0) {
            throw new IllegalArgumentException(name + " may not be negative or zero");
        }
    }

    public static void positive(long n, String name) {
        if (n <= 0L) {
            throw new IllegalArgumentException(name + " may not be negative or zero");
        }
    }

    public static void notNegative(int n, String name) {
        if (n < 0) {
            throw new IllegalArgumentException(name + " may not be negative");
        }
    }

    public static void notNegative(long n, String name) {
        if (n < 0L) {
            throw new IllegalArgumentException(name + " may not be negative");
        }
    }
}

