/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.sharding;

import com.neovisionaries.ws.client.WebSocketFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.login.LoginException;
import net.dv8tion.jda.annotations.DeprecatedSince;
import net.dv8tion.jda.annotations.ReplaceWith;
import net.dv8tion.jda.api.OnlineStatus;
import net.dv8tion.jda.api.audio.factory.IAudioSendFactory;
import net.dv8tion.jda.api.entities.Activity;
import net.dv8tion.jda.api.hooks.IEventManager;
import net.dv8tion.jda.api.hooks.VoiceDispatchInterceptor;
import net.dv8tion.jda.api.sharding.DefaultShardManager;
import net.dv8tion.jda.api.sharding.ShardManager;
import net.dv8tion.jda.api.sharding.ThreadPoolProvider;
import net.dv8tion.jda.api.utils.Compression;
import net.dv8tion.jda.api.utils.SessionController;
import net.dv8tion.jda.api.utils.cache.CacheFlag;
import net.dv8tion.jda.internal.utils.Checks;
import net.dv8tion.jda.internal.utils.config.flags.ConfigFlag;
import net.dv8tion.jda.internal.utils.config.flags.ShardingConfigFlag;
import net.dv8tion.jda.internal.utils.config.sharding.EventConfig;
import net.dv8tion.jda.internal.utils.config.sharding.PresenceProviderConfig;
import net.dv8tion.jda.internal.utils.config.sharding.ShardingConfig;
import net.dv8tion.jda.internal.utils.config.sharding.ShardingMetaConfig;
import net.dv8tion.jda.internal.utils.config.sharding.ShardingSessionConfig;
import net.dv8tion.jda.internal.utils.config.sharding.ThreadingProviderConfig;
import okhttp3.OkHttpClient;

public class DefaultShardManagerBuilder {
    protected final List<Object> listeners = new ArrayList<Object>();
    protected final List<IntFunction<Object>> listenerProviders = new ArrayList<IntFunction<Object>>();
    protected SessionController sessionController = null;
    protected VoiceDispatchInterceptor voiceDispatchInterceptor = null;
    protected EnumSet<CacheFlag> cacheFlags = EnumSet.allOf(CacheFlag.class);
    protected EnumSet<ConfigFlag> flags = ConfigFlag.getDefault();
    protected EnumSet<ShardingConfigFlag> shardingFlags = ShardingConfigFlag.getDefault();
    protected Compression compression = Compression.ZLIB;
    protected int shardsTotal = -1;
    protected int maxReconnectDelay = 900;
    protected String token = null;
    protected IntFunction<Boolean> idleProvider = null;
    protected IntFunction<OnlineStatus> statusProvider = null;
    protected IntFunction<? extends Activity> activityProvider = null;
    protected IntFunction<? extends ConcurrentMap<String, String>> contextProvider = null;
    protected IntFunction<? extends IEventManager> eventManagerProvider = null;
    protected ThreadPoolProvider<? extends ScheduledExecutorService> rateLimitPoolProvider = null;
    protected ThreadPoolProvider<? extends ScheduledExecutorService> gatewayPoolProvider = null;
    protected ThreadPoolProvider<? extends ExecutorService> callbackPoolProvider = null;
    protected Collection<Integer> shards = null;
    protected OkHttpClient.Builder httpClientBuilder = null;
    protected OkHttpClient httpClient = null;
    protected WebSocketFactory wsFactory = null;
    protected IAudioSendFactory audioSendFactory = null;
    protected ThreadFactory threadFactory = null;

    public DefaultShardManagerBuilder() {
    }

    public DefaultShardManagerBuilder(@Nonnull String token) {
        this.setToken(token);
    }

    @Nonnull
    public DefaultShardManagerBuilder setRawEventsEnabled(boolean enable) {
        return this.setFlag(ConfigFlag.RAW_EVENTS, enable);
    }

    @Nonnull
    public DefaultShardManagerBuilder setEnabledCacheFlags(@Nullable EnumSet<CacheFlag> flags) {
        this.cacheFlags = flags == null ? EnumSet.noneOf(CacheFlag.class) : EnumSet.copyOf(flags);
        return this;
    }

    @Nonnull
    public DefaultShardManagerBuilder setDisabledCacheFlags(@Nullable EnumSet<CacheFlag> flags) {
        return this.setEnabledCacheFlags(flags == null ? EnumSet.allOf(CacheFlag.class) : EnumSet.complementOf(flags));
    }

    @Nonnull
    public DefaultShardManagerBuilder setSessionController(@Nullable SessionController controller) {
        this.sessionController = controller;
        return this;
    }

    @Nonnull
    public DefaultShardManagerBuilder setVoiceDispatchInterceptor(@Nullable VoiceDispatchInterceptor interceptor) {
        this.voiceDispatchInterceptor = interceptor;
        return this;
    }

    @Nonnull
    public DefaultShardManagerBuilder setContextMap(@Nullable IntFunction<? extends ConcurrentMap<String, String>> provider) {
        this.contextProvider = provider;
        if (provider != null) {
            this.setContextEnabled(true);
        }
        return this;
    }

    @Nonnull
    public DefaultShardManagerBuilder setContextEnabled(boolean enable) {
        return this.setFlag(ConfigFlag.MDC_CONTEXT, enable);
    }

    @Nonnull
    public DefaultShardManagerBuilder setCompression(@Nonnull Compression compression) {
        Checks.notNull((Object)compression, "Compression");
        this.compression = compression;
        return this;
    }

    @Nonnull
    public DefaultShardManagerBuilder addEventListeners(Object ... listeners) {
        return this.addEventListeners(Arrays.asList(listeners));
    }

    @Nonnull
    public DefaultShardManagerBuilder addEventListeners(@Nonnull Collection<Object> listeners) {
        Checks.noneNull(listeners, "listeners");
        this.listeners.addAll(listeners);
        return this;
    }

    @Nonnull
    public DefaultShardManagerBuilder removeEventListeners(Object ... listeners) {
        return this.removeEventListeners(Arrays.asList(listeners));
    }

    @Nonnull
    public DefaultShardManagerBuilder removeEventListeners(@Nonnull Collection<Object> listeners) {
        Checks.noneNull(listeners, "listeners");
        this.listeners.removeAll(listeners);
        return this;
    }

    @Nonnull
    public DefaultShardManagerBuilder addEventListenerProvider(@Nonnull IntFunction<Object> listenerProvider) {
        return this.addEventListenerProviders(Collections.singleton(listenerProvider));
    }

    @Nonnull
    public DefaultShardManagerBuilder addEventListenerProviders(@Nonnull Collection<IntFunction<Object>> listenerProviders) {
        Checks.noneNull(listenerProviders, "listener providers");
        this.listenerProviders.addAll(listenerProviders);
        return this;
    }

    @Nonnull
    public DefaultShardManagerBuilder removeEventListenerProvider(@Nonnull IntFunction<Object> listenerProvider) {
        return this.removeEventListenerProviders(Collections.singleton(listenerProvider));
    }

    @Nonnull
    public DefaultShardManagerBuilder removeEventListenerProviders(@Nonnull Collection<IntFunction<Object>> listenerProviders) {
        Checks.noneNull(listenerProviders, "listener providers");
        this.listenerProviders.removeAll(listenerProviders);
        return this;
    }

    @Nonnull
    public DefaultShardManagerBuilder setAudioSendFactory(@Nullable IAudioSendFactory factory) {
        this.audioSendFactory = factory;
        return this;
    }

    @Nonnull
    public DefaultShardManagerBuilder setAutoReconnect(boolean autoReconnect) {
        return this.setFlag(ConfigFlag.AUTO_RECONNECT, autoReconnect);
    }

    @Nonnull
    public DefaultShardManagerBuilder setBulkDeleteSplittingEnabled(boolean enabled) {
        return this.setFlag(ConfigFlag.BULK_DELETE_SPLIT, enabled);
    }

    @Nonnull
    public DefaultShardManagerBuilder setEnableShutdownHook(boolean enable) {
        return this.setFlag(ConfigFlag.SHUTDOWN_HOOK, enable);
    }

    @Nonnull
    @Deprecated
    @DeprecatedSince(value="3.8.1")
    @ReplaceWith(value="setEventManagerProvider((id) -> manager)")
    public DefaultShardManagerBuilder setEventManager(@Nonnull IEventManager manager) {
        Checks.notNull(manager, "manager");
        return this.setEventManagerProvider(id -> manager);
    }

    @Nonnull
    public DefaultShardManagerBuilder setEventManagerProvider(@Nonnull IntFunction<? extends IEventManager> eventManagerProvider) {
        Checks.notNull(eventManagerProvider, "eventManagerProvider");
        this.eventManagerProvider = eventManagerProvider;
        return this;
    }

    @Nonnull
    public DefaultShardManagerBuilder setActivity(@Nullable Activity game) {
        return this.setActivityProvider(id -> game);
    }

    @Nonnull
    public DefaultShardManagerBuilder setActivityProvider(@Nullable IntFunction<? extends Activity> gameProvider) {
        this.activityProvider = gameProvider;
        return this;
    }

    @Nonnull
    public DefaultShardManagerBuilder setIdle(boolean idle) {
        return this.setIdleProvider(id -> idle);
    }

    @Nonnull
    public DefaultShardManagerBuilder setIdleProvider(@Nullable IntFunction<Boolean> idleProvider) {
        this.idleProvider = idleProvider;
        return this;
    }

    @Nonnull
    public DefaultShardManagerBuilder setStatus(@Nullable OnlineStatus status) {
        Checks.notNull((Object)status, "status");
        Checks.check(status != OnlineStatus.UNKNOWN, "OnlineStatus cannot be unknown!");
        return this.setStatusProvider(id -> status);
    }

    @Nonnull
    public DefaultShardManagerBuilder setStatusProvider(@Nullable IntFunction<OnlineStatus> statusProvider) {
        this.statusProvider = statusProvider;
        return this;
    }

    @Nonnull
    public DefaultShardManagerBuilder setThreadFactory(@Nullable ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
        return this;
    }

    @Nonnull
    public DefaultShardManagerBuilder setHttpClientBuilder(@Nullable OkHttpClient.Builder builder) {
        this.httpClientBuilder = builder;
        return this;
    }

    @Nonnull
    public DefaultShardManagerBuilder setHttpClient(@Nullable OkHttpClient client) {
        this.httpClient = client;
        return this;
    }

    @Nonnull
    public DefaultShardManagerBuilder setRateLimitPool(@Nullable ScheduledExecutorService pool) {
        return this.setRateLimitPool(pool, pool == null);
    }

    @Nonnull
    public DefaultShardManagerBuilder setRateLimitPool(@Nullable ScheduledExecutorService pool, boolean automaticShutdown) {
        return this.setRateLimitPoolProvider((ThreadPoolProvider<? extends ScheduledExecutorService>)(pool == null ? null : new ThreadPoolProviderImpl<ScheduledExecutorService>(pool, automaticShutdown)));
    }

    @Nonnull
    public DefaultShardManagerBuilder setRateLimitPoolProvider(@Nullable ThreadPoolProvider<? extends ScheduledExecutorService> provider) {
        this.rateLimitPoolProvider = provider;
        return this;
    }

    @Nonnull
    public DefaultShardManagerBuilder setGatewayPool(@Nullable ScheduledExecutorService pool) {
        return this.setGatewayPool(pool, pool == null);
    }

    @Nonnull
    public DefaultShardManagerBuilder setGatewayPool(@Nullable ScheduledExecutorService pool, boolean automaticShutdown) {
        return this.setGatewayPoolProvider((ThreadPoolProvider<? extends ScheduledExecutorService>)(pool == null ? null : new ThreadPoolProviderImpl<ScheduledExecutorService>(pool, automaticShutdown)));
    }

    @Nonnull
    public DefaultShardManagerBuilder setGatewayPoolProvider(@Nullable ThreadPoolProvider<? extends ScheduledExecutorService> provider) {
        this.gatewayPoolProvider = provider;
        return this;
    }

    @Nonnull
    public DefaultShardManagerBuilder setCallbackPool(@Nullable ExecutorService executor) {
        return this.setCallbackPool(executor, executor == null);
    }

    @Nonnull
    public DefaultShardManagerBuilder setCallbackPool(@Nullable ExecutorService executor, boolean automaticShutdown) {
        return this.setCallbackPoolProvider((ThreadPoolProvider<? extends ExecutorService>)(executor == null ? null : new ThreadPoolProviderImpl<ExecutorService>(executor, automaticShutdown)));
    }

    @Nonnull
    public DefaultShardManagerBuilder setCallbackPoolProvider(@Nullable ThreadPoolProvider<? extends ExecutorService> provider) {
        this.callbackPoolProvider = provider;
        return this;
    }

    @Nonnull
    public DefaultShardManagerBuilder setMaxReconnectDelay(int maxReconnectDelay) {
        Checks.check(maxReconnectDelay >= 32, "Max reconnect delay must be 32 seconds or greater. You provided %d.", (Object)maxReconnectDelay);
        this.maxReconnectDelay = maxReconnectDelay;
        return this;
    }

    @Nonnull
    public DefaultShardManagerBuilder setRequestTimeoutRetry(boolean retryOnTimeout) {
        return this.setFlag(ConfigFlag.RETRY_TIMEOUT, retryOnTimeout);
    }

    @Nonnull
    public DefaultShardManagerBuilder setShards(int ... shardIds) {
        Checks.notNull(shardIds, "shardIds");
        for (int id : shardIds) {
            Checks.notNegative(id, "minShardId");
            Checks.check(id < this.shardsTotal, "maxShardId must be lower than shardsTotal");
        }
        this.shards = Arrays.stream(shardIds).boxed().collect(Collectors.toSet());
        return this;
    }

    @Nonnull
    public DefaultShardManagerBuilder setShards(int minShardId, int maxShardId) {
        Checks.notNegative(minShardId, "minShardId");
        Checks.check(maxShardId < this.shardsTotal, "maxShardId must be lower than shardsTotal");
        Checks.check(minShardId <= maxShardId, "minShardId must be lower than or equal to maxShardId");
        ArrayList<Integer> shards = new ArrayList<Integer>(maxShardId - minShardId + 1);
        for (int i = minShardId; i <= maxShardId; ++i) {
            shards.add(i);
        }
        this.shards = shards;
        return this;
    }

    @Nonnull
    public DefaultShardManagerBuilder setShards(@Nonnull Collection<Integer> shardIds) {
        Checks.notNull(shardIds, "shardIds");
        for (Integer id : shardIds) {
            Checks.notNegative(id, "minShardId");
            Checks.check(id < this.shardsTotal, "maxShardId must be lower than shardsTotal");
        }
        this.shards = new ArrayList<Integer>(shardIds);
        return this;
    }

    @Nonnull
    public DefaultShardManagerBuilder setShardsTotal(int shardsTotal) {
        Checks.check(shardsTotal == -1 || shardsTotal > 0, "shardsTotal must either be -1 or greater than 0");
        this.shardsTotal = shardsTotal;
        return this;
    }

    @Nonnull
    public DefaultShardManagerBuilder setToken(@Nonnull String token) {
        Checks.notBlank(token, "token");
        this.token = token;
        return this;
    }

    @Nonnull
    public DefaultShardManagerBuilder setUseShutdownNow(boolean useShutdownNow) {
        return this.setFlag(ShardingConfigFlag.SHUTDOWN_NOW, useShutdownNow);
    }

    @Nonnull
    public DefaultShardManagerBuilder setWebsocketFactory(@Nullable WebSocketFactory factory) {
        this.wsFactory = factory;
        return this;
    }

    @Nonnull
    public ShardManager build() throws LoginException, IllegalArgumentException {
        boolean useShutdownNow = this.shardingFlags.contains((Object)ShardingConfigFlag.SHUTDOWN_NOW);
        ShardingConfig shardingConfig = new ShardingConfig(this.shardsTotal, useShutdownNow);
        EventConfig eventConfig = new EventConfig(this.eventManagerProvider);
        this.listeners.forEach(eventConfig::addEventListener);
        this.listenerProviders.forEach(eventConfig::addEventListenerProvider);
        PresenceProviderConfig presenceConfig = new PresenceProviderConfig();
        presenceConfig.setActivityProvider(this.activityProvider);
        presenceConfig.setStatusProvider(this.statusProvider);
        presenceConfig.setIdleProvider(this.idleProvider);
        ThreadingProviderConfig threadingConfig = new ThreadingProviderConfig(this.rateLimitPoolProvider, this.gatewayPoolProvider, this.callbackPoolProvider, this.threadFactory);
        ShardingSessionConfig sessionConfig = new ShardingSessionConfig(this.sessionController, this.voiceDispatchInterceptor, this.httpClient, this.httpClientBuilder, this.wsFactory, this.audioSendFactory, this.flags, this.shardingFlags, this.maxReconnectDelay);
        ShardingMetaConfig metaConfig = new ShardingMetaConfig(this.contextProvider, this.cacheFlags, this.flags, this.compression);
        DefaultShardManager manager = new DefaultShardManager(this.token, this.shards, shardingConfig, eventConfig, presenceConfig, threadingConfig, sessionConfig, metaConfig);
        manager.login();
        return manager;
    }

    private DefaultShardManagerBuilder setFlag(ConfigFlag flag, boolean enable) {
        if (enable) {
            this.flags.add(flag);
        } else {
            this.flags.remove((Object)flag);
        }
        return this;
    }

    private DefaultShardManagerBuilder setFlag(ShardingConfigFlag flag, boolean enable) {
        if (enable) {
            this.shardingFlags.add(flag);
        } else {
            this.shardingFlags.remove((Object)flag);
        }
        return this;
    }

    private static class ThreadPoolProviderImpl<T extends ExecutorService>
    implements ThreadPoolProvider<T> {
        private final boolean autoShutdown;
        private final T pool;

        public ThreadPoolProviderImpl(T pool, boolean autoShutdown) {
            this.autoShutdown = autoShutdown;
            this.pool = pool;
        }

        @Override
        public T provide(int shardId) {
            return this.pool;
        }

        @Override
        public boolean shouldShutdownAutomatically(int shardId) {
            return this.autoShutdown;
        }
    }
}

