/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api;

import com.neovisionaries.ws.client.WebSocketFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.login.LoginException;
import net.dv8tion.jda.annotations.Incubating;
import net.dv8tion.jda.api.AccountType;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.OnlineStatus;
import net.dv8tion.jda.api.audio.factory.IAudioSendFactory;
import net.dv8tion.jda.api.entities.Activity;
import net.dv8tion.jda.api.exceptions.AccountTypeException;
import net.dv8tion.jda.api.hooks.IEventManager;
import net.dv8tion.jda.api.hooks.VoiceDispatchInterceptor;
import net.dv8tion.jda.api.utils.Compression;
import net.dv8tion.jda.api.utils.SessionController;
import net.dv8tion.jda.api.utils.SessionControllerAdapter;
import net.dv8tion.jda.api.utils.cache.CacheFlag;
import net.dv8tion.jda.internal.JDAImpl;
import net.dv8tion.jda.internal.managers.PresenceImpl;
import net.dv8tion.jda.internal.utils.Checks;
import net.dv8tion.jda.internal.utils.config.AuthorizationConfig;
import net.dv8tion.jda.internal.utils.config.MetaConfig;
import net.dv8tion.jda.internal.utils.config.SessionConfig;
import net.dv8tion.jda.internal.utils.config.ThreadingConfig;
import net.dv8tion.jda.internal.utils.config.flags.ConfigFlag;
import okhttp3.OkHttpClient;

public class JDABuilder {
    protected final List<Object> listeners;
    protected final AccountType accountType;
    protected ScheduledExecutorService rateLimitPool = null;
    protected boolean shutdownRateLimitPool = true;
    protected ScheduledExecutorService mainWsPool = null;
    protected boolean shutdownMainWsPool = true;
    protected ExecutorService callbackPool = null;
    protected boolean shutdownCallbackPool = true;
    protected EnumSet<CacheFlag> cacheFlags = EnumSet.allOf(CacheFlag.class);
    protected ConcurrentMap<String, String> contextMap = null;
    protected SessionController controller = null;
    protected VoiceDispatchInterceptor voiceDispatchInterceptor = null;
    protected OkHttpClient.Builder httpClientBuilder = null;
    protected OkHttpClient httpClient = null;
    protected WebSocketFactory wsFactory = null;
    protected String token = null;
    protected IEventManager eventManager = null;
    protected IAudioSendFactory audioSendFactory = null;
    protected JDA.ShardInfo shardInfo = null;
    protected Compression compression = Compression.ZLIB;
    protected Activity activity = null;
    protected OnlineStatus status = OnlineStatus.ONLINE;
    protected boolean idle = false;
    protected int maxReconnectDelay = 900;
    protected EnumSet<ConfigFlag> flags = ConfigFlag.getDefault();

    public JDABuilder() {
        this(AccountType.BOT);
    }

    public JDABuilder(@Nullable String token) {
        this();
        this.setToken(token);
    }

    @Incubating
    public JDABuilder(@Nonnull AccountType accountType) {
        Checks.notNull((Object)accountType, "accountType");
        this.accountType = accountType;
        this.listeners = new LinkedList<Object>();
    }

    @Nonnull
    public JDABuilder setRawEventsEnabled(boolean enable) {
        return this.setFlag(ConfigFlag.RAW_EVENTS, enable);
    }

    @Nonnull
    public JDABuilder setEnabledCacheFlags(@Nullable EnumSet<CacheFlag> flags) {
        this.cacheFlags = flags == null ? EnumSet.noneOf(CacheFlag.class) : EnumSet.copyOf(flags);
        return this;
    }

    @Nonnull
    public JDABuilder setDisabledCacheFlags(@Nullable EnumSet<CacheFlag> flags) {
        return this.setEnabledCacheFlags(flags == null ? EnumSet.allOf(CacheFlag.class) : EnumSet.complementOf(flags));
    }

    @Nonnull
    public JDABuilder setContextMap(@Nullable ConcurrentMap<String, String> map) {
        this.contextMap = map;
        if (map != null) {
            this.setContextEnabled(true);
        }
        return this;
    }

    @Nonnull
    public JDABuilder setContextEnabled(boolean enable) {
        return this.setFlag(ConfigFlag.MDC_CONTEXT, enable);
    }

    @Nonnull
    public JDABuilder setCompression(@Nonnull Compression compression) {
        Checks.notNull((Object)compression, "Compression");
        this.compression = compression;
        return this;
    }

    @Nonnull
    public JDABuilder setRequestTimeoutRetry(boolean retryOnTimeout) {
        return this.setFlag(ConfigFlag.RETRY_TIMEOUT, retryOnTimeout);
    }

    @Nonnull
    public JDABuilder setToken(@Nullable String token) {
        this.token = token;
        return this;
    }

    @Nonnull
    public JDABuilder setHttpClientBuilder(@Nullable OkHttpClient.Builder builder) {
        this.httpClientBuilder = builder;
        return this;
    }

    @Nonnull
    public JDABuilder setHttpClient(@Nullable OkHttpClient client) {
        this.httpClient = client;
        return this;
    }

    @Nonnull
    public JDABuilder setWebsocketFactory(@Nullable WebSocketFactory factory) {
        this.wsFactory = factory;
        return this;
    }

    @Nonnull
    public JDABuilder setRateLimitPool(@Nullable ScheduledExecutorService pool) {
        return this.setRateLimitPool(pool, pool == null);
    }

    @Nonnull
    public JDABuilder setRateLimitPool(@Nullable ScheduledExecutorService pool, boolean automaticShutdown) {
        this.rateLimitPool = pool;
        this.shutdownRateLimitPool = automaticShutdown;
        return this;
    }

    @Nonnull
    public JDABuilder setGatewayPool(@Nullable ScheduledExecutorService pool) {
        return this.setGatewayPool(pool, pool == null);
    }

    @Nonnull
    public JDABuilder setGatewayPool(@Nullable ScheduledExecutorService pool, boolean automaticShutdown) {
        this.mainWsPool = pool;
        this.shutdownMainWsPool = automaticShutdown;
        return this;
    }

    @Nonnull
    public JDABuilder setCallbackPool(@Nullable ExecutorService executor) {
        return this.setCallbackPool(executor, executor == null);
    }

    @Nonnull
    public JDABuilder setCallbackPool(@Nullable ExecutorService executor, boolean automaticShutdown) {
        this.callbackPool = executor;
        this.shutdownCallbackPool = automaticShutdown;
        return this;
    }

    @Nonnull
    public JDABuilder setBulkDeleteSplittingEnabled(boolean enabled) {
        return this.setFlag(ConfigFlag.BULK_DELETE_SPLIT, enabled);
    }

    @Nonnull
    public JDABuilder setEnableShutdownHook(boolean enable) {
        return this.setFlag(ConfigFlag.SHUTDOWN_HOOK, enable);
    }

    @Nonnull
    public JDABuilder setAutoReconnect(boolean autoReconnect) {
        return this.setFlag(ConfigFlag.AUTO_RECONNECT, autoReconnect);
    }

    @Nonnull
    public JDABuilder setEventManager(@Nullable IEventManager manager) {
        this.eventManager = manager;
        return this;
    }

    @Nonnull
    public JDABuilder setAudioSendFactory(@Nullable IAudioSendFactory factory) {
        this.audioSendFactory = factory;
        return this;
    }

    @Nonnull
    public JDABuilder setIdle(boolean idle) {
        this.idle = idle;
        return this;
    }

    @Nonnull
    public JDABuilder setActivity(@Nullable Activity activity) {
        this.activity = activity;
        return this;
    }

    @Nonnull
    public JDABuilder setStatus(@Nullable OnlineStatus status) {
        if (status == null || status == OnlineStatus.UNKNOWN) {
            throw new IllegalArgumentException("OnlineStatus cannot be null or unknown!");
        }
        this.status = status;
        return this;
    }

    @Nonnull
    public JDABuilder addEventListeners(Object ... listeners) {
        Checks.noneNull(listeners, "listeners");
        Collections.addAll(this.listeners, listeners);
        return this;
    }

    @Nonnull
    public JDABuilder removeEventListeners(Object ... listeners) {
        Checks.noneNull(listeners, "listeners");
        this.listeners.removeAll(Arrays.asList(listeners));
        return this;
    }

    @Nonnull
    public JDABuilder setMaxReconnectDelay(int maxReconnectDelay) {
        Checks.check(maxReconnectDelay >= 32, "Max reconnect delay must be 32 seconds or greater. You provided %d.", (Object)maxReconnectDelay);
        this.maxReconnectDelay = maxReconnectDelay;
        return this;
    }

    @Nonnull
    public JDABuilder useSharding(int shardId, int shardTotal) {
        AccountTypeException.check(this.accountType, AccountType.BOT);
        Checks.notNegative(shardId, "Shard ID");
        Checks.positive(shardTotal, "Shard Total");
        Checks.check(shardId < shardTotal, "The shard ID must be lower than the shardTotal! Shard IDs are 0-based.");
        this.shardInfo = new JDA.ShardInfo(shardId, shardTotal);
        return this;
    }

    @Nonnull
    public JDABuilder setSessionController(@Nullable SessionController controller) {
        this.controller = controller;
        return this;
    }

    @Nonnull
    public JDABuilder setVoiceDispatchInterceptor(@Nullable VoiceDispatchInterceptor interceptor) {
        this.voiceDispatchInterceptor = interceptor;
        return this;
    }

    @Nonnull
    public JDA build() throws LoginException {
        WebSocketFactory wsFactory;
        OkHttpClient httpClient = this.httpClient;
        if (httpClient == null) {
            if (this.httpClientBuilder == null) {
                this.httpClientBuilder = new OkHttpClient.Builder();
            }
            httpClient = this.httpClientBuilder.build();
        }
        WebSocketFactory webSocketFactory = wsFactory = this.wsFactory == null ? new WebSocketFactory() : this.wsFactory;
        if (this.controller == null && this.shardInfo != null) {
            this.controller = new SessionControllerAdapter();
        }
        AuthorizationConfig authConfig = new AuthorizationConfig(this.accountType, this.token);
        ThreadingConfig threadingConfig = new ThreadingConfig();
        threadingConfig.setCallbackPool(this.callbackPool, this.shutdownCallbackPool);
        threadingConfig.setGatewayPool(this.mainWsPool, this.shutdownMainWsPool);
        threadingConfig.setRateLimitPool(this.rateLimitPool, this.shutdownRateLimitPool);
        SessionConfig sessionConfig = new SessionConfig(this.controller, httpClient, wsFactory, this.voiceDispatchInterceptor, this.flags, this.maxReconnectDelay);
        MetaConfig metaConfig = new MetaConfig(this.contextMap, this.cacheFlags, this.flags);
        JDAImpl jda = new JDAImpl(authConfig, sessionConfig, threadingConfig, metaConfig);
        if (this.eventManager != null) {
            jda.setEventManager(this.eventManager);
        }
        if (this.audioSendFactory != null) {
            jda.setAudioSendFactory(this.audioSendFactory);
        }
        this.listeners.forEach(xva$0 -> jda.addEventListener(xva$0));
        jda.setStatus(JDA.Status.INITIALIZED);
        ((PresenceImpl)jda.getPresence()).setCacheActivity(this.activity).setCacheIdle(this.idle).setCacheStatus(this.status);
        jda.login(this.shardInfo, this.compression, true);
        return jda;
    }

    private JDABuilder setFlag(ConfigFlag flag, boolean enable) {
        if (enable) {
            this.flags.add(flag);
        } else {
            this.flags.remove((Object)flag);
        }
        return this;
    }
}

